/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.entity;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.metainf.jira.plugin.emailissue.entity.GenericDao;
import com.metainf.jira.plugin.emailissue.entity.NotificationEvent;
import com.metainf.jira.plugin.emailissue.entity.NotificationRecipient;
import com.metainf.jira.plugin.emailissue.entity.NotificationRecipientDao;
import com.metainf.jira.plugin.emailissue.entity.NotificationTemplate;
import com.metainf.jira.plugin.emailissue.entity.Template;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;

public class NotificationEventDao
extends GenericDao<NotificationEvent> {
    private final NotificationRecipientDao notificationRecipientDao;

    public NotificationEventDao(ActiveObjects ao, NotificationRecipientDao notificationRecipientDao) {
        super(ao);
        this.notificationRecipientDao = notificationRecipientDao;
    }

    public NotificationEvent create(final NotificationTemplate notificationTemplate, final Long eventTypeId, final Template template, final boolean customerNotification, final String description) {
        return (NotificationEvent)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<NotificationEvent>(){

            public NotificationEvent doInTransaction() {
                NotificationEvent event = (NotificationEvent)NotificationEventDao.this.ao.create(NotificationEvent.class, new DBParam[0]);
                event.setNotificationTemplate(notificationTemplate);
                event.setEventTypeId(eventTypeId);
                event.setTemplate(template);
                event.setSequenceNumber(1);
                event.setCustomerNotification(customerNotification);
                event.setDescription(description);
                event.save();
                return event;
            }
        });
    }

    public NotificationEvent clone(final NotificationTemplate notificationTemplate, final NotificationEvent ne) {
        return (NotificationEvent)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<NotificationEvent>(){

            public NotificationEvent doInTransaction() {
                NotificationEvent clonedEvent = NotificationEventDao.this.create(notificationTemplate, ne.getEventTypeId(), ne.getTemplate(), ne.isServiceDeskCustomerNotification(), ne.getDescription());
                clonedEvent.setEventTypeIds(ne.getEventTypeIds());
                clonedEvent.setEmailSubject(ne.getEmailSubject());
                clonedEvent.setEmailOptions(ne.getEmailOptions());
                clonedEvent.setJQLFilter(ne.getJQLFilter());
                clonedEvent.setEmailBody(ne.getEmailBody());
                clonedEvent.setAddAttachmentsType(ne.getAddAttachmentsType());
                clonedEvent.setDescription(ne.getDescription());
                clonedEvent.save();
                for (NotificationRecipient nr : ne.getRecipients()) {
                    NotificationRecipient clonedRecipient = NotificationEventDao.this.notificationRecipientDao.create(nr.getRecipientType(), nr.getRecipientKey(), clonedEvent);
                    clonedRecipient.save();
                }
                return clonedEvent;
            }
        });
    }

    public NotificationEvent clone(NotificationEvent notificationEvent) {
        return this.clone(notificationEvent.getNotificationTemplate(), notificationEvent);
    }

    @Override
    public void delete(final NotificationEvent entity) {
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<NotificationEvent>(){

            public NotificationEvent doInTransaction() {
                NotificationRecipient[] recipients = entity.getRecipients();
                NotificationEventDao.this.ao.delete((RawEntity[])recipients);
                NotificationEventDao.this.ao.delete(new RawEntity[]{entity});
                return null;
            }
        });
    }

    @Override
    protected Class<NotificationEvent> getPersistentClass() {
        return NotificationEvent.class;
    }
}

