/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.entity;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.metainf.jira.plugin.emailissue.action.EmailOptions;
import com.metainf.jira.plugin.emailissue.entity.NotificationEventImpl;
import com.metainf.jira.plugin.emailissue.entity.NotificationRecipient;
import com.metainf.jira.plugin.emailissue.entity.NotificationTemplate;
import com.metainf.jira.plugin.emailissue.entity.Template;
import com.metainf.jira.plugin.emailissue.events.ServiceDeskEvent;
import com.metainf.jira.plugin.emailissue.util.ComparatorUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.java.ao.Entity;
import net.java.ao.Implementation;
import net.java.ao.OneToMany;
import net.java.ao.Preload;
import net.java.ao.schema.Ignore;
import net.java.ao.schema.StringLength;
import org.apache.commons.lang.StringUtils;

@Preload
@Implementation(value=NotificationEventImpl.class)
public interface NotificationEvent
extends Entity {
    public static final EventType DEFAULT_EVENT_TYPE = new EventType(Long.valueOf(0L), "Default", "All unassigned event types", Long.valueOf(0L));

    public NotificationTemplate getNotificationTemplate();

    public void setNotificationTemplate(NotificationTemplate var1);

    public Long getEventTypeId();

    public void setEventTypeId(Long var1);

    @StringLength(value=450)
    public String getEventTypeIds();

    public void setEventTypeIds(String var1);

    public Template getTemplate();

    public void setTemplate(Template var1);

    public String getEmailSubject();

    public void setEmailSubject(String var1);

    public String getEmailOptions();

    public void setEmailOptions(String var1);

    @StringLength(value=-1)
    public String getJQLFilter();

    public void setJQLFilter(String var1);

    @StringLength(value=-1)
    public String getEmailBody();

    public void setEmailBody(String var1);

    public String getAddAttachmentsType();

    public void setAddAttachmentsType(String var1);

    @OneToMany
    public NotificationRecipient[] getRecipients();

    public Integer getSequenceNumber();

    public void setSequenceNumber(Integer var1);

    public Boolean isCustomerNotification();

    public void setCustomerNotification(Boolean var1);

    public Boolean isIgnoreMyChangesPref();

    public void setIgnoreMyChangesPref(Boolean var1);

    @Ignore
    public boolean isServiceDeskCustomerNotification();

    @Ignore
    public List<String> getRecipientNames();

    @Ignore
    public List<String> getCopyRecipientNames();

    @Ignore
    public List<String> getBlindCopyRecipientNames();

    @Ignore
    public Set<EventType> getEventTypes();

    @Ignore
    public boolean isIncludesEventType(Long var1);

    @Ignore
    public boolean isIncludesIssueEvent(IssueEvent var1);

    @Ignore
    public String getEventTypeNames();

    @Ignore
    public Set<ServiceDeskEvent> getServiceDeskEventTypes();

    @Ignore
    public EmailOptions getEmailOptionsObject();

    public String getChangelogFilter();

    public void setChangelogFilter(String var1);

    @StringLength(value=-1)
    public String getDescription();

    public void setDescription(String var1);

    public Boolean getDisabled();

    public void setDisabled(Boolean var1);

    @Ignore
    public Set<String> getChangelogFilterNames();

    public static class EntityComparator
    implements Comparator<NotificationEvent> {
        @Override
        public int compare(NotificationEvent o1, NotificationEvent o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 != null && o2 == null) {
                return -1;
            }
            if (o1 == null && o2 != null) {
                return 1;
            }
            if (o1.getEventTypeId() != null && o2.getEventTypeId() == null) {
                return -1;
            }
            if (o1.getEventTypeId() == null && o2.getEventTypeId() != null) {
                return 1;
            }
            if (o1.getEventTypeId() == null && o2.getEventTypeId() == null) {
                int hasJql1 = StringUtils.isBlank((String)o1.getJQLFilter()) ? 0 : 1;
                int hasJql2 = StringUtils.isBlank((String)o2.getJQLFilter()) ? 0 : 1;
                int result = hasJql2 - hasJql1;
                return result == 0 ? (ComparatorUtils.compareNullHigh(o1.getSequenceNumber(), o2.getSequenceNumber()) == 0 ? ComparatorUtils.compareNullHigh(Integer.valueOf(o1.getID()), Integer.valueOf(o2.getID())) : ComparatorUtils.compareNullHigh(o1.getSequenceNumber(), o2.getSequenceNumber())) : result;
            }
            int compareEvents = ComparatorUtils.compareNullHigh(o1.getEventTypeId(), o2.getEventTypeId());
            if (compareEvents == 0) {
                int hasJql1 = StringUtils.isBlank((String)o1.getJQLFilter()) ? 0 : 1;
                int hasJql2 = StringUtils.isBlank((String)o2.getJQLFilter()) ? 0 : 1;
                compareEvents = hasJql2 - hasJql1;
                return compareEvents == 0 ? (ComparatorUtils.compareNullHigh(o1.getSequenceNumber(), o2.getSequenceNumber()) == 0 ? ComparatorUtils.compareNullHigh(Integer.valueOf(o1.getID()), Integer.valueOf(o2.getID())) : ComparatorUtils.compareNullHigh(o1.getSequenceNumber(), o2.getSequenceNumber())) : compareEvents;
            }
            return compareEvents;
        }
    }
}

