/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.entity;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.metainf.jira.plugin.emailissue.entity.AutoReplyParams;
import com.metainf.jira.plugin.emailissue.entity.GenericDao;
import com.metainf.jira.plugin.emailissue.entity.MailHandlerLog;
import com.metainf.jira.plugin.emailissue.handler.MailUtil;
import java.util.Date;
import java.util.HashSet;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public class MailHandlerLogDao
extends GenericDao<MailHandlerLog> {
    public MailHandlerLogDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    protected Class<MailHandlerLog> getPersistentClass() {
        return MailHandlerLog.class;
    }

    public long count(AutoReplyParams ctx) {
        if (ctx == null) {
            return 0L;
        }
        MailHandlerLog[] hits = (MailHandlerLog[])this.filter("MAIL_HANDLER_CONTEXT_ID = ?", new Object[]{ctx.getID()});
        return hits == null ? 0L : (long)hits.length;
    }

    public boolean exists(Message message, AutoReplyParams handler) {
        if (message instanceof MimeMessage) {
            try {
                String messageId = ((MimeMessage)message).getMessageID();
                return this.exists("MAIL_HANDLER_CONTEXT_ID = ? AND MESSAGE_ID = ?", handler.getID(), messageId);
            }
            catch (MessagingException e) {
                return this.existsByAttributes(message);
            }
        }
        return this.existsByAttributes(message);
    }

    protected boolean existsByAttributes(Message message) {
        boolean exists = false;
        try {
            HashSet<String> senders = MailUtil.getSendersInLowerCase(message);
            if (senders != null && !senders.isEmpty()) {
                String from = (String)senders.iterator().next();
                String subject = message.getSubject();
                Date sent = message.getSentDate();
                exists = sent != null ? this.exists("FROM_ADDRESS = ? AND EMAIL_SUBJECT = ? AND SENT_DATE = ?", from, subject, sent) : this.exists("FROM_ADDRESS = ? AND EMAIL_SUBJECT = ? AND SENT_DATE IS NULL", from, subject);
            }
        }
        catch (MessagingException e) {
            return false;
        }
        return exists;
    }
}

