/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.entity;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.transaction.TransactionCallback;
import java.util.Arrays;
import java.util.Collection;
import net.java.ao.DBParam;
import net.java.ao.Entity;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.log4j.Logger;

public abstract class GenericDao<T extends Entity> {
    protected ActiveObjects ao;
    protected Logger logger = Logger.getLogger(this.getClass());

    public GenericDao(ActiveObjects ao) {
        this.ao = ao;
    }

    public T[] filter(String where, Object ... params) {
        return (Entity[])this.ao.find(this.getPersistentClass(), Query.select().where(where, params));
    }

    public T[] filterAndOrder(String where, String orderBy, Object ... params) {
        return (Entity[])this.ao.find(this.getPersistentClass(), Query.select().where(where, params).order(orderBy));
    }

    public T[] filterAndOrderAndLimit(String where, String orderBy, int limit, Object ... params) {
        return (Entity[])this.ao.find(this.getPersistentClass(), Query.select().where(where, params).order(orderBy).limit(limit));
    }

    public T create() {
        return (T)((Entity)this.ao.executeInTransaction(new TransactionCallback<T>(){

            public T doInTransaction() {
                Entity t = (Entity)GenericDao.this.ao.create(GenericDao.this.getPersistentClass(), new DBParam[0]);
                t.save();
                return t;
            }
        }));
    }

    public T newEntity() {
        return (T)((Entity)this.ao.executeInTransaction(new TransactionCallback<T>(){

            public T doInTransaction() {
                Entity t = (Entity)GenericDao.this.ao.create(GenericDao.this.getPersistentClass(), new DBParam[0]);
                return t;
            }
        }));
    }

    public boolean exists(String where, Object ... params) {
        return this.ao.count(this.getPersistentClass(), where, params) > 0;
    }

    public int count(String where, Object ... params) {
        return this.ao.count(this.getPersistentClass(), where, params);
    }

    public boolean exists() {
        return this.ao.count(this.getPersistentClass()) > 0;
    }

    public T getById(Long id) {
        if (id == null) {
            return null;
        }
        Entity[] hits = (Entity[])this.ao.find(this.getPersistentClass(), Query.select().where("ID = ?", new Object[]{id}));
        return (T)(hits == null || hits.length == 0 ? null : hits[0]);
    }

    public void delete(T entity) {
        if (entity != null) {
            this.ao.executeInTransaction(new TransactionCallback<T>((Entity)entity){
                final /* synthetic */ Entity val$entity;
                {
                    this.val$entity = entity;
                }

                public T doInTransaction() {
                    GenericDao.this.ao.delete(new RawEntity[]{this.val$entity});
                    return this.val$entity;
                }
            });
        }
    }

    public T[] findLimited(String orderBy, int limit) {
        return (Entity[])this.ao.find(this.getPersistentClass(), Query.select().order(orderBy).limit(limit));
    }

    public T[] findAll(String orderBy) {
        return (Entity[])this.ao.find(this.getPersistentClass(), Query.select().order(orderBy));
    }

    public T[] findAll() {
        return (Entity[])this.ao.find(this.getPersistentClass());
    }

    public void deleteAll() {
        Entity[] hits = this.findAll();
        int i = 0;
        while (i * 50 < hits.length) {
            final Entity[] chunk = Arrays.copyOfRange(hits, i * 50, Math.min((i + 1) * 50, hits.length));
            this.ao.executeInTransaction(new TransactionCallback<T>(){

                public T doInTransaction() {
                    GenericDao.this.ao.delete((RawEntity[])chunk);
                    return null;
                }
            });
            ++i;
        }
    }

    public void deleteAll(final Collection<T> entities) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        this.ao.executeInTransaction(new TransactionCallback<T>(){

            public T doInTransaction() {
                for (Entity entity : entities) {
                    GenericDao.this.ao.delete(new RawEntity[]{entity});
                }
                return null;
            }
        });
    }

    public void delete(final String where, final Object ... param) {
        this.ao.executeInTransaction(new TransactionCallback<T>(){

            public T doInTransaction() {
                Entity[] hits = GenericDao.this.filter(where, param);
                GenericDao.this.ao.delete((RawEntity[])hits);
                return null;
            }
        });
    }

    public void update(T pw) {
        this.ao.executeInTransaction(new TransactionCallback<T>((Entity)pw){
            final /* synthetic */ Entity val$pw;
            {
                this.val$pw = entity;
            }

            public T doInTransaction() {
                this.val$pw.save();
                return this.val$pw;
            }
        });
    }

    protected abstract Class<T> getPersistentClass();
}

