/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.entity;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.issue.Issue;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.metainf.jira.plugin.emailissue.entity.FieldContext;
import com.metainf.jira.plugin.emailissue.entity.FieldRule;
import com.metainf.jira.plugin.emailissue.entity.GenericDao;
import net.java.ao.RawEntity;

public class FieldContextDao
extends GenericDao<FieldContext> {
    public FieldContextDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    protected Class<FieldContext> getPersistentClass() {
        return FieldContext.class;
    }

    public FieldContext findByProjectAndType(Long projectId, Long issueTypeId) {
        FieldContext[] hits = projectId == null && issueTypeId == null ? (FieldContext[])this.filter("PROJECT_ID IS NULL AND ISSUE_TYPE IS NULL", new Object[0]) : (projectId == null ? (FieldContext[])this.filter("PROJECT_ID IS NULL AND ISSUE_TYPE = ?", new Object[]{issueTypeId}) : (issueTypeId == null ? (FieldContext[])this.filter("PROJECT_ID = ? AND ISSUE_TYPE IS NULL", new Object[]{projectId}) : (FieldContext[])this.filter("PROJECT_ID = ? AND ISSUE_TYPE = ?", new Object[]{projectId, issueTypeId})));
        return hits != null && hits.length > 0 ? hits[0] : null;
    }

    public FieldContext resolve(Issue issue) {
        if (issue == null) {
            return null;
        }
        FieldContext ctx = this.resolve(issue.getProjectId(), Long.parseLong(issue.getIssueTypeId()));
        return ctx;
    }

    @Override
    public void delete(final FieldContext entity) {
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction() {
                for (FieldRule r : entity.getFields()) {
                    FieldContextDao.this.ao.delete(new RawEntity[]{r});
                }
                FieldContextDao.this.ao.delete(new RawEntity[]{entity});
                return null;
            }
        });
    }

    public FieldContext resolve(Long projectId, Long issueTypeId) {
        FieldContext ctx = null;
        if (projectId != null && issueTypeId != null) {
            ctx = this.findByProjectAndType(projectId, issueTypeId);
        }
        if (ctx == null) {
            if (issueTypeId != null) {
                ctx = this.findByProjectAndType(null, issueTypeId);
            }
            if (ctx == null) {
                if (projectId != null) {
                    ctx = this.findByProjectAndType(projectId, null);
                }
                if (ctx == null) {
                    ctx = this.findByProjectAndType(null, null);
                }
            }
        }
        return ctx;
    }
}

