/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.entity;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.issue.Issue;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.metainf.jira.plugin.emailissue.entity.AutoReplyParams;
import com.metainf.jira.plugin.emailissue.entity.GenericDao;
import com.metainf.jira.plugin.emailissue.entity.MailHandlerLog;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class AutoReplyParamsDao
extends GenericDao<AutoReplyParams> {
    public AutoReplyParamsDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    protected Class<AutoReplyParams> getPersistentClass() {
        return AutoReplyParams.class;
    }

    public AutoReplyParams findByProjectAndType(Long projectId, Long issueTypeId) {
        AutoReplyParams[] hits = projectId == null && issueTypeId == null ? (AutoReplyParams[])this.filter("PROJECT_ID IS NULL AND ISSUE_TYPE_ID IS NULL", new Object[0]) : (projectId == null ? (AutoReplyParams[])this.filter("PROJECT_ID IS NULL AND ISSUE_TYPE_ID = ?", new Object[]{issueTypeId}) : (issueTypeId == null ? (AutoReplyParams[])this.filter("PROJECT_ID = ? AND ISSUE_TYPE_ID IS NULL", new Object[]{projectId}) : (AutoReplyParams[])this.filter("PROJECT_ID = ? AND ISSUE_TYPE_ID = ?", new Object[]{projectId, issueTypeId})));
        return hits != null && hits.length > 0 ? hits[0] : null;
    }

    public AutoReplyParams resolveMailHandlerContext(Long projectId, Long issueTypeId) {
        AutoReplyParams[] contexts = (AutoReplyParams[])this.filter("PROJECT_ID = ? AND ISSUE_TYPE_ID = ?", new Object[]{projectId, issueTypeId});
        if (!(contexts != null && contexts.length != 0 || (contexts = (AutoReplyParams[])this.filter("ISSUE_TYPE_ID = ? AND PROJECT_ID IS NULL", new Object[]{issueTypeId})) != null && contexts.length != 0 || (contexts = (AutoReplyParams[])this.filter("PROJECT_ID = ? AND ISSUE_TYPE_ID IS NULL", new Object[]{projectId})) != null && contexts.length != 0)) {
            contexts = (AutoReplyParams[])this.filter("PROJECT_ID IS NULL AND ISSUE_TYPE_ID IS NULL", new Object[0]);
        }
        return contexts == null || contexts.length == 0 ? null : contexts[0];
    }

    public AutoReplyParams resolveMailHandlerContext(Issue issue) {
        return this.resolveMailHandlerContext(issue.getProjectObject().getId(), Long.parseLong(issue.getIssueType().getId()));
    }

    @Override
    public void delete(final AutoReplyParams entity) {
        if (entity != null) {
            this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AutoReplyParams>(){

                public AutoReplyParams doInTransaction() {
                    MailHandlerLog[] hits = (MailHandlerLog[])AutoReplyParamsDao.this.ao.find(MailHandlerLog.class, Query.select().where("MAIL_HANDLER_CONTEXT_ID = ?", new Object[]{entity.getID()}));
                    if (hits != null && hits.length > 0) {
                        AutoReplyParamsDao.this.ao.delete((RawEntity[])hits);
                    }
                    AutoReplyParamsDao.this.ao.delete(new RawEntity[]{entity});
                    return entity;
                }
            });
        }
    }
}

