/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.entity;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.service.util.handler.MessageHandler;
import com.metainf.jira.plugin.emailissue.entity.Template;
import com.metainf.jira.plugin.emailissue.field.FieldContextProcessor;
import com.metainf.jira.plugin.emailissue.handler.CommentWithRegexpHandler;
import com.metainf.jira.plugin.emailissue.handler.CreateAndLinkHandler;
import com.metainf.jira.plugin.emailissue.handler.CreateOrCommentOrLinkHandler;
import com.metainf.jira.plugin.emailissue.handler.CreateOrCommentWithRegexpHandler;
import com.metainf.jira.plugin.emailissue.handler.ServiceDeskHandler;
import com.metainf.jira.plugin.emailissue.searcher.IssueSearcher;
import com.metainf.jira.plugin.emailissue.template.MailTemplateManager;
import com.metainf.jira.plugin.emailissue.util.ComparatorUtils;
import com.metainf.jira.plugin.emailissue.workflow.IssueTransitioner;
import java.util.Comparator;
import net.java.ao.Entity;
import net.java.ao.Preload;
import net.java.ao.schema.StringLength;

@Preload
public interface AutoReplyParams
extends Entity {
    public Long getProjectId();

    public void setProjectId(Long var1);

    public Long getIssueTypeId();

    public void setIssueTypeId(Long var1);

    public Template getTemplate();

    public void setTemplate(Template var1);

    public Template getCommentTemplate();

    public void setCommentTemplate(Template var1);

    public Long getSenderFieldId();

    public void setSenderFieldId(Long var1);

    public Long getSenderNameFieldId();

    public void setSenderNameFieldId(Long var1);

    public Long getRecipientFieldId();

    public void setRecipientFieldId(Long var1);

    public Long getCopyRecipientFieldId();

    public void setCopyRecipientFieldId(Long var1);

    public boolean isUserRecipientsAsWatchers();

    public void setUserRecipientsAsWatchers(boolean var1);

    public Long getUserRecipientFieldId();

    public void setUserRecipientFieldId(Long var1);

    @StringLength(value=-1)
    public String getSplitregex();

    public void setSplitregex(String var1);

    @StringLength(value=-1)
    public String getExcludeEmailsRegex();

    public void setExcludeEmailsRegex(String var1);

    public ProcessingType getProcessingStrategy();

    public void setProcessingStrategy(ProcessingType var1);

    @StringLength(value=-1)
    public String getCommentCriteria();

    public void setCommentCriteria(String var1);

    public Long getLinkType();

    public void setLinkType(Long var1);

    public Long getEventOnEmail();

    public void setEventOnEmail(Long var1);

    public Boolean isExecuteTransition();

    public void setExecuteTransition(Boolean var1);

    public Boolean getInitializeIssueFields();

    public void setInitializeIssueFields(Boolean var1);

    public Boolean getOverrideIssueLookup();

    public void setOverrideIssueLookup(Boolean var1);

    public Boolean isFilterEmails();

    public void setFilterEmails(Boolean var1);

    public Boolean getCustomersToParticipants();

    public void setCustomersToParticipants(Boolean var1);

    public Long getCustomerCreatedTemplateId();

    public void setCustomerCreatedTemplateId(Long var1);

    public Long getParticipantAddedTemplateId();

    public void setParticipantAddedTemplateId(Long var1);

    public String getMailHandlerUser();

    public void setMailHandlerUser(String var1);

    public ServiceDeskCommentVisibility getSdCommentVisibility();

    public void setSdCommentVisibility(ServiceDeskCommentVisibility var1);

    public String getRequestTypeKey();

    public void setRequestTypeKey(String var1);

    public FingerPrintStrategy getFingerPrintStrategy();

    public void setFingerPrintStrategy(FingerPrintStrategy var1);

    public BulkMailStrategy getBulkMailStrategy();

    public void setBulkMailStrategy(BulkMailStrategy var1);

    public Boolean getIgnoreIssueInHeader();

    public void setIgnoreIssueInHeader(Boolean var1);

    public static class EntityComparator
    implements Comparator<AutoReplyParams> {
        @Override
        public int compare(AutoReplyParams o1, AutoReplyParams o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 != null && o2 == null) {
                return -1;
            }
            if (o1 == null && o2 != null) {
                return 1;
            }
            int c = ComparatorUtils.compareNullHigh(o1.getProjectId(), o2.getProjectId());
            if (c == 0) {
                return ComparatorUtils.compareNullHigh(o1.getIssueTypeId(), o2.getIssueTypeId());
            }
            return c;
        }
    }

    public static enum ProcessingType {
        CREATE_OR_COMMENT("email.processing.create.or.comment", false, false){

            @Override
            public MessageHandler getMailHandler(AutoReplyParams mailHandlerContext, IssueLinkManager issueLinkManager, IssueSearcher issueSearcher, FieldContextProcessor fieldContextProcessor, MailTemplateManager mailTemplateManager, IssueTransitioner issueTransitioner, ActiveObjects ao) {
                return new CreateOrCommentWithRegexpHandler(mailHandlerContext, issueLinkManager, fieldContextProcessor);
            }
        }
        ,
        CREATE_OR_COMMENT_OR_LINK("email.processing.create.or.comment.or.link", true, true){

            @Override
            public MessageHandler getMailHandler(AutoReplyParams mailHandlerContext, IssueLinkManager issueLinkManager, IssueSearcher issueSearcher, FieldContextProcessor fieldContextProcessor, MailTemplateManager mailTemplateManager, IssueTransitioner issueTransitioner, ActiveObjects ao) {
                return new CreateOrCommentOrLinkHandler(mailHandlerContext, issueLinkManager, issueSearcher, fieldContextProcessor);
            }
        }
        ,
        CREATE_OR_LOGEMAIL("email.processing.create.or.emaillog", false, false){

            @Override
            public MessageHandler getMailHandler(AutoReplyParams mailHandlerContext, IssueLinkManager issueLinkManager, IssueSearcher issueSearcher, FieldContextProcessor fieldContextProcessor, MailTemplateManager mailTemplateManager, IssueTransitioner issueTransitioner, ActiveObjects ao) {
                return new CreateOrCommentWithRegexpHandler(mailHandlerContext, issueLinkManager, fieldContextProcessor);
            }
        }
        ,
        CREATE("email.processing.create", false, true){

            @Override
            public MessageHandler getMailHandler(AutoReplyParams mailHandlerContext, IssueLinkManager issueLinkManager, IssueSearcher issueSearcher, FieldContextProcessor fieldContextProcessor, MailTemplateManager mailTemplateManager, IssueTransitioner issueTransitioner, ActiveObjects ao) {
                return new CreateAndLinkHandler(mailHandlerContext, issueLinkManager, fieldContextProcessor);
            }
        }
        ,
        COMMENT("email.processing.regex.comment", false, false){

            @Override
            public MessageHandler getMailHandler(AutoReplyParams mailHandlerContext, IssueLinkManager issueLinkManager, IssueSearcher issueSearcher, FieldContextProcessor fieldContextProcessor, MailTemplateManager mailTemplateManager, IssueTransitioner issueTransitioner, ActiveObjects ao) {
                return new CommentWithRegexpHandler(mailHandlerContext, fieldContextProcessor);
            }
        }
        ,
        SERVICEDESK("email.processing.servicedesk", true, true){

            @Override
            public MessageHandler getMailHandler(AutoReplyParams mailHandlerContext, IssueLinkManager issueLinkManager, IssueSearcher issueSearcher, FieldContextProcessor fieldContextProcessor, MailTemplateManager mailTemplateManager, IssueTransitioner issueTransitioner, ActiveObjects ao) {
                return new ServiceDeskHandler(mailHandlerContext, issueLinkManager, issueSearcher, fieldContextProcessor, mailTemplateManager, issueTransitioner, ao);
            }
        };

        private final String labelKey;
        private final boolean commentCriteriaEnabled;
        private final boolean linkEnabled;

        private ProcessingType(String labelKey, boolean commentCriteriaEnabled, boolean linkEnabled) {
            this.labelKey = labelKey;
            this.commentCriteriaEnabled = commentCriteriaEnabled;
            this.linkEnabled = linkEnabled;
        }

        public abstract MessageHandler getMailHandler(AutoReplyParams var1, IssueLinkManager var2, IssueSearcher var3, FieldContextProcessor var4, MailTemplateManager var5, IssueTransitioner var6, ActiveObjects var7);

        public String getLabelKey() {
            return this.labelKey;
        }

        public String getDescriptionKey() {
            return this.getLabelKey() + ".desc";
        }

        public boolean isCommentCriteriaEnabled() {
            return this.commentCriteriaEnabled;
        }

        public boolean isLinkEnabled() {
            return this.linkEnabled;
        }
    }

    public static enum ServiceDeskCommentVisibility {
        DEFAULT,
        PUBLIC,
        INTERNAL;

    }

    public static enum FingerPrintStrategy {
        ACCEPT_ALL(true, true),
        ACCEPT_OTHER_JIRA(false, true),
        ACCEPT_THIS_JIRA(true, false),
        ACCEPT_NONE(false, false);

        private boolean acceptsThis;
        private boolean acceptsOther;

        private FingerPrintStrategy(boolean acceptsThis, boolean acceptsOther) {
            this.acceptsThis = acceptsThis;
            this.acceptsOther = acceptsOther;
        }

        public boolean isAcceptsThis() {
            return this.acceptsThis;
        }

        public boolean isAcceptsOther() {
            return this.acceptsOther;
        }
    }

    public static enum BulkMailStrategy {
        ACCEPT_FOR_PROCESSING,
        FORWARD,
        DELETE,
        IGNORE;

    }
}

