/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.entity;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.metainf.jira.plugin.emailissue.entity.AuditLogEntry;
import com.metainf.jira.plugin.emailissue.entity.GenericDao;
import com.metainf.jira.plugin.emailissue.entity.Template;
import com.metainf.jira.plugin.emailissue.util.StringUtil;
import java.util.Date;
import net.java.ao.DBParam;
import org.apache.commons.lang.StringUtils;

public class AuditLogDao
extends GenericDao<AuditLogEntry> {
    public AuditLogDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    protected Class<AuditLogEntry> getPersistentClass() {
        return AuditLogEntry.class;
    }

    public AuditLogEntry create(final ApplicationUser sender, final Issue issue, final String subject, final String body, final String from, final String fromName, final String to, final String cc, final String bcc, final String format, final boolean replyToMe, final boolean mailAsMe, final boolean addToWatchers, final String attachments, final Template template, final String source, final boolean isAddComments, final AuditLogEntry.EmailType type) {
        return (AuditLogEntry)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AuditLogEntry>(){

            public AuditLogEntry doInTransaction() {
                AuditLogEntry auditLogEntry = (AuditLogEntry)AuditLogDao.this.ao.create(AuditLogDao.this.getPersistentClass(), new DBParam[0]);
                auditLogEntry.setAddComments(isAddComments);
                auditLogEntry.setAddToWatchers(addToWatchers);
                auditLogEntry.setAttachments(StringUtils.isNotBlank((String)attachments) ? attachments : null);
                auditLogEntry.setBcc(StringUtils.isNotBlank((String)bcc) ? bcc : null);
                auditLogEntry.setCc(StringUtils.isNotBlank((String)cc) ? cc : null);
                auditLogEntry.setEmailBody(StringUtils.isNotBlank((String)body) ? StringUtil.sanitize(body) : null);
                auditLogEntry.setEmailFormat(StringUtils.isNotBlank((String)format) ? format : null);
                auditLogEntry.setEmailSubject(StringUtils.isNotBlank((String)subject) ? StringUtil.sanitize(subject) : null);
                auditLogEntry.setFrom(from);
                auditLogEntry.setFromName(StringUtil.sanitize(fromName));
                auditLogEntry.setIssueId(issue.getId());
                auditLogEntry.setIssueKey(issue.getKey());
                auditLogEntry.setIssueSummary(StringUtil.sanitize(issue.getSummary()));
                auditLogEntry.setMailAsMe(mailAsMe);
                auditLogEntry.setReplyToMe(replyToMe);
                auditLogEntry.setSenderKey(sender == null ? null : sender.getKey());
                auditLogEntry.setSenderName(sender == null ? null : sender.getDisplayName());
                auditLogEntry.setSendTimeStamp(new Date());
                auditLogEntry.setSource(StringUtils.isNotBlank((String)source) ? source : null);
                auditLogEntry.setTemplateId(template != null ? Integer.valueOf(template.getID()) : null);
                auditLogEntry.setTemplateName(template != null ? template.getName() : null);
                auditLogEntry.setRecipients(StringUtils.isNotBlank((String)to) ? to : null);
                auditLogEntry.setType(type);
                auditLogEntry.save();
                return auditLogEntry;
            }
        });
    }
}

