/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.desk;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.issue.comment.property.CommentPropertyHelper;
import com.atlassian.jira.bc.issue.properties.IssuePropertyHelper;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentPermissionManager;
import com.atlassian.jira.issue.comments.CommentSearchManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActor;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorDoesNotExistException;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.mail.Email;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.atlassian.plugin.PluginAccessor;
import com.metainf.jira.plugin.emailissue.desk.CustomerRequestType;
import com.metainf.jira.plugin.emailissue.desk.DefaultDBProvider;
import com.metainf.jira.plugin.emailissue.desk.DeskDBProvider;
import com.metainf.jira.plugin.emailissue.desk.HiddenPortalField;
import com.metainf.jira.plugin.emailissue.desk.MySQLDBProvider;
import com.metainf.jira.plugin.emailissue.desk.PostgreSQLDBProvider;
import com.metainf.jira.plugin.emailissue.desk.SQLServerDBProvider;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskDetails;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskManager;
import com.metainf.jira.plugin.emailissue.entity.DefaultTemplate;
import com.metainf.jira.plugin.emailissue.entity.OfBizDao;
import com.metainf.jira.plugin.emailissue.entity.Template;
import com.metainf.jira.plugin.emailissue.entity.TemplateDao;
import com.metainf.jira.plugin.emailissue.template.EmailTemplateTheme;
import com.metainf.jira.plugin.emailissue.template.TemplateRenderer;
import com.metainf.jira.plugin.emailissue.template.TemplateRendererImpl;
import com.metainf.jira.plugin.emailissue.util.CustomFieldUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ServiceDeskManagerImpl
implements ServiceDeskManager {
    private final OfBizDao ofBizDao;
    private final PluginAccessor pluginAccessor;
    private final ProjectRoleManager projectRoleManager;
    private final UserUtil userUtil;
    private final UserManager userManager;
    private final CrowdService crowdService;
    private final JsonEntityPropertyManager jsonEntityPropertyManager;
    private final DatabaseConfigurationManager databaseConfigurationManager;
    private final TemplateDao templateDao;
    private final ProjectManager projectManager;
    private final UserService userService;
    private final TemplateRenderer templateRenderer;
    public static final String SERVICE_DESK_CUSTOMER_ROLE = "Service Desk Customers";
    private static final String SERVICE_DESK_AGENT_ROLE = "Service Desk Team";
    private static final String SERVICE_DESK_COLLABORATOR_ROLE = "Service Desk Collaborators";
    private static final String INVITE_TOKEN = "\"value\":{0},\"expiry\":{1},\"projectIds\":[{2}]";
    private static final String INVITE_URL = "{0}/servicedesk/customer/portal/{1}/user/visitportal?username={2}&token={3}";
    private static final String CUSTOMERPORTAL_LINK = "%s/servicedesk/customer/portal/%s";
    private static DeskDBProvider dbProvider;
    private static final Map<String, DeskDBProvider> dbProviders;
    private Logger logger = Logger.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ServiceDeskManagerImpl(ProjectManager projectManager, OfBizDelegator ofBizDelegator, PluginAccessor pluginAccessor, ProjectRoleManager projectRoleManager, ActiveObjects ao, UserService userService) {
        Class<DeskDBProvider> clazz;
        this.projectManager = projectManager;
        this.ofBizDao = new OfBizDao(ofBizDelegator);
        this.templateDao = new TemplateDao(ao);
        this.userService = userService;
        this.templateRenderer = new TemplateRendererImpl(ComponentAccessor.getVelocityManager());
        this.databaseConfigurationManager = (DatabaseConfigurationManager)ComponentAccessor.getComponent(DatabaseConfigurationManager.class);
        if (dbProvider == null) {
            clazz = DeskDBProvider.class;
            // MONITORENTER : com.metainf.jira.plugin.emailissue.desk.DeskDBProvider.class
            if (dbProvider == null) {
                DatabaseConfig databaseConfig = this.databaseConfigurationManager.getDatabaseConfiguration();
                dbProvider = databaseConfig.isPostgres() ? new PostgreSQLDBProvider(databaseConfig.getSchemaName()) : (databaseConfig.isMySql() ? new MySQLDBProvider() : (databaseConfig.isSqlServer() ? new SQLServerDBProvider(databaseConfig.getSchemaName()) : (databaseConfig.isOracle() ? new DefaultDBProvider() : new DefaultDBProvider())));
            }
            // MONITOREXIT : clazz
        }
        if (dbProvider == null) {
            clazz = DeskDBProvider.class;
            // MONITORENTER : com.metainf.jira.plugin.emailissue.desk.DeskDBProvider.class
            if (dbProvider == null) {
                dbProvider = dbProviders.get(this.ofBizDao.getDbDriver()) != null ? dbProviders.get(this.ofBizDao.getDbDriver()) : new DefaultDBProvider();
            }
            // MONITOREXIT : clazz
        }
        this.pluginAccessor = pluginAccessor;
        this.projectRoleManager = projectRoleManager;
        this.userUtil = ComponentAccessor.getUserUtil();
        this.userManager = ComponentAccessor.getUserManager();
        this.crowdService = ComponentAccessor.getCrowdService();
        this.jsonEntityPropertyManager = (JsonEntityPropertyManager)ComponentAccessor.getComponentOfType(JsonEntityPropertyManager.class);
    }

    @Override
    public boolean isServiceDeskAddOnEnabled() {
        return this.pluginAccessor.isPluginEnabled("com.atlassian.servicedesk");
    }

    protected ProjectRole getServiceDeskCustomersRole() {
        return this.projectRoleManager.getProjectRole(SERVICE_DESK_CUSTOMER_ROLE);
    }

    @Override
    public boolean isServiceDeskProject(Long projectId) {
        Boolean serviceDesk = this.ofBizDao.findFirst(dbProvider.getSelectServiceDeskDetails(projectId), new OfBizDao.ResultReader<Boolean>(){

            @Override
            public Boolean read(ResultSet rs) throws SQLException {
                String disabled = rs.getString("DISABLED");
                1 v0 = this;
                ServiceDeskManagerImpl.this.logger.info((Object)("Service Desk Project disabled? " + disabled + ", " + !dbProvider.booleanValueOf(disabled)));
                1 v1 = this;
                return !dbProvider.booleanValueOf(disabled);
            }
        });
        this.logger.info((Object)("Service Desk Project? " + serviceDesk));
        return Boolean.TRUE.equals(serviceDesk);
    }

    @Override
    public String getCustomerRequestTypeForIssue(Issue issue) {
        Map<String, String> portal = this.ofBizDao.findFirst(dbProvider.getSelectPortalKey(issue.getProjectId()), new OfBizDao.ResultReader<Map<String, String>>(){

            @Override
            public Map<String, String> read(ResultSet rs) throws SQLException {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("portalId", rs.getString("ID"));
                result.put("key", rs.getString("KEY"));
                return result;
            }
        });
        String customerRequestTypeKey = null;
        if (portal != null && StringUtils.isNotBlank((String)portal.get("key")) && StringUtils.isNotBlank((String)portal.get("portalId"))) {
            String key = this.ofBizDao.findFirst(dbProvider.getSelectCustomerRequestTypeKey(issue.getIssueTypeId(), portal.get("portalId")), new OfBizDao.ResultReader<String>(){

                @Override
                public String read(ResultSet rs) throws SQLException {
                    return rs.getString("KEY");
                }
            });
            if (StringUtils.isNotBlank((String)key)) {
                customerRequestTypeKey = portal.get("key") + "/" + key;
            }
        }
        return customerRequestTypeKey;
    }

    @Override
    public Collection<CustomerRequestType> getCustomerRequestTypesForIssue(Issue issue) {
        return this.getCustomerRequestTypes(issue.getProjectId(), issue.getIssueTypeId());
    }

    @Override
    public Collection<CustomerRequestType> getCustomerRequestTypes(long projectId, String issueTypeId) {
        final Map<String, String> portal = this.ofBizDao.findFirst(dbProvider.getSelectPortalKey(projectId), new OfBizDao.ResultReader<Map<String, String>>(){

            @Override
            public Map<String, String> read(ResultSet rs) throws SQLException {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("portalId", rs.getString("ID"));
                result.put("key", rs.getString("KEY"));
                return result;
            }
        });
        List<CustomerRequestType> customerRequestTypeKeys = new LinkedList<CustomerRequestType>();
        if (portal != null && StringUtils.isNotBlank((String)portal.get("key")) && StringUtils.isNotBlank((String)portal.get("portalId"))) {
            customerRequestTypeKeys = this.ofBizDao.findAll(dbProvider.getSelectCustomerRequestTypeKey(issueTypeId, portal.get("portalId")), new OfBizDao.ResultReader<CustomerRequestType>(){

                @Override
                public CustomerRequestType read(ResultSet rs) throws SQLException {
                    return new CustomerRequestType(rs.getLong("ID"), (String)portal.get("key") + "/" + rs.getString("KEY"), rs.getString("NAME"));
                }
            });
        }
        return customerRequestTypeKeys;
    }

    @Override
    public boolean userHasPortalAccess(ApplicationUser user, Project project, ServiceDeskDetails serviceDesk) {
        boolean portalAccess = false;
        if (project != null && user != null && serviceDesk != null) {
            if (serviceDesk.getPoartalAccessType() == ServiceDeskDetails.PortalAccessType.CUSTOMER_ROLE) {
                ProjectRole customerRole = this.getServiceDeskCustomersRole();
                if (customerRole != null) {
                    portalAccess = this.projectRoleManager.isUserInProjectRole(user, customerRole, project);
                }
            } else {
                portalAccess = true;
            }
        }
        this.logger.debug((Object)("User has portal access: " + user + ", " + portalAccess));
        return portalAccess;
    }

    @Override
    public boolean isUserAgent(ApplicationUser applicationUser, Project project) {
        ProjectRole agentRole = this.projectRoleManager.getProjectRole(SERVICE_DESK_AGENT_ROLE);
        if (agentRole != null && applicationUser != null && project != null) {
            return this.projectRoleManager.isUserInProjectRole(applicationUser, agentRole, project);
        }
        return false;
    }

    @Override
    public boolean isUserCollaborator(ApplicationUser applicationUser, Project project) {
        ProjectRole collabRole = this.projectRoleManager.getProjectRole(SERVICE_DESK_COLLABORATOR_ROLE);
        if (collabRole != null && applicationUser != null && project != null) {
            return this.projectRoleManager.isUserInProjectRole(applicationUser, collabRole, project);
        }
        return false;
    }

    @Override
    public ServiceDeskDetails getServiceDeskDetails(Long projectId) {
        if (projectId == null) {
            return null;
        }
        ServiceDeskDetails deskDetails = this.ofBizDao.findFirst(dbProvider.getSelectServiceDeskDetails(projectId), new OfBizDao.ResultReader<ServiceDeskDetails>(){

            @Override
            public ServiceDeskDetails read(ResultSet rs) throws SQLException {
                String disabled = rs.getString("DISABLED");
                ServiceDeskManagerImpl.this.logger.debug((Object)("sd.disabled: " + disabled));
                6 v0 = this;
                if (dbProvider.booleanValueOf(disabled)) {
                    return null;
                }
                String id = rs.getString("ID");
                String openAccess = rs.getString("OPEN_CUSTOMER_ACCESS");
                String publicSignup = rs.getString("PUBLIC_SIGNUP");
                ServiceDeskManagerImpl.this.logger.debug((Object)("sd.publicSignup: " + publicSignup));
                ServiceDeskDetails desk = new ServiceDeskDetails();
                if (id != null) {
                    desk.setId(Long.valueOf(id));
                }
                if ("1".equals(publicSignup)) {
                    desk.setPoartalAccessType(ServiceDeskDetails.PortalAccessType.PUBLIC_SIGNUP);
                } else if ("1".equals(openAccess)) {
                    desk.setPoartalAccessType(ServiceDeskDetails.PortalAccessType.EVERYONE_WITH_ACCOUNT_WITHOUT_SIGNUP);
                } else {
                    desk.setPoartalAccessType(ServiceDeskDetails.PortalAccessType.CUSTOMER_ROLE);
                }
                return desk;
            }
        });
        if (deskDetails != null) {
            String participants = this.ofBizDao.findFirst(dbProvider.getSelectParticipantSettings(deskDetails.getId()), new OfBizDao.ResultReader<String>(){

                @Override
                public String read(ResultSet rs) throws SQLException {
                    return rs.getString("MANAGE_ENABLED");
                }
            });
            this.logger.debug((Object)("sd.participants: " + participants + ", " + dbProvider.booleanValueOf(participants)));
        }
        this.logger.debug((Object)("Service Desk Details. " + deskDetails));
        return deskDetails;
    }

    @Override
    public ApplicationUser createNewCustomer(String emailAddress, Long projectId, Long customerCreatedTemplateId) {
        this.logger.debug((Object)(".createNewCustomer() called: " + emailAddress));
        ApplicationUser customerCreated = null;
        try {
            if (ApplicationUsers.byKey((String)emailAddress) == null || !this.userUtil.userExists(emailAddress) || UserUtils.getUserByEmail((String)emailAddress) == null) {
                this.logger.debug((Object)"No existing user found");
                Directory internalDirectory = null;
                for (Directory userDirectory : this.userManager.getWritableDirectories()) {
                    if (userDirectory.getType() != DirectoryType.INTERNAL && !userDirectory.getName().equalsIgnoreCase("JIRA Internal Directory")) continue;
                    internalDirectory = userDirectory;
                    break;
                }
                this.logger.debug((Object)("User Directory for new customer: " + internalDirectory));
                if (internalDirectory != null) {
                    emailAddress = StringUtils.trim((String)emailAddress);
                    ApplicationUser admin = this.getAdminUser();
                    this.logger.debug((Object)("Admin user bneing used to create new customer: " + admin));
                    if (admin != null) {
                        UserService.CreateUserRequest createUserRequest = UserService.CreateUserRequest.withUserDetails((ApplicationUser)admin, (String)emailAddress, null, (String)emailAddress, (String)emailAddress).withNoApplicationAccess().sendNotification(false);
                        UserService.CreateUserValidationResult validationResult = this.userService.validateCreateUser(createUserRequest);
                        this.logger.debug((Object)("CreateUserRequest valid: " + validationResult.isValid()));
                        if (validationResult.isValid()) {
                            ApplicationUser customer = this.userService.createUser(validationResult);
                            this.logger.debug((Object)("new customer object: " + customer));
                            if (customer != null) {
                                SortedSet groups = this.userUtil.getGroupsForUser(customer.getName());
                                this.userUtil.removeUserFromGroups((Collection)groups, customer);
                                customerCreated = customer;
                                UserUtil.PasswordResetToken token = this.userUtil.generatePasswordResetToken(customer);
                                ServiceDeskDetails desk = this.getServiceDeskDetails(projectId);
                                if (token != null && desk != null) {
                                    String inviteToken = this.generateInviteToken(token, projectId);
                                    this.crowdService.setUserAttribute(customer.getDirectoryUser(), "local.servicedesk.outstanding.agent.invites", inviteToken);
                                    this.crowdService.setUserAttribute(customer.getDirectoryUser(), "local.servicedesk.external.invite", "true");
                                    this.crowdService.setUserAttribute(customer.getDirectoryUser(), "local.servicedesk.external", "true");
                                    this.crowdService.setUserAttribute(customer.getDirectoryUser(), "synch.servicedesk.requestor", "true");
                                    Project project = projectId == null ? null : this.projectManager.getProjectObj(projectId);
                                    this.addToCustomerRole(customerCreated, project);
                                    this.logger.debug((Object)"Added to customer role");
                                    this.sendInvitation(customer, token.getToken(), desk, project, customerCreatedTemplateId);
                                    this.logger.debug((Object)"Invitation sent");
                                }
                            }
                        } else {
                            if (validationResult.getErrorCollection().hasAnyErrors()) {
                                this.logger.debug((Object)("Failed to create new customer: " + validationResult.getErrorCollection().getErrors().toString()));
                            }
                            if (validationResult.getErrorCollection().getErrorMessages() != null && validationResult.getErrorCollection().getErrorMessages().size() > 0) {
                                this.logger.debug((Object)("Failed to create new customer: " + StringUtils.join((Collection)validationResult.getErrorCollection().getErrorMessages(), (String)",")));
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        return customerCreated;
    }

    private void addToCustomerRole(ApplicationUser customerCreated, Project project) {
        RoleActorFactory roleActorFactory;
        ProjectRoleActors actors;
        ProjectRoleManager projectRoleManager = (ProjectRoleManager)ComponentAccessor.getComponentOfType(ProjectRoleManager.class);
        ProjectRole customerRole = this.getServiceDeskCustomersRole();
        if (customerRole != null && (actors = projectRoleManager.getProjectRoleActors(customerRole, project)) != null && (roleActorFactory = (RoleActorFactory)ComponentAccessor.getComponentOfType(RoleActorFactory.class)) != null) {
            try {
                ProjectRoleActor customerActor = roleActorFactory.createRoleActor(null, customerRole.getId(), project.getId(), "atlassian-user-role-actor", customerCreated.getKey());
                if (customerActor != null) {
                    projectRoleManager.updateProjectRoleActors((ProjectRoleActors)actors.addRoleActor((RoleActor)customerActor));
                    ComponentAccessor.getIssueSecurityLevelManager().clearUsersLevels();
                }
            }
            catch (RoleActorDoesNotExistException e) {
                this.logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void sendInvitation(ApplicationUser customer, String token, ServiceDeskDetails deskDetails, Project project, Long customerCreatedTemplateId) throws UnsupportedEncodingException {
        if (customerCreatedTemplateId == null || customerCreatedTemplateId != -1L) {
            com.atlassian.jira.mail.Email email = new com.atlassian.jira.mail.Email(customer.getEmailAddress());
            String baseUrl = ComponentAccessor.getApplicationProperties().getString("jira.baseurl");
            String inviteLink = MessageFormat.format(INVITE_URL, baseUrl, String.valueOf(deskDetails.getId()), URLEncoder.encode(customer.getEmailAddress(), "UTF-8"), token);
            email.setMimeType("text/html");
            Template emailTemplate = this.getInvitationTemplate(customerCreatedTemplateId);
            HashMap<String, String> contextParams = new HashMap<String, String>();
            contextParams.put("invitationLink", inviteLink);
            contextParams.put("project", (String)project);
            String subject = this.templateRenderer.renderTextContent(emailTemplate.getSubject(), baseUrl, contextParams);
            String emailBody = this.templateRenderer.renderHtmlContent(emailTemplate.getHtml(), baseUrl, contextParams);
            email.setSubject(subject);
            email.setBody(emailBody);
            SingleMailQueueItem item = new SingleMailQueueItem((Email)email);
            ComponentAccessor.getMailQueue().addItem((MailQueueItem)item);
        }
    }

    private String generateInviteToken(UserUtil.PasswordResetToken token, Long projectId) {
        String invite = MessageFormat.format(INVITE_TOKEN, "\"" + token.getToken() + "\"", String.valueOf(token.getExpiryTime()), String.valueOf(projectId));
        return "{" + invite + "}";
    }

    @Override
    public boolean isInternalComment(Comment comment) {
        boolean internal = false;
        if (comment != null) {
            EntityProperty ep = this.jsonEntityPropertyManager.get("sd.comment.property", comment.getId(), "sd.public.comment");
            if (ep == null) {
                ep = this.jsonEntityPropertyManager.get("CommentProperty", comment.getId(), "sd.public.comment");
            }
            if (ep != null && ep.getValue() != null) {
                try {
                    JSONObject jo = new JSONObject(ep.getValue());
                    if (jo != null) {
                        internal = jo.getBoolean("internal");
                    }
                }
                catch (JSONException e) {
                    this.logger.info((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return internal;
    }

    @Override
    public void makeCommentInternalOrPublic(Comment comment, ApplicationUser author, boolean internal) {
        if (comment != null) {
            JSONObject jo = new JSONObject();
            try {
                jo.put("internal", internal);
                CommentPermissionManager commentPermissionManager = (CommentPermissionManager)ComponentAccessor.getComponentOfType(CommentPermissionManager.class);
                CommentSearchManager commentSearchManager = (CommentSearchManager)ComponentAccessor.getComponentOfType(CommentSearchManager.class);
                if (commentPermissionManager != null && commentSearchManager != null) {
                    CommentPropertyHelper commentPropertyHelper = new CommentPropertyHelper(commentPermissionManager, commentSearchManager, ComponentAccessor.getJiraAuthenticationContext().getI18nHelper());
                    this.jsonEntityPropertyManager.put(author, "sd.comment.property", comment.getId(), "sd.public.comment", jo.toString(), commentPropertyHelper.createSetPropertyEventBiFunction(), false);
                    this.jsonEntityPropertyManager.put(author, "CommentProperty", comment.getId(), "sd.public.comment", jo.toString(), commentPropertyHelper.createSetPropertyEventBiFunction(), false);
                }
            }
            catch (JSONException e) {
                this.logger.info((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setChannelType(Issue issue, ApplicationUser author) {
        if (issue != null && issue.getId() != null) {
            JSONObject jo = new JSONObject();
            try {
                jo.put("value", (Object)"email");
                IssuePropertyHelper issuePropertyHelper = new IssuePropertyHelper(ComponentAccessor.getI18nHelperFactory().getInstance(author), ComponentAccessor.getIssueManager(), ComponentAccessor.getPermissionManager());
                this.jsonEntityPropertyManager.put(author, "IssueProperty", issue.getId(), "request.channel.type", jo.toString(), issuePropertyHelper.createSetPropertyEventBiFunction(), false);
            }
            catch (JSONException e) {
                this.logger.info((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private Template getInvitationTemplate(Long templateId) {
        Template invitationTemplate = null;
        if (templateId != null && templateId > 0L) {
            invitationTemplate = (Template)this.templateDao.getById(templateId);
        }
        return invitationTemplate == null ? DefaultTemplate.fromTheme(EmailTemplateTheme.SD_WELCOME) : invitationTemplate;
    }

    private Template getParticipantAddedTemplate(Long templateId) {
        Template participantTemplate = null;
        if (templateId != null && templateId > 0L) {
            participantTemplate = (Template)this.templateDao.getById(templateId);
        }
        return participantTemplate == null ? DefaultTemplate.fromTheme(EmailTemplateTheme.SD_PARTICIPANT_ADDED) : participantTemplate;
    }

    public ApplicationUser getAdminUser() {
        ApplicationUser sysAdmin = null;
        this.logger.debug((Object)".getAdminUser() called");
        Collection groupNames = ComponentAccessor.getGlobalPermissionManager().getGroupNamesWithPermission(GlobalPermissionKey.SYSTEM_ADMIN);
        this.logger.debug((Object)("SYSADMIN groups: " + groupNames));
        for (String s : groupNames) {
            Collection users;
            Group g = ComponentAccessor.getGroupManager().getGroup(s);
            this.logger.debug((Object)("Group checked: " + g));
            if (g == null || (users = ComponentAccessor.getGroupManager().getUsersInGroup(g)) == null || users.isEmpty()) continue;
            sysAdmin = (ApplicationUser)users.iterator().next();
            break;
        }
        this.logger.debug((Object)("Admin user found: " + sysAdmin));
        return sysAdmin;
    }

    private Collection<ApplicationUser> createOrGetCustomersByEmailAddress(ServiceDeskDetails serviceDesk, Project sdProject, Collection<String> emailAddresses, Long customerCreatedTemplateId) {
        HashSet<ApplicationUser> participants = new HashSet<ApplicationUser>();
        for (String recipientEmailAddress : emailAddresses) {
            ApplicationUser userByEmail = UserUtils.getUserByEmail((String)recipientEmailAddress);
            if (userByEmail == null && serviceDesk.isOpenForPublicSignup()) {
                ApplicationUser newCustomer = this.createNewCustomer(recipientEmailAddress, sdProject.getId(), customerCreatedTemplateId);
                if (newCustomer == null) continue;
                participants.add(newCustomer);
                continue;
            }
            if (!this.userHasPortalAccess(userByEmail, sdProject, serviceDesk)) continue;
            participants.add(userByEmail);
        }
        return participants;
    }

    @Override
    public Collection<ApplicationUser> addParticipantsInIssue(MutableIssue mutableIssue, ServiceDeskDetails serviceDesk, Collection<String> participantEmailAddresses, ApplicationUser customer, Long customerCreatedTemplateId) {
        this.logger.debug((Object)".addParticipantsInIssue() called");
        Collection<ApplicationUser> participantsToAdd = this.createOrGetCustomersByEmailAddress(serviceDesk, mutableIssue.getProjectObject(), participantEmailAddresses, customerCreatedTemplateId);
        CustomField participantsField = CustomFieldUtil.getServiceDeskRequestParticipantsField(ComponentAccessor.getCustomFieldManager().getCustomFieldObjects((Issue)mutableIssue));
        if (participantsField != null) {
            Collection currentParticipants = (Collection)mutableIssue.getCustomFieldValue(participantsField);
            HashSet<ApplicationUser> participants = new HashSet<ApplicationUser>();
            if (currentParticipants != null) {
                participantsToAdd.removeAll(currentParticipants);
                participants.addAll(currentParticipants);
            }
            participantsToAdd.remove(customer);
            participantsToAdd.remove(mutableIssue.getReporter());
            ProjectRole sdTeamRole = ((ProjectRoleManager)ComponentAccessor.getComponentOfType(ProjectRoleManager.class)).getProjectRole(SERVICE_DESK_AGENT_ROLE);
            Iterator<ApplicationUser> it = participantsToAdd.iterator();
            while (it.hasNext()) {
                ApplicationUser pariticipant = it.next();
                if (this.isAllowedAsParticipant(pariticipant, mutableIssue, serviceDesk, sdTeamRole)) {
                    participants.add(pariticipant);
                    continue;
                }
                it.remove();
            }
            mutableIssue.setCustomFieldValue(participantsField, participants);
            return participantsToAdd;
        }
        return new HashSet<ApplicationUser>();
    }

    private boolean isAllowedAsParticipant(ApplicationUser pariticipant, MutableIssue mutableIssue, ServiceDeskDetails serviceDesk, ProjectRole sdTeamRole) {
        boolean allowed = true;
        if (sdTeamRole != null && ((ProjectRoleManager)ComponentAccessor.getComponentOfType(ProjectRoleManager.class)).isUserInProjectRole(pariticipant, sdTeamRole, mutableIssue.getProjectObject())) {
            allowed = false;
        } else if (ComponentAccessor.getPermissionManager().hasPermission(ProjectPermissions.BROWSE_PROJECTS, (Issue)mutableIssue, pariticipant)) {
            allowed = false;
        }
        return allowed;
    }

    @Override
    public void sendParticipantAddedEmail(Issue issue, ServiceDeskDetails serviceDesk, Collection<ApplicationUser> participants, ApplicationUser customerWhoAddedTheParticipant, Long participantAddedTemplateId) {
        if (participantAddedTemplateId == null || participantAddedTemplateId > 0L) {
            String baseUrl = ComponentAccessor.getApplicationProperties().getString("jira.baseurl");
            Template emailTemplate = this.getParticipantAddedTemplate(participantAddedTemplateId);
            for (ApplicationUser participant : participants) {
                com.atlassian.jira.mail.Email email = new com.atlassian.jira.mail.Email(participant.getEmailAddress());
                email.setMimeType("text/html");
                HashMap<String, Object> contextParams = new HashMap<String, Object>();
                contextParams.put("project", issue.getProjectObject());
                contextParams.put("issue", issue);
                contextParams.put("sender", customerWhoAddedTheParticipant);
                contextParams.put("participant", participant);
                contextParams.put("linkToIssueInCustomerPortal", this.getLinkToIssueInCustomerPortal(serviceDesk, issue));
                contextParams.put("linkToCustomerPortal", this.getLinkToCustomerPortal(serviceDesk));
                String subject = this.templateRenderer.renderTextContent(emailTemplate.getSubject(), baseUrl, contextParams);
                String emailBody = this.templateRenderer.renderHtmlContent(emailTemplate.getHtml(), baseUrl, contextParams);
                email.setSubject(subject);
                email.setBody(emailBody);
                SingleMailQueueItem item = new SingleMailQueueItem((Email)email);
                ComponentAccessor.getMailQueue().addItem((MailQueueItem)item);
            }
        }
    }

    @Override
    public String getLinkToCustomerPortal(ServiceDeskDetails desk) {
        String relativeLink = null;
        if (desk != null) {
            String baseUrl = ComponentAccessor.getApplicationProperties().getString("jira.baseurl");
            if (StringUtils.isBlank((String)baseUrl)) {
                baseUrl = "";
            } else if (baseUrl.endsWith("/")) {
                baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
            }
            relativeLink = String.format(CUSTOMERPORTAL_LINK, baseUrl, desk.getId());
        }
        return relativeLink;
    }

    @Override
    public String getLinkToIssueInCustomerPortal(ServiceDeskDetails desk, Issue issue) {
        String relativeLink = this.getLinkToCustomerPortal(desk);
        return StringUtils.isNotBlank((String)relativeLink) ? relativeLink + "/" + issue.getKey() : null;
    }

    @Override
    public boolean isUserParticipantAndParticipantsEnabled(ApplicationUser senderUser, Issue issue, ServiceDeskDetails serviceDesk) {
        CustomField participantsField;
        boolean part;
        this.logger.debug((Object)(".isUserParticipantAndParticipantsEnabled() called " + senderUser));
        boolean bl = part = serviceDesk != null;
        if (part && (participantsField = CustomFieldUtil.getServiceDeskRequestParticipantsField(ComponentAccessor.getCustomFieldManager().getCustomFieldObjects(issue))) != null) {
            Collection participants = (Collection)issue.getCustomFieldValue(participantsField);
            part = participants.contains(senderUser);
        }
        this.logger.debug((Object)part);
        return part;
    }

    @Override
    public boolean isUserCustomerAndReporter(ApplicationUser senderUser, Issue issue, ServiceDeskDetails serviceDesk) {
        this.logger.debug((Object)(".isUserCustomerAndReporter() called, " + senderUser));
        if (issue == null || issue.getReporter() == null || issue.getProjectObject() == null || senderUser == null || serviceDesk == null) {
            return false;
        }
        ApplicationUser reporter = issue.getReporter();
        boolean customer = reporter.equals((Object)senderUser);
        customer = customer && this.userHasPortalAccess(senderUser, issue.getProjectObject(), serviceDesk);
        this.logger.debug((Object)customer);
        return customer;
    }

    @Override
    public boolean isRequestSharedWithUserInCustomerPortal(ApplicationUser user, Issue issue, ServiceDeskDetails serviceDeskDetails) {
        this.logger.debug((Object)(".isRequestSharedWithUserInCustomerPortal() called, " + user));
        return this.isUserCustomerAndReporter(user, issue, serviceDeskDetails) || this.isUserParticipantAndParticipantsEnabled(user, issue, serviceDeskDetails);
    }

    @Override
    public Collection<HiddenPortalField> getHiddenFieldsFromPortal(CustomerRequestType customerRequestType) {
        LinkedList<HiddenPortalField> hiddenFields = new LinkedList<HiddenPortalField>();
        return hiddenFields;
    }

    static {
        dbProviders = new HashMap<String, DeskDBProvider>();
    }
}

