/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.desk;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.metainf.jira.plugin.emailissue.action.EmailDefinition;
import com.metainf.jira.plugin.emailissue.action.RecipientFilter;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskDetails;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskManager;
import com.metainf.jira.plugin.emailissue.operation.PermissionChecker;

public class ServiceDeskCustomerAndEmailAddressRecipientFilter
implements RecipientFilter {
    private final ServiceDeskManager serviceDeskManager;
    private final PermissionChecker permissionChecker;
    private final Issue issue;
    private final ApplicationUser currentUserOrCustomer;
    private final ServiceDeskDetails serviceDeskDetails;

    public ServiceDeskCustomerAndEmailAddressRecipientFilter(ServiceDeskManager serviceDeskManager, PermissionChecker permissionChecker, EmailDefinition def) {
        this.serviceDeskManager = serviceDeskManager;
        this.permissionChecker = permissionChecker;
        this.issue = def.getIssueObject();
        this.currentUserOrCustomer = def.getRemoteUser();
        this.serviceDeskDetails = this.serviceDeskManager.getServiceDeskDetails(this.issue.getProjectId());
    }

    @Override
    public boolean acceptsEmailAddress(String emailAddress) {
        return true;
    }

    @Override
    public boolean acceptsUser(ApplicationUser user) {
        boolean accept = this.serviceDeskManager.isRequestSharedWithUserInCustomerPortal(user, this.issue, this.serviceDeskDetails) || this.permissionChecker.isAllowedToViewIssue(user, this.issue);
        return accept;
    }
}

