/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.customfield;

import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.exception.AttachmentNotFoundException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.util.ErrorCollection;
import com.metainf.jira.plugin.emailissue.action.AttachmentInfo;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentSelectorFieldType
extends AbstractCustomFieldType<Collection<Attachment>, Attachment> {
    private static final Logger log = LoggerFactory.getLogger(AttachmentSelectorFieldType.class);
    private final CustomFieldValuePersister customFieldValuePersister;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final AttachmentManager attachmentManager;

    public AttachmentSelectorFieldType(CustomFieldValuePersister customFieldValuePersister, DateTimeFormatterFactory dateTimeFormatterFactory, AttachmentManager attachmentManager) {
        this.customFieldValuePersister = customFieldValuePersister;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.attachmentManager = attachmentManager;
    }

    public String getStringFromSingularObject(Attachment attachment) {
        return attachment == null ? null : attachment.getFilename();
    }

    public Attachment getSingularObjectFromString(String s) throws FieldValidationException {
        return StringUtils.isBlank((String)s) ? null : this.getAttachment(Long.parseLong(s));
    }

    public Set<Long> remove(CustomField field) {
        return this.customFieldValuePersister.removeAllValues(field.getId());
    }

    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
    }

    public void createValue(CustomField field, Issue issue, @Nonnull Collection<Attachment> value) {
        if (value != null && !value.isEmpty()) {
            HashSet<Long> attachmentIds = new HashSet<Long>();
            for (Attachment a : value) {
                attachmentIds.add(a.getId());
            }
            this.customFieldValuePersister.createValues(field, issue.getId(), PersistenceFieldType.TYPE_DECIMAL, attachmentIds);
        }
    }

    public void updateValue(CustomField field, Issue issue, Collection<Attachment> value) {
        this.customFieldValuePersister.removeAllValues(field.getId());
        this.createValue(field, issue, value);
    }

    public Collection<Attachment> getValueFromCustomFieldParams(CustomFieldParams customFieldParams) throws FieldValidationException {
        if (CustomFieldUtils.isCollectionNotEmpty((Collection)customFieldParams.getAllValues())) {
            ArrayList<Attachment> attachments = new ArrayList<Attachment>();
            Collection attachmentIds = customFieldParams.getValuesForKey("selectedAttachments");
            if (attachmentIds != null) {
                for (Object sid : attachmentIds) {
                    Attachment attachment = this.getAttachment(Long.parseLong(sid.toString()));
                    if (attachment == null) continue;
                    attachments.add(attachment);
                }
            }
            return attachments;
        }
        return null;
    }

    public Object getStringValueFromCustomFieldParams(CustomFieldParams parameters) {
        Object attachments = this.getValueFromCustomFieldParams(parameters);
        if (attachments != null) {
            StringBuilder s = new StringBuilder();
            Iterator iterator = attachments.iterator();
            while (iterator.hasNext()) {
                Attachment a = (Attachment)iterator.next();
                if (s.length() > 0) {
                    s.append(", ");
                }
                s.append(a.getFilename());
            }
            return s.toString();
        }
        return null;
    }

    @Nullable
    public Collection<Attachment> getValueFromIssue(CustomField customField, Issue issue) {
        List values = this.customFieldValuePersister.getValues(customField, issue.getId(), PersistenceFieldType.TYPE_DECIMAL);
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        if (values != null) {
            NumberFormat nf = NumberFormat.getNumberInstance();
            for (Object sid : values) {
                try {
                    Attachment attachment;
                    Number id = nf.parse(sid.toString());
                    if (id == null || (attachment = this.getAttachment(id.longValue())) == null) continue;
                    attachments.add(attachment);
                }
                catch (ParseException parseException) {}
            }
        }
        return attachments;
    }

    public Collection<Attachment> getDefaultValue(FieldConfig fieldConfig) {
        return Collections.EMPTY_LIST;
    }

    public void setDefaultValue(FieldConfig fieldConfig, Collection<Attachment> value) {
    }

    @Nullable
    public String getChangelogValue(CustomField field, Collection<Attachment> value) {
        return "";
    }

    @Nonnull
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        if (issue == null || issue.getId() == null) {
            return new HashMap<String, Object>();
        }
        Map result = super.getVelocityParameters(issue, field, fieldLayoutItem);
        result.put("attachments", AttachmentInfo.fromAttachments(issue.getAttachments(), this.dateTimeFormatterFactory.formatter().forLoggedInUser()));
        Object selectedAttachments = this.getValueFromIssue(field, issue);
        result.put("selectedAttachments", AttachmentInfo.fromAttachments((Collection<Attachment>)selectedAttachments, this.dateTimeFormatterFactory.formatter().forLoggedInUser()));
        return result;
    }

    private Attachment getAttachment(Long id) {
        try {
            return this.attachmentManager.getAttachment(id);
        }
        catch (AttachmentNotFoundException e) {
            return null;
        }
    }
}

