/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.converters.wiki;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.metainf.jira.plugin.emailissue.converters.wiki.Attachment;
import com.metainf.jira.plugin.emailissue.converters.wiki.BlockStyleHandler;
import com.metainf.jira.plugin.emailissue.converters.wiki.ColorHandler;
import java.net.URL;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
final class LinkAndImageHandler {
    private static final Logger log = LoggerFactory.getLogger(LinkAndImageHandler.class);
    public static final String HTML_LINK = "a";
    public static final String HTML_IMG = "img";
    public static final String HTML_HREF = "href";
    private static final String CONTENT_ID_PREFIX = "cid:";
    private static final String WIKI_LINK_OPEN_BRACKET = "[";
    private static final String WIKI_LINK_CLOSE_BRACKET = "]";
    private static final String WIKI_LINK_SEPARATOR = "|";
    private static final String WIKI_MACRO_ATTACHMENT_FORMAT = "!%s!";
    private static final String WIKI_MACRO_THUMBNAIL_FORMAT = "!%s|thumbnail!";
    private static final String NON_WIKI_TEXT_FORMAT = " <%s>";
    static final List<String> NON_WIKI_LINK_URIS = ImmutableList.of((Object)"tel:", (Object)"sms:", (Object)"callto:", (Object)"fax:", (Object)"modem:", (Object)"wtai:", (Object)"rhomailto:");
    private final BlockStyleHandler blockStyleHandler;
    private final ColorHandler colorHandler;
    private final List<Attachment> attachments;
    private boolean linkNonWikiHref;
    private boolean inLink;
    private boolean linkHasText;
    private boolean imageInsideLink;
    private boolean urlInLinkText;
    private boolean toReset;

    private static String WIKI_MACRO_ATTACHMENT(String value) {
        return String.format(WIKI_MACRO_ATTACHMENT_FORMAT, value);
    }

    private static String WIKI_MACRO_THUMBNAIL(String value) {
        return String.format(WIKI_MACRO_THUMBNAIL_FORMAT, value);
    }

    private static String NON_WIKI_TEXT(String value) {
        return String.format(NON_WIKI_TEXT_FORMAT, value);
    }

    public LinkAndImageHandler(BlockStyleHandler blockStyleHandler, ColorHandler colorHandler, List<Attachment> attachments) {
        this.blockStyleHandler = blockStyleHandler;
        this.colorHandler = colorHandler;
        this.attachments = ImmutableList.copyOf(attachments);
    }

    public String enter(Node node, String name) {
        if (!this.blockStyleHandler.isFormattingPossible()) {
            return "";
        }
        if (HTML_LINK.equals(name)) {
            this.inLink = false;
            this.linkHasText = false;
            this.imageInsideLink = false;
            this.urlInLinkText = false;
            this.toReset = false;
            final String href = node.attr(HTML_HREF);
            this.linkNonWikiHref = Iterables.any(NON_WIKI_LINK_URIS, (Predicate)new Predicate<String>(){

                public boolean apply(@Nullable String input) {
                    return StringUtils.startsWithIgnoreCase((String)href, (String)input);
                }
            });
            if (!this.linkNonWikiHref && node instanceof Element) {
                Element element = (Element)node;
                if (element.select(HTML_IMG).isEmpty()) {
                    this.inLink = true;
                    this.linkHasText = element.hasText();
                    if (this.linkHasText) {
                        this.urlInLinkText = LinkAndImageHandler.containsUrlInLinkText(element);
                    }
                    return WIKI_LINK_OPEN_BRACKET;
                }
                this.imageInsideLink = true;
            }
        } else if (HTML_IMG.equals(name)) {
            return this.replaceWikiMacroForImage(node);
        }
        return "";
    }

    public String exit(StringBuilder accum, Node node, String name) {
        if (!this.blockStyleHandler.isFormattingPossible()) {
            return "";
        }
        String val = "";
        if (HTML_LINK.equals(name)) {
            String href = node.attr(HTML_HREF);
            if (this.linkNonWikiHref) {
                val = val + LinkAndImageHandler.NON_WIKI_TEXT(href);
            } else if (this.imageInsideLink) {
                val = LinkAndImageHandler.NON_WIKI_TEXT(WIKI_LINK_OPEN_BRACKET + href + WIKI_LINK_CLOSE_BRACKET);
            } else {
                if (this.linkHasText) {
                    val = val + WIKI_LINK_SEPARATOR;
                }
                val = val + href;
                val = val + WIKI_LINK_CLOSE_BRACKET;
                val = this.colorHandler.handleAroundNonSupportedFormatting(accum, val, "", false, false, false, false);
            }
            this.toReset = true;
        }
        return val;
    }

    public boolean isInsideLinkWithText() {
        return this.isInsideAnyLink() && this.linkHasText;
    }

    public boolean isInsideAnyLink() {
        return this.inLink;
    }

    public boolean isUrlInLinkText() {
        return this.isInsideLinkWithText() && this.urlInLinkText;
    }

    public void reset() {
        if (this.toReset) {
            this.inLink = false;
            this.linkHasText = false;
            this.imageInsideLink = false;
            this.linkNonWikiHref = false;
            this.urlInLinkText = false;
        }
        this.toReset = false;
    }

    private String replaceWikiMacroForImage(Node node) {
        String imageSource = node.attr("src");
        if (StringUtils.startsWithIgnoreCase((String)imageSource, (String)CONTENT_ID_PREFIX)) {
            String contentId = StringUtils.removeStart((String)imageSource, (String)CONTENT_ID_PREFIX);
            Attachment image = this.getAttachmentById(contentId);
            if (image != null) {
                return LinkAndImageHandler.WIKI_MACRO_THUMBNAIL(image.getFilename());
            }
            String alternativeText = node.attr("alt");
            String titleText = node.attr("title");
            log.warn("Could not find attachment: '" + alternativeText + "' (" + titleText + ") for content id: " + contentId);
            String text = StringUtils.isNotBlank((String)alternativeText) ? alternativeText : (StringUtils.isNotBlank((String)titleText) ? titleText : contentId);
            return text;
        }
        return LinkAndImageHandler.WIKI_MACRO_ATTACHMENT(imageSource);
    }

    private Attachment getAttachmentById(String contentId) {
        for (Attachment attachment : this.attachments) {
            if (!StringUtils.equalsIgnoreCase((String)attachment.getContentId(), (String)contentId)) continue;
            return attachment;
        }
        return null;
    }

    private static boolean containsUrlInLinkText(Element element) {
        for (String text : StringUtils.split((String)element.text())) {
            try {
                new URL(StringUtils.trimToEmpty((String)text));
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }
}

