/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.config;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.metainf.jira.plugin.emailissue.action.EmailSupportOptionsInitializer;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.Configuration;
import com.metainf.jira.plugin.emailissue.entity.ConfigurationDao;
import com.metainf.jira.plugin.emailissue.searcher.IssueSearcher;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DefaultConfigurationManager
implements ConfigurationManager {
    private static final Object lock = new Object();
    private final ConfigurationDao configurationDao;
    private final ProjectRoleManager projectRoleManager;
    private final IssueSearcher issueSearcher;

    public DefaultConfigurationManager(ConfigurationDao configurationDao, ProjectRoleManager projectRoleManager, IssueSearcher issueSearcher) {
        this.configurationDao = configurationDao;
        this.projectRoleManager = projectRoleManager;
        this.issueSearcher = issueSearcher;
    }

    @Override
    public void updateGlobalConfiguration(Configuration configuration) {
        this.configurationDao.update(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Configuration getGlobalConfiguration() {
        Configuration configuration = this.configurationDao.getGlobalConfigation();
        if (configuration == null) {
            Object object = lock;
            synchronized (object) {
                configuration = this.configurationDao.getGlobalConfigation();
                if (configuration == null) {
                    configuration = (Configuration)this.configurationDao.create();
                    configuration.setFixOutlookBlankLine(Boolean.FALSE);
                    configuration.setMultipartMixed(Boolean.FALSE);
                    configuration.setDisableAttachments(Boolean.FALSE);
                    EmailSupportOptionsInitializer.initalizeEmailOptions(configuration);
                    for (ProjectRole role : this.projectRoleManager.getProjectRoles()) {
                        if (!"IssueMailSender".equals(role.getName())) continue;
                        configuration.setPermissionRoles(role.getId().toString());
                        break;
                    }
                    this.configurationDao.update(configuration);
                }
            }
        }
        return configuration;
    }

    @Override
    public Configuration getConfiguration(long configurationId) {
        return configurationId > 0L ? (Configuration)this.configurationDao.getById(configurationId) : null;
    }

    @Override
    public void deleteConfiguration(Configuration configuration) {
        Configuration globalConfig = this.getGlobalConfiguration();
        if (configuration != null && globalConfig != null && configuration.getID() != globalConfig.getID()) {
            this.configurationDao.delete(configuration);
        }
    }

    @Override
    public void updateConfiguration(Configuration configuration) {
        if (configuration != null) {
            this.configurationDao.update(configuration);
        }
    }

    @Override
    public List<Configuration> getAllNonGlobalConfigurations() {
        Configuration globalConfig = this.getGlobalConfiguration();
        LinkedList<Configuration> configs = new LinkedList<Configuration>();
        for (Configuration c : (Configuration[])this.configurationDao.findAll()) {
            if (c.getID() == globalConfig.getID()) continue;
            configs.add(c);
        }
        Collections.sort(configs, new Configuration.EntityComparator());
        return configs;
    }

    @Override
    public Configuration newConfiguration() {
        return (Configuration)this.configurationDao.newEntity();
    }

    @Override
    public Configuration resolveConfiguration(Issue issue) {
        Configuration resolved = null;
        for (Configuration config : this.getAllNonGlobalConfigurations()) {
            if (config.getProjectId() != null && config.getProjectId().equals(issue.getProjectId()) && StringUtils.isNotBlank((CharSequence)config.getIssueTypes()) && config.getIssueTypes().equals(issue.getIssueTypeId()) && (StringUtils.isBlank((CharSequence)config.getJQLFilter()) || this.issueSearcher.issueMatchesJQLWithoutReindexing(config.getJQLFilter(), issue))) {
                resolved = config;
                break;
            }
            if (config.getProjectId() == null && StringUtils.isNotBlank((CharSequence)config.getIssueTypes()) && config.getIssueTypes().equals(issue.getIssueTypeId()) && (StringUtils.isBlank((CharSequence)config.getJQLFilter()) || this.issueSearcher.issueMatchesJQLWithoutReindexing(config.getJQLFilter(), issue))) {
                resolved = config;
                break;
            }
            if (config.getProjectId() != null && config.getProjectId().equals(issue.getProjectId()) && StringUtils.isBlank((CharSequence)config.getIssueTypes()) && (StringUtils.isBlank((CharSequence)config.getJQLFilter()) || this.issueSearcher.issueMatchesJQLWithoutReindexing(config.getJQLFilter(), issue))) {
                resolved = config;
                break;
            }
            if (config.getProjectId() != null || !StringUtils.isBlank((CharSequence)config.getIssueTypes()) || !StringUtils.isBlank((CharSequence)config.getJQLFilter()) && !this.issueSearcher.issueMatchesJQLWithoutReindexing(config.getJQLFilter(), issue)) continue;
            resolved = config;
            break;
        }
        return resolved == null ? this.getGlobalConfiguration() : resolved;
    }
}

