/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.audit;

import com.atlassian.jira.user.ApplicationUser;
import java.text.MessageFormat;

public class RecipientDisplay {
    private int size;
    private StringBuilder shortLabel = new StringBuilder();
    private StringBuilder fullLabel = new StringBuilder();
    private static final String AVATAR_URL_PATTERN = "<a class=\"user-hover user-avatar\" rel=\"{0}\" style=\"padding: 2px 0 2px 29px; background-image:url({1});\" href=\"{3}/secure/ViewProfile.jspa?name={0}\">{2}</a>";

    public void addEmailAddress(String emaiAddress) {
        this.addElement(emaiAddress);
    }

    public void addUser(ApplicationUser user, String avatarUrl, String baseUrl) {
        String avatarLink = MessageFormat.format(AVATAR_URL_PATTERN, user.getName(), avatarUrl, user.getDisplayName(), baseUrl);
        this.addElement(avatarLink);
    }

    protected void addElement(String token) {
        if (this.size < 5) {
            if (this.shortLabel.length() > 0) {
                this.shortLabel.append(", ");
            }
            this.shortLabel.append(token);
        }
        if (this.fullLabel.length() > 0) {
            this.fullLabel.append(", ");
        }
        this.fullLabel.append(token);
        ++this.size;
    }

    public int getSize() {
        return this.size;
    }

    public String getShortLabel() {
        return this.size < 6 ? null : this.shortLabel.toString();
    }

    public String getFullLabel() {
        return this.fullLabel.toString();
    }
}

