/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.audit;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.sal.api.ApplicationProperties;
import com.metainf.jira.plugin.emailissue.action.AttachmentComparator;
import com.metainf.jira.plugin.emailissue.action.UserResolver;
import com.metainf.jira.plugin.emailissue.audit.RecipientDisplay;
import com.metainf.jira.plugin.emailissue.entity.AuditLogEntry;
import com.metainf.jira.plugin.emailissue.entity.Template;
import com.metainf.jira.plugin.emailissue.entity.TemplateDao;
import com.metainf.jira.plugin.emailissue.util.StringUtil;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AuditLogBean {
    private final AuditLogEntry auditLogEntry;
    private final DateTimeFormatter dateTimeFormatter;
    private final I18nHelper i18nHelper;
    private final AvatarService avatarService;
    private final ApplicationProperties applicationProperties;
    private String userAvatarUrl;
    private String actionLabel;
    private final UserResolver userResolver;
    private final RecipientDisplay to;
    private final RecipientDisplay cc;
    private final RecipientDisplay bcc;
    private final RecipientDisplay from;
    private final String emailSubject;
    private final String emailBody;
    private final String attachments;
    private String attachmentLinks;
    private String issueKey;
    private String issueSummary;
    private Boolean addComments;
    private Boolean addToWatcher;
    private Boolean replyToMe;
    private Boolean mailAsMe;
    private String source;
    private Template template;
    private static final String ATTACHMENT_LINK = "<a href=\"{0}/secure/attachment/{1}/{1}_{2}\">{2}</a>";

    public AuditLogBean(Issue issue, AuditLogEntry auditLogEntry, DateTimeFormatter dateTimeFormatter, I18nHelper i18nHelper, AvatarService avatarService, UserResolver userResolver, ApplicationProperties applicationProperties, TemplateDao templateDao) {
        this(auditLogEntry, dateTimeFormatter, i18nHelper, avatarService, userResolver, applicationProperties, templateDao);
        if (issue != null) {
            this.issueKey = issue.getKey();
            this.issueSummary = issue.getSummary();
            if (StringUtils.isNotBlank((String)this.attachments)) {
                ArrayList<Attachment> attachments = new ArrayList<Attachment>(issue.getAttachments());
                Collections.sort(attachments, new AttachmentComparator());
                StringBuilder attachmentLinks = new StringBuilder();
                for (String attachmentName : this.attachments.split(",")) {
                    Attachment a = this.findAttachment(attachments, attachmentName.trim());
                    if (a != null) {
                        String link = MessageFormat.format(ATTACHMENT_LINK, this.applicationProperties.getBaseUrl(), a.getId().toString(), a.getFilename());
                        if (attachmentLinks.length() > 0) {
                            attachmentLinks.append(", ");
                        }
                        attachmentLinks.append(link);
                        continue;
                    }
                    if (attachmentLinks.length() > 0) {
                        attachmentLinks.append(", ");
                    }
                    attachmentLinks.append(attachmentName);
                }
                this.attachmentLinks = attachmentLinks.toString();
            }
        }
    }

    private Attachment findAttachment(List<Attachment> attachments, String attachmentName) {
        for (Attachment attachment : attachments) {
            if (!attachment.getFilename().equalsIgnoreCase(attachmentName)) continue;
            return attachment;
        }
        return null;
    }

    public AuditLogBean(AuditLogEntry auditLogEntry, DateTimeFormatter dateTimeFormatter, I18nHelper i18nHelper, AvatarService avatarService, UserResolver userResolver, ApplicationProperties applicationProperties, TemplateDao templateDao) {
        this.applicationProperties = applicationProperties;
        this.auditLogEntry = auditLogEntry;
        this.dateTimeFormatter = dateTimeFormatter;
        this.avatarService = avatarService;
        this.i18nHelper = i18nHelper;
        this.userResolver = userResolver;
        this.actionLabel = this.auditLogEntry.getType() == null ? "unknown" : this.i18nHelper.getText(this.auditLogEntry.getType().getLabelKey());
        URI avatar = avatarService.getAvatarUrlNoPermCheck(ApplicationUsers.byKey((String)this.auditLogEntry.getSenderKey()), Avatar.Size.SMALL);
        this.userAvatarUrl = avatar == null ? null : avatar.toString();
        this.to = this.buildUserAndEmailDisplay(this.auditLogEntry.getRecipients());
        this.cc = this.buildUserAndEmailDisplay(this.auditLogEntry.getCc());
        this.bcc = this.buildUserAndEmailDisplay(this.auditLogEntry.getBcc());
        this.from = this.buildUserAndEmailDisplay(this.auditLogEntry.getFrom());
        this.emailBody = StringUtil.removeScripts(this.auditLogEntry.getEmailBody());
        this.emailSubject = this.auditLogEntry.getEmailSubject();
        this.attachments = this.auditLogEntry.getAttachments();
        this.issueKey = auditLogEntry.getIssueKey();
        this.issueSummary = auditLogEntry.getIssueSummary();
        if (auditLogEntry.isAddComments()) {
            this.addComments = Boolean.TRUE;
        }
        if (auditLogEntry.isReplyToMe()) {
            this.replyToMe = Boolean.TRUE;
        }
        if (auditLogEntry.isAddToWatchers()) {
            this.addToWatcher = Boolean.TRUE;
        }
        if (auditLogEntry.isMailAsMe()) {
            this.mailAsMe = Boolean.TRUE;
        }
        this.source = auditLogEntry.getSource();
        if (auditLogEntry.getTemplateId() != null) {
            this.template = (Template)templateDao.getById(new Long(auditLogEntry.getTemplateId().intValue()));
        }
    }

    public Boolean getAddComments() {
        return this.addComments;
    }

    public Boolean getAddToWatcher() {
        return this.addToWatcher;
    }

    public Boolean getReplyToMe() {
        return this.replyToMe;
    }

    public Boolean getOptions() {
        Boolean options = null;
        if (this.addComments != null || this.replyToMe != null || this.addToWatcher != null) {
            options = Boolean.TRUE;
        }
        return options;
    }

    public RecipientDisplay getTo() {
        return this.to;
    }

    public RecipientDisplay getCc() {
        return this.cc;
    }

    public RecipientDisplay getBcc() {
        return this.bcc;
    }

    public String getFrom() {
        return this.from == null ? null : this.from.getFullLabel();
    }

    public String getFromName() {
        return this.auditLogEntry.getFromName();
    }

    public String getEmailSubject() {
        return this.emailSubject;
    }

    public String getEmailBody() {
        return this.emailBody;
    }

    public String getAttachments() {
        return this.attachments;
    }

    public AuditLogEntry getAuditLogEntry() {
        return this.auditLogEntry;
    }

    public String getUserAvatarUrl() {
        return this.userAvatarUrl;
    }

    public String getActionLabel() {
        return this.actionLabel;
    }

    public I18nHelper getI18n() {
        return this.i18nHelper;
    }

    public String getTimestamp() {
        return this.dateTimeFormatter.format(this.auditLogEntry.getSendTimeStamp());
    }

    public int getID() {
        return this.auditLogEntry.getID();
    }

    public String getSenderUserName() {
        if (StringUtils.isBlank((String)this.auditLogEntry.getSenderKey())) {
            return null;
        }
        ApplicationUser appUser = ApplicationUsers.byKey((String)this.auditLogEntry.getSenderKey());
        return appUser == null ? null : appUser.getUsername();
    }

    public String getSenderKey() {
        return this.auditLogEntry.getSenderKey();
    }

    public String getSenderName() {
        return this.auditLogEntry.getSenderName();
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public String getIssueSummary() {
        return this.issueSummary;
    }

    public Long getIssueId() {
        return this.auditLogEntry.getIssueId();
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    private RecipientDisplay buildUserAndEmailDisplay(String emailAddresses) {
        String baseUrl = this.applicationProperties.getBaseUrl();
        if (StringUtils.isBlank((String)emailAddresses)) {
            return null;
        }
        RecipientDisplay result = new RecipientDisplay();
        StringBuilder formatted = new StringBuilder();
        String[] emailTokens = emailAddresses.split(",");
        for (int i = 0; i < emailTokens.length; ++i) {
            ApplicationUser user;
            String email = emailTokens[i];
            if (formatted.length() > 0) {
                formatted.append(", ");
            }
            if ((user = this.userResolver.getFirstUserForEmailAddress(email)) != null) {
                URI avatar = this.avatarService.getAvatarUrlNoPermCheck(user, Avatar.Size.SMALL);
                String avatarUrl = avatar == null ? null : avatar.toString();
                result.addUser(user, avatarUrl, baseUrl);
                continue;
            }
            result.addEmailAddress(email);
        }
        return result;
    }

    public Boolean getMailAsMe() {
        return this.mailAsMe;
    }

    public void setMailAsMe(Boolean mailAsMe) {
        this.mailAsMe = mailAsMe;
    }

    public Template getTemplate() {
        return this.template;
    }

    public String getAttachmentLinks() {
        return this.attachmentLinks;
    }
}

