/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.api;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.util.I18nHelper;
import com.metainf.jira.plugin.emailissue.action.EmailBuilder;
import com.metainf.jira.plugin.emailissue.action.EmailDefinition;
import com.metainf.jira.plugin.emailissue.action.EmailDefinitionBuilder;
import com.metainf.jira.plugin.emailissue.action.Recipient;
import com.metainf.jira.plugin.emailissue.api.EmailDefinitionApi;
import com.metainf.jira.plugin.emailissue.api.EmailService;
import java.util.List;
import javax.mail.Message;
import org.apache.commons.lang.StringUtils;

public class EmailServiceImpl
implements EmailService {
    private final IssueManager issueManager;
    private final JiraAuthenticationContext authenticationContext;
    private final CustomFieldManager customFieldManager;
    private final GroupManager groupManager;
    private final ProjectRoleManager projectRoleManager;
    private final I18nHelper i18n;
    private final EmailBuilder emailBuilder;

    public EmailServiceImpl(IssueManager issueManager, JiraAuthenticationContext authenticationContext, CustomFieldManager customFieldManager, GroupManager groupManager, ProjectRoleManager projectRoleManager, EmailBuilder emailBuilder) {
        this.issueManager = issueManager;
        this.authenticationContext = authenticationContext;
        this.customFieldManager = customFieldManager;
        this.groupManager = groupManager;
        this.projectRoleManager = projectRoleManager;
        this.i18n = authenticationContext.getI18nHelper();
        this.emailBuilder = emailBuilder;
    }

    @Override
    public void sendEmail(EmailDefinitionApi emailDefinition) throws Exception {
        MutableIssue issue;
        if (emailDefinition != null && StringUtils.isNotBlank((String)emailDefinition.getIssue()) && (issue = this.issueManager.getIssueByCurrentKey(emailDefinition.getIssue())) != null) {
            EmailDefinitionBuilder builder = new EmailDefinitionBuilder((Issue)issue).as(this.authenticationContext.getLoggedInUser()).body(emailDefinition.getEmailBody()).subject(emailDefinition.getEmailSubject()).withOptions(emailDefinition.getEmailOptions());
            this.resolveRecipients(emailDefinition.getBcc(), builder, Message.RecipientType.BCC);
            this.resolveRecipients(emailDefinition.getCc(), builder, Message.RecipientType.CC);
            this.resolveRecipients(emailDefinition.getTo(), builder, Message.RecipientType.TO);
            EmailDefinition emailDef = builder.build();
            this.emailBuilder.sendEmail(emailDef, this.authenticationContext.getLoggedInUser());
        }
    }

    private void resolveRecipients(List<String> recipients, EmailDefinitionBuilder builder, Message.RecipientType recipientType) {
        StringBuilder usersOrEmailAddresses = new StringBuilder();
        if (recipients != null && recipients.size() > 0) {
            for (String recipientKey : recipients) {
                Recipient r = Recipient.buildRecipient(recipientKey, this.customFieldManager, this.groupManager, this.projectRoleManager, this.i18n);
                if (r != null) {
                    builder.withRecipient(r, recipientType);
                    continue;
                }
                if (usersOrEmailAddresses.length() > 0) {
                    usersOrEmailAddresses.append(",");
                }
                usersOrEmailAddresses.append(recipientKey);
            }
            if (usersOrEmailAddresses.length() > 0) {
                if (recipientType == Message.RecipientType.TO) {
                    builder.to(usersOrEmailAddresses.toString());
                } else if (recipientType == Message.RecipientType.CC) {
                    builder.cc(usersOrEmailAddresses.toString());
                } else {
                    builder.bcc(usersOrEmailAddresses.toString());
                }
            }
        }
    }
}

