/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action.config;

import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.metainf.jira.plugin.emailissue.action.config.TabSupport;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.AutoReplyParams;
import com.metainf.jira.plugin.emailissue.entity.AutoReplyParamsDao;
import com.metainf.jira.plugin.emailissue.entity.Context;
import com.metainf.jira.plugin.emailissue.entity.ContextDao;
import com.metainf.jira.plugin.emailissue.entity.NotificationEvent;
import com.metainf.jira.plugin.emailissue.entity.NotificationEventDao;
import com.metainf.jira.plugin.emailissue.entity.NotificationTemplateDao;
import com.metainf.jira.plugin.emailissue.entity.Template;
import com.metainf.jira.plugin.emailissue.entity.TemplateDao;
import com.metainf.jira.plugin.emailissue.template.EmailTemplateTheme;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Templates
extends TabSupport {
    private long templateId;
    private TemplateDao templateDao;
    private ContextDao contextDao;
    private NotificationTemplateDao notificationTemplateDao;
    private NotificationEventDao notificationEventDao;
    private String filter;
    private EventTypeManager eventTypeManager;
    private List<EventType> systemEventTypes;
    private AutoReplyParamsDao autoReplyParamsDao;

    public Templates(Authorizer authorizer, DateTimeFormatterFactory dateTimeFormatterFactory, TemplateDao templateDao, ContextDao contextDao, EventTypeManager eventTypeManager, NotificationTemplateDao notificationTemplateDao, NotificationEventDao notificationEventDao, ConfigurationManager configurationManager, AutoReplyParamsDao autoReplyParamsDao) {
        super(authorizer, dateTimeFormatterFactory, configurationManager);
        this.templateDao = templateDao;
        this.contextDao = contextDao;
        this.notificationEventDao = notificationEventDao;
        this.notificationTemplateDao = notificationTemplateDao;
        this.eventTypeManager = eventTypeManager;
        this.systemEventTypes = new ArrayList<EventType>(eventTypeManager.getEventTypes());
        this.autoReplyParamsDao = autoReplyParamsDao;
        Iterator<EventType> it = this.systemEventTypes.iterator();
        while (it.hasNext()) {
            if (it.next().isSystemEventType()) continue;
            it.remove();
        }
    }

    public String getContentPage() {
        return this.isBeforeJira6() ? "/templates/emailissue/operation/config/templates.vm" : "/templates/emailissue/operation/config/templates6.vm";
    }

    @Override
    public String getActiveTabClass(String tabName) {
        return "templatesTab".equals(tabName) ? "active-tab" : "";
    }

    public List<Template> getTemplates() {
        ArrayList<Template> templates = new ArrayList<Template>(Arrays.asList(this.templateDao.filter(this.filter)));
        Collections.sort(templates, new Template.EntityComparator());
        return templates;
    }

    public String doDelete() {
        if (this.templateId != 0L) {
            Context[] hits = (Context[])this.contextDao.filter("TEMPLATE_ID = ? OR PREFILL_TEMPLATE_ID = ?", new Object[]{this.templateId, this.templateId});
            if (hits != null && hits.length > 0) {
                this.addErrorMessage("There are Contexts using this template, therefore the template cannot be deleted.");
            } else {
                NotificationEvent[] events = (NotificationEvent[])this.notificationEventDao.filter("TEMPLATE_ID = ?", new Object[]{this.templateId});
                if (events != null && events.length > 0) {
                    this.addErrorMessage("There are Notifications using this template, therefore the template cannot be deleted.");
                } else {
                    AutoReplyParams[] autoReplyParams = (AutoReplyParams[])this.autoReplyParamsDao.filter("TEMPLATE_ID = ? OR COMMENT_TEMPLATE_ID = ?", new Object[]{this.templateId, this.templateId});
                    if (autoReplyParams != null && autoReplyParams.length > 0) {
                        this.addErrorMessage("There are Mail Handler Configurations using this template, therefore the template cannot be deleted.");
                    } else {
                        Template template = (Template)this.templateDao.getById(this.templateId);
                        if (template != null) {
                            this.templateDao.delete(template);
                        }
                    }
                }
            }
        }
        return this.success();
    }

    public String doCopy() {
        Template template;
        if (this.templateId != 0L && (template = (Template)this.templateDao.getById(this.templateId)) != null) {
            this.templateDao.copy(template);
        }
        return this.getRedirect("/secure/admin/jeti/jetiTemplates.jspa");
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(long templateId) {
        this.templateId = templateId;
    }

    public List<EventType> getSystemEventTypes() {
        return this.systemEventTypes;
    }

    public List<EmailTemplateTheme> getThemes() {
        return Arrays.asList(EmailTemplateTheme.values());
    }
}

