/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action.config;

import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.component.jql.AutoCompleteJsonGenerator;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.Configuration;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import com.metainf.jira.plugin.versionkit.AppVersionManager;
import com.metainf.jira.plugin.versionkit.AppVersionManagerImpl;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class TabSupport
extends JiraWebActionSupport {
    protected static final String SUCCESS6 = "success6";
    protected Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    protected Authorizer authorizer;
    protected DateTimeFormatter dateTimeFormatter;
    protected String jetiAuthPolicy;
    protected ConfigurationManager configurationManager;
    protected AppVersionManager appVersionManager;
    private AutoCompleteJsonGenerator autoCompleteJsonGenerator;

    public TabSupport(Authorizer authorizer, DateTimeFormatterFactory dateTimeFormatterFactory, ConfigurationManager configurationManager) {
        this.authorizer = authorizer;
        this.dateTimeFormatter = dateTimeFormatterFactory.formatter().forLoggedInUser();
        this.configurationManager = configurationManager;
        this.appVersionManager = new AppVersionManagerImpl();
    }

    public TabSupport(Authorizer authorizer, DateTimeFormatterFactory dateTimeFormatterFactory, ConfigurationManager configurationManager, AutoCompleteJsonGenerator autoCompleteJsonGenerator) {
        this(authorizer, dateTimeFormatterFactory, configurationManager);
        this.autoCompleteJsonGenerator = autoCompleteJsonGenerator;
    }

    public String execute() throws Exception {
        if (!this.checkLicense()) {
            this.logger.warn((Object)"EmailThisIssue licence is invalid. Contact us at info@meta-inf.hu.");
            return this.getRedirect("/secure/admin/jeti/jetiLicense.jspa");
        }
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        return super.execute();
    }

    protected boolean checkLicense() {
        return this.authorizer.authorize().isValid();
    }

    protected String doExecute() throws Exception {
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        return this.success();
    }

    public String getJetiAuthPolicy() {
        return this.jetiAuthPolicy;
    }

    public void setJetiAuthPolicy(String jetiAuthPolicy) {
        this.jetiAuthPolicy = jetiAuthPolicy;
    }

    public Authorizer.Policy getPolicy() {
        return this.authorizer.authorize();
    }

    public String formatDate(Date date) {
        return this.dateTimeFormatter.format(date);
    }

    public String escapeQuotes(String text) {
        return text == null ? "" : text.replaceAll("\"", "'");
    }

    public abstract String getActiveTabClass(String var1);

    public Configuration getGlobalConfiguration() {
        return this.configurationManager.getGlobalConfiguration();
    }

    protected boolean isBeforeJira6() {
        return this.appVersionManager.isBeforeJira6();
    }

    public I18nHelper getI18n() {
        return super.getI18nHelper();
    }

    protected String success() {
        return this.isBeforeJira6() ? "success" : SUCCESS6;
    }

    protected String error() {
        return "error";
    }

    public String getVisibleFieldNamesJson() throws JSONException {
        return this.autoCompleteJsonGenerator.getVisibleFieldNamesJson(this.getLoggedInUser(), this.getLocale());
    }

    public String getVisibleFunctionNamesJson() throws JSONException {
        return this.autoCompleteJsonGenerator.getVisibleFunctionNamesJson(this.getLoggedInUser(), this.getLocale());
    }

    public String getJqlReservedWordsJson() throws JSONException {
        return this.autoCompleteJsonGenerator.getJqlReservedWordsJson();
    }

    public String getNewFeatureMessage(String key) {
        String label;
        String labelKey = "message.new.feature." + key;
        return labelKey.equals(label = this.getI18nHelper().getText(labelKey)) ? null : label;
    }
}

