/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action.config;

import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.metainf.jira.plugin.emailissue.action.EmailBuilder;
import com.metainf.jira.plugin.emailissue.action.EmailOptions;
import com.metainf.jira.plugin.emailissue.action.EmailSource;
import com.metainf.jira.plugin.emailissue.action.Recipient;
import com.metainf.jira.plugin.emailissue.action.config.TabSupport;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.Template;
import com.metainf.jira.plugin.emailissue.entity.TemplateDao;
import com.metainf.jira.plugin.emailissue.mail.SmartEmail;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import com.metainf.jira.plugin.emailissue.workflow.EmailDefinitionImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SendTestEmail
extends TabSupport {
    private TemplateDao templateDao;
    private Long templateId;
    private String emailFormat;
    private String subject;
    private String body;
    private String recipient;
    private String issueKey;
    private CustomFieldManager customFieldManager;
    private EmailBuilder emailBuilder;
    private IssueManager issueManager;
    private SmartEmail email;

    public SendTestEmail(Authorizer authorizer, DateTimeFormatterFactory dateTimeFormatterFactory, TemplateDao templateDao, CustomFieldManager customFieldManager, EmailBuilder emailBuilder, IssueManager issueManager, ConfigurationManager configurationManager) {
        super(authorizer, dateTimeFormatterFactory, configurationManager);
        this.templateDao = templateDao;
        this.customFieldManager = customFieldManager;
        this.issueManager = issueManager;
        this.emailBuilder = emailBuilder;
    }

    public String getContentPage() {
        return "/templates/emailissue/operation/config/send-test-email.vm";
    }

    @Override
    public String getActiveTabClass(String tabName) {
        return "templatesTab".equals(tabName) ? "active-tab" : "";
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public Template getTemplate() {
        Template template = (Template)this.templateDao.getById(this.templateId);
        if (template == null) {
            // empty if block
        }
        return template;
    }

    public String doSend() throws Exception {
        if (this.templateId != null && this.templateId > 0L && StringUtils.isNotEmpty((String)this.issueKey)) {
            MutableIssue issue = this.issueManager.getIssueObject(this.issueKey);
            Template template = this.getTemplate();
            if (issue != null && template != null) {
                EmailOptions emailOptions = new EmailOptions("");
                emailOptions.setAddComments(true);
                emailOptions.setBypassComment(true);
                emailOptions.setEmailFormat(this.emailFormat);
                emailOptions.setMailAsMe(true);
                emailOptions.setReplyToMe(true);
                List<Recipient> to = Arrays.asList(new Recipient("o:me", "me", Recipient.Type.OTHER_USER));
                List<Recipient> cc = Collections.emptyList();
                List<Recipient> bcc = Collections.emptyList();
                EmailDefinitionImpl emailDefinition = new EmailDefinitionImpl((Issue)issue, to, cc, bcc, emailOptions, this.getBody(), this.getSubject(), this.getLoggedInUser(), "", "", "", this.getI18nHelper(), this.getGlobalConfiguration().getEventId(), EmailSource.TEST);
                emailDefinition.setEmailTemplate(template);
                this.emailBuilder.sendEmail(emailDefinition, this.getLoggedInUser());
            }
        }
        return this.getRedirect("/secure/admin/jeti/jetiTemplates.jspa");
    }

    public String doPreview() throws Exception {
        if (this.templateId != null && this.templateId > 0L && StringUtils.isNotEmpty((String)this.issueKey)) {
            MutableIssue issue = this.issueManager.getIssueObject(this.issueKey);
            Template template = this.getTemplate();
            if (issue != null && template != null) {
                EmailOptions emailOptions = new EmailOptions("");
                emailOptions.setAddComments(true);
                emailOptions.setBypassComment(true);
                emailOptions.setEmailFormat(this.emailFormat);
                emailOptions.setMailAsMe(true);
                emailOptions.setReplyToMe(true);
                List<Recipient> to = Arrays.asList(new Recipient("o:me", "me", Recipient.Type.OTHER_USER));
                List<Recipient> cc = Collections.emptyList();
                List<Recipient> bcc = Collections.emptyList();
                EmailDefinitionImpl emailDefinition = new EmailDefinitionImpl((Issue)issue, to, cc, bcc, emailOptions, this.getBody(), this.getSubject(), this.getLoggedInUser(), "", "", "", this.getI18nHelper(), this.getGlobalConfiguration().getEventId(), EmailSource.PREVIEW);
                emailDefinition.setEmailTemplate(template);
                this.email = this.emailBuilder.buildEmail(emailDefinition, this.getSubject(), this.getLoggedInUser());
            }
        }
        return "preview";
    }

    public TemplateDao getTemplateDao() {
        return this.templateDao;
    }

    public void setTemplateDao(TemplateDao templateDao) {
        this.templateDao = templateDao;
    }

    public String getEmailFormat() {
        return this.emailFormat;
    }

    public void setEmailFormat(String emailFormat) {
        this.emailFormat = emailFormat;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public void setIssueKey(String issueKey) {
        this.issueKey = issueKey;
    }

    public SmartEmail getEmail() {
        return this.email;
    }

    public void setEmail(SmartEmail email) {
        this.email = email;
    }
}

