/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action.config;

import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.metainf.jira.plugin.emailissue.action.config.TabSupport;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.CannedResponse;
import com.metainf.jira.plugin.emailissue.entity.CannedResponseDao;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.java.ao.Entity;
import org.apache.log4j.Logger;

public class Responses
extends TabSupport {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    private final CannedResponseDao cannedResponseDao;
    private Long responseId;
    private String name;
    private String desc;
    private String response;
    private String labels;

    public Responses(Authorizer authorizer, DateTimeFormatterFactory dateTimeFormatterFactory, ConfigurationManager configurationManager, CannedResponseDao cannedResponseDao) {
        super(authorizer, dateTimeFormatterFactory, configurationManager);
        this.cannedResponseDao = cannedResponseDao;
    }

    public String getContentPage() {
        return this.isBeforeJira6() ? "/templates/emailissue/operation/config/canned-responses.vm" : "/templates/emailissue/operation/config/canned-responses6.vm";
    }

    @Override
    public String getActiveTabClass(String tabName) {
        return "responsesTab".equals(tabName) ? "active-tab" : "";
    }

    public Collection<CannedResponse> getResponses() {
        ArrayList<Entity> responses = new ArrayList<Entity>(Arrays.asList(this.cannedResponseDao.findAll("LABELS ASC, NAME ASC")));
        return responses;
    }

    public String doDelete() {
        CannedResponse response;
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        if (this.responseId != null && this.responseId != 0L && (response = (CannedResponse)this.cannedResponseDao.getById(this.responseId)) != null) {
            this.cannedResponseDao.delete(response);
        }
        return this.getRedirect("/secure/admin/jeti/cannedResponses.jspa");
    }

    public Long getResponseId() {
        return this.responseId;
    }

    public void setResponseId(Long responseId) {
        this.responseId = responseId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public String getLabels() {
        return this.labels;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }

    public String doAdd() {
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        CannedResponse newResponse = this.cannedResponseDao.create(this.name, this.desc, this.response, this.labels);
        return this.getRedirect("/secure/admin/jeti/cannedResponses.jspa");
    }

    public String doEdit() {
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        return "edit";
    }
}

