/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action.config;

import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.impl.RenderableTextCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.metainf.jira.plugin.emailissue.action.config.TabSupport;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.Context;
import com.metainf.jira.plugin.emailissue.entity.ContextDao;
import com.metainf.jira.plugin.emailissue.entity.NotificationTemplate;
import com.metainf.jira.plugin.emailissue.entity.NotificationTemplateDao;
import com.metainf.jira.plugin.emailissue.entity.Template;
import com.metainf.jira.plugin.emailissue.entity.TemplateDao;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.java.ao.Entity;
import org.apache.log4j.Logger;

public class Projects
extends TabSupport {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    private ProjectManager projectManager;
    private IssueTypeManager issueTypeManager;
    private final CustomFieldManager customFieldManager;
    private TemplateDao templateDao;
    private ContextDao contextDao;
    private NotificationTemplateDao notificationTemplateDao;
    private Long contextId;
    private Long projectId;
    private Long issueTypeId;
    private Long templateId;
    private Long prefillTemplateId;
    private Long notificationId;
    private boolean overwriteContext;
    private boolean emailDetailsInComment;
    private String senderTemplate;
    private String fromAddress;
    private Long externalWatcherFieldId;
    private Long userRecipientField;

    public Projects(Authorizer authorizer, DateTimeFormatterFactory dateTimeFormatterFactory, ProjectManager projectManager, IssueTypeManager issueTypeManager, TemplateDao templateDao, ContextDao contextDao, NotificationTemplateDao notificationTemplateDao, ConfigurationManager configurationManager, CustomFieldManager customFieldManager) {
        super(authorizer, dateTimeFormatterFactory, configurationManager);
        this.projectManager = projectManager;
        this.issueTypeManager = issueTypeManager;
        this.templateDao = templateDao;
        this.notificationTemplateDao = notificationTemplateDao;
        this.customFieldManager = customFieldManager;
        this.contextDao = contextDao;
    }

    public List<Context> getContexts() {
        ArrayList<Entity> ctxs = new ArrayList<Entity>(Arrays.asList(this.contextDao.findAll()));
        Collections.sort(ctxs, new Context.EntityComparator());
        return ctxs;
    }

    public String doDelete() {
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        if (this.contextId != 0L) {
            Context ctx = (Context)this.contextDao.getById(this.contextId);
            this.contextDao.delete(ctx);
        }
        return this.success();
    }

    public String doSave() {
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        if (this.contextId != 0L) {
            Context context = (Context)this.contextDao.getById(this.contextId);
        }
        return this.success();
    }

    public String getContentPage() {
        return this.isBeforeJira6() ? "/templates/emailissue/operation/config/projects.vm" : "/templates/emailissue/operation/config/projects6.vm";
    }

    @Override
    public String getActiveTabClass(String tabName) {
        return "projectsTab".equals(tabName) ? "active-tab" : "";
    }

    public List<Project> getProjects() {
        ArrayList<Project> projects = new ArrayList<Project>(this.projectManager.getProjectObjects());
        return projects;
    }

    public List<IssueType> getIssueTypes() {
        ArrayList<IssueType> types = new ArrayList<IssueType>(this.issueTypeManager.getIssueTypes());
        return types;
    }

    public List<Template> getTemplates() {
        ArrayList<Entity> templates = new ArrayList<Entity>(Arrays.asList(this.templateDao.findAll("NAME ASC")));
        Collections.sort(templates, new Template.EntityComparator());
        return templates;
    }

    public List<NotificationTemplate> getNotificationTemplates() {
        ArrayList<Entity> templates = new ArrayList<Entity>(Arrays.asList(this.notificationTemplateDao.findAll()));
        Collections.sort(templates, new NotificationTemplate.EntityComparator());
        return templates;
    }

    public Long getContextId() {
        return this.contextId;
    }

    public void setContextId(Long contextId) {
        this.contextId = contextId;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getIssueTypeId() {
        return this.issueTypeId;
    }

    public void setIssueTypeId(Long issueTypeId) {
        this.issueTypeId = issueTypeId;
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public Long getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(Long notificationId) {
        this.notificationId = notificationId;
    }

    public String getProjectName(Long projectId) {
        if (projectId == null) {
            return "";
        }
        Project p = projectId == null ? null : this.projectManager.getProjectObj(projectId);
        return p == null ? "<span style='color:red; font-style:italic;'>Project has been deleted</span>" : p.getName();
    }

    public Project getProject(Long projectId) {
        return this.projectManager.getProjectObj(projectId);
    }

    public String getIssueTypeName(String issueTypeId) {
        if (issueTypeId == null) {
            return "";
        }
        IssueType t = this.issueTypeManager.getIssueType(issueTypeId);
        return t == null ? "<span style='color:red; font-style:italic;'>Issue type has been deleted</span>" : t.getNameTranslation();
    }

    public IssueType getIssueType(String issueTypeId) {
        return this.issueTypeManager.getIssueType(issueTypeId);
    }

    public boolean isOverwriteContext() {
        return this.overwriteContext;
    }

    public void setOverwriteContext(boolean overwriteContext) {
        this.overwriteContext = overwriteContext;
    }

    public String getSenderTemplate() {
        return this.senderTemplate;
    }

    public void setSenderTemplate(String senderTemplate) {
        this.senderTemplate = senderTemplate;
    }

    public Long getExternalWatcherFieldId() {
        return this.externalWatcherFieldId;
    }

    public void setExternalWatcherFieldId(Long externalWatcherFieldId) {
        this.externalWatcherFieldId = externalWatcherFieldId;
    }

    public List<CustomField> getCustomFields() {
        try {
            ArrayList<CustomField> fields = new ArrayList<CustomField>(this.customFieldManager.getCustomFieldObjects());
            Iterator it = fields.iterator();
            while (it.hasNext()) {
                CustomField customField = (CustomField)it.next();
                CustomFieldType fieldType = customField.getCustomFieldType();
                if (fieldType instanceof RenderableTextCFType) continue;
                it.remove();
            }
            return fields;
        }
        catch (IssuePermissionException e) {
            return Collections.EMPTY_LIST;
        }
    }

    public String getCustomFieldName(Long customFieldId) {
        if (customFieldId == null) {
            return "";
        }
        CustomField cf = customFieldId == null ? null : this.customFieldManager.getCustomFieldObject(customFieldId);
        return cf == null ? "<span style='color:red; font-style:italic;'>CustomField has been deleted</span>" : cf.getName();
    }

    public boolean isEmailDetailsInComment() {
        return this.emailDetailsInComment;
    }

    public void setEmailDetailsInComment(boolean emailDetailsInComment) {
        this.emailDetailsInComment = emailDetailsInComment;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public Long getPrefillTemplateId() {
        return this.prefillTemplateId;
    }

    public void setPrefillTemplateId(Long prefillTemplateId) {
        this.prefillTemplateId = prefillTemplateId;
    }

    public Long getUserRecipientField() {
        return this.userRecipientField;
    }

    public void setUserRecipientField(Long userRecipientField) {
        this.userRecipientField = userRecipientField;
    }
}

