/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action.config;

import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.metainf.jira.plugin.emailissue.action.config.TabSupport;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.Context;
import com.metainf.jira.plugin.emailissue.entity.ContextDao;
import com.metainf.jira.plugin.emailissue.entity.NotificationTemplate;
import com.metainf.jira.plugin.emailissue.entity.NotificationTemplateDao;
import com.metainf.jira.plugin.emailissue.entity.RuleProcessorType;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.java.ao.Entity;
import org.apache.log4j.Logger;

public class Notifications
extends TabSupport {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    private NotificationTemplateDao notificationTemplateDao;
    private ContextDao contextDao;
    private String notificationName;
    private String notificationDescription;
    private long notificationId;
    private String ruleProcessorType;

    public Notifications(Authorizer authorizer, DateTimeFormatterFactory dateTimeFormatterFactory, NotificationTemplateDao notificationTemplateDao, ContextDao contextDao, ConfigurationManager configurationManager) {
        super(authorizer, dateTimeFormatterFactory, configurationManager);
        this.notificationTemplateDao = notificationTemplateDao;
        this.contextDao = contextDao;
    }

    public List<NotificationTemplate> getNotifications() {
        ArrayList<Entity> notificationTemplates = new ArrayList<Entity>(Arrays.asList(this.notificationTemplateDao.findAll()));
        Collections.sort(notificationTemplates, new NotificationTemplate.EntityComparator());
        return notificationTemplates;
    }

    public String getContentPage() {
        return this.isBeforeJira6() ? "/templates/emailissue/operation/config/notifications.vm" : "/templates/emailissue/operation/config/notifications6.vm";
    }

    @Override
    public String getActiveTabClass(String tabName) {
        return "notificationsTab".equals(tabName) ? "active-tab" : "";
    }

    public String getNotificationName() {
        return this.notificationName;
    }

    public void setNotificationName(String notificationName) {
        this.notificationName = notificationName;
    }

    public String getNotificationDescription() {
        return this.notificationDescription;
    }

    public void setNotificationDescription(String notificationDescription) {
        this.notificationDescription = notificationDescription;
    }

    public String doCopy() {
        NotificationTemplate notification;
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        if (this.notificationId != 0L && (notification = (NotificationTemplate)this.notificationTemplateDao.getById(this.notificationId)) != null) {
            NotificationTemplate notificationTemplate = this.notificationTemplateDao.clone(notification);
        }
        return this.getRedirect("/secure/admin/jeti/jetiNotifications.jspa");
    }

    public String doAdd() {
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        if (this.notificationName != null) {
            Optional processorType = Enums.getIfPresent(RuleProcessorType.class, (String)this.getRuleProcessorType());
            NotificationTemplate template = this.notificationTemplateDao.create(this.notificationName, this.notificationDescription, (RuleProcessorType)((Object)processorType.or((Object)RuleProcessorType.PROCESS_FIRST_MATCHING)));
            return this.getRedirect("/secure/admin/jeti/jetiNotificationEvents.jspa?notificationTemplateId=" + template.getID());
        }
        return this.success();
    }

    public String doDelete() {
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        if (this.notificationId != 0L) {
            Context[] hits = (Context[])this.contextDao.filter("NOTIFICATION_ID = ?", new Object[]{this.notificationId});
            if (hits != null && hits.length > 0) {
                this.addErrorMessage("There are contexts using this notification template, therefore the it cannot be deleted.");
            } else {
                NotificationTemplate notificationTemplate = (NotificationTemplate)this.notificationTemplateDao.getById(this.notificationId);
                if (notificationTemplate != null) {
                    this.notificationTemplateDao.delete(notificationTemplate);
                }
            }
        }
        return this.success();
    }

    public long getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(long notificationId) {
        this.notificationId = notificationId;
    }

    public String getRuleProcessorType() {
        return this.ruleProcessorType;
    }

    public void setRuleProcessorType(String ruleProcessorType) {
        this.ruleProcessorType = ruleProcessorType;
    }
}

