/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action.config;

import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.metainf.jira.plugin.emailissue.action.config.TabSupport;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.NotificationEvent;
import com.metainf.jira.plugin.emailissue.entity.NotificationEventDao;
import com.metainf.jira.plugin.emailissue.entity.NotificationRecipientDao;
import com.metainf.jira.plugin.emailissue.entity.NotificationTemplate;
import com.metainf.jira.plugin.emailissue.entity.NotificationTemplateDao;
import com.metainf.jira.plugin.emailissue.entity.Template;
import com.metainf.jira.plugin.emailissue.entity.TemplateDao;
import com.metainf.jira.plugin.emailissue.events.ServiceDeskEvent;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.java.ao.Entity;
import org.apache.log4j.Logger;

public class NotificationEvents
extends TabSupport {
    private static Logger logger = Logger.getLogger(NotificationEvents.class);
    private EventTypeManager eventTypeManager;
    private NotificationEventDao notificationEventDao;
    private NotificationTemplateDao notificationTemplateDao;
    private TemplateDao templateDao;
    private NotificationRecipientDao recipientDao;
    private long notificationTemplateId;
    private Long notificationEventId;
    private Long eventTypeId;
    private Long templateId;
    private Long sdEventTypeId;
    private String eventNotificationType;

    public NotificationEvents(Authorizer authorizer, DateTimeFormatterFactory dateTimeFormatterFactory, TemplateDao templateDao, NotificationTemplateDao notificationTemplateDao, NotificationEventDao notificationEventDao, NotificationRecipientDao recipientDao, EventTypeManager eventTypeManager, ConfigurationManager configurationManager) {
        super(authorizer, dateTimeFormatterFactory, configurationManager);
        this.templateDao = templateDao;
        this.notificationTemplateDao = notificationTemplateDao;
        this.notificationEventDao = notificationEventDao;
        this.recipientDao = recipientDao;
        this.eventTypeManager = eventTypeManager;
    }

    public List<NotificationEvent> getNotificationEvents() {
        ArrayList<Entity> events = new ArrayList<Entity>(Arrays.asList(this.notificationEventDao.filter("NOTIFICATION_TEMPLATE_ID = ?", new Object[]{this.notificationTemplateId})));
        Collections.sort(events, new NotificationEvent.EntityComparator());
        return events;
    }

    @Override
    public String getActiveTabClass(String tabName) {
        return "notificationsTab".equals(tabName) ? "active-tab" : "";
    }

    public long getNotificationTemplateId() {
        return this.notificationTemplateId;
    }

    public void setNotificationTemplateId(long notificationTemplateId) {
        this.notificationTemplateId = notificationTemplateId;
    }

    public String getContentPage() {
        return "/templates/emailissue/operation/config/notification-events6.vm";
    }

    public List<Template> getTemplates() {
        ArrayList<Entity> templates = new ArrayList<Entity>(Arrays.asList(this.templateDao.findAll("NAME ASC")));
        Collections.sort(templates, new Template.EntityComparator());
        return templates;
    }

    public List<EventType> getEventTypes() {
        ArrayList<EventType> types = new ArrayList<EventType>(this.eventTypeManager.getEventTypes());
        types.add(0, NotificationEvent.DEFAULT_EVENT_TYPE);
        return types;
    }

    public List<EventType> getServiceDeskEventTypes() {
        ArrayList<EventType> types = new ArrayList<EventType>(ServiceDeskEvent.toEventTypes());
        return types;
    }

    public NotificationTemplate getNotificationTemplate() {
        return this.notificationTemplateId > 0L ? (NotificationTemplate)this.notificationTemplateDao.getById(this.notificationTemplateId) : null;
    }

    public String doAdd() {
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        if (this.notificationTemplateId > 0L) {
            Long baseEventId;
            Long l = baseEventId = "issueEvent".equalsIgnoreCase(this.eventNotificationType) ? this.eventTypeId : this.sdEventTypeId;
            if (baseEventId != null) {
                Template template;
                NotificationTemplate notification = (NotificationTemplate)this.notificationTemplateDao.getById(this.notificationTemplateId);
                Template template2 = template = this.templateId == null || this.templateId == 0L ? null : (Template)this.templateDao.getById(this.templateId);
                if (notification != null) {
                    NotificationEvent notificationEvent = this.notificationEventDao.create(notification, Math.abs(baseEventId), template, baseEventId < 0L, null);
                    return this.getRedirect("/secure/admin/jeti/jetiEditNotificationEvent.jspa?notificationEventId=" + notificationEvent.getID());
                }
            }
        }
        return this.success();
    }

    public String doDelete() {
        NotificationEvent event;
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        if (this.notificationEventId != null && this.notificationEventId > 0L && (event = (NotificationEvent)this.notificationEventDao.getById(this.notificationEventId)) != null) {
            this.notificationEventDao.delete(event);
        }
        return this.success();
    }

    public Long getEventTypeId() {
        return this.eventTypeId;
    }

    public void setEventTypeId(Long eventTypeId) {
        this.eventTypeId = eventTypeId;
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public Long getNotificationEventId() {
        return this.notificationEventId;
    }

    public void setNotificationEventId(Long notificationEventId) {
        this.notificationEventId = notificationEventId;
    }

    public List<NotificationEvent> filterForIssueEventNotifications(List<NotificationEvent> allEvents) {
        ArrayList<NotificationEvent> issueEventNofifications = new ArrayList<NotificationEvent>(allEvents);
        Iterator it = issueEventNofifications.iterator();
        while (it.hasNext()) {
            if (!((NotificationEvent)it.next()).isServiceDeskCustomerNotification()) continue;
            it.remove();
        }
        Collections.sort(issueEventNofifications, new NotificationEvent.EntityComparator());
        return issueEventNofifications;
    }

    public List<NotificationEvent> filterForCustomerNotifications(List<NotificationEvent> allEvents) {
        ArrayList<NotificationEvent> customerNofifications = new ArrayList<NotificationEvent>(allEvents);
        Iterator it = customerNofifications.iterator();
        while (it.hasNext()) {
            if (((NotificationEvent)it.next()).isServiceDeskCustomerNotification()) continue;
            it.remove();
        }
        Collections.sort(customerNofifications, new NotificationEvent.EntityComparator());
        return customerNofifications;
    }

    public Long getSdEventTypeId() {
        return this.sdEventTypeId;
    }

    public void setSdEventTypeId(Long sdEventTypeId) {
        this.sdEventTypeId = sdEventTypeId;
    }

    public String getEventNotificationType() {
        return this.eventNotificationType;
    }

    public void setEventNotificationType(String eventNotificationType) {
        this.eventNotificationType = eventNotificationType;
    }
}

