/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action.config;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.impl.RenderableTextCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.component.jql.AutoCompleteJsonGenerator;
import com.metainf.jira.plugin.emailissue.action.EmailOptions;
import com.metainf.jira.plugin.emailissue.action.EmailSupport;
import com.metainf.jira.plugin.emailissue.action.EmailSupportOptionsInitializer;
import com.metainf.jira.plugin.emailissue.action.GlobalConfigHelper;
import com.metainf.jira.plugin.emailissue.action.Recipient;
import com.metainf.jira.plugin.emailissue.action.UserResolver;
import com.metainf.jira.plugin.emailissue.action.config.IssueField;
import com.metainf.jira.plugin.emailissue.action.config.TabSupport;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.NotificationEvent;
import com.metainf.jira.plugin.emailissue.entity.NotificationEventDao;
import com.metainf.jira.plugin.emailissue.entity.NotificationRecipient;
import com.metainf.jira.plugin.emailissue.entity.NotificationRecipientDao;
import com.metainf.jira.plugin.emailissue.entity.Template;
import com.metainf.jira.plugin.emailissue.entity.TemplateDao;
import com.metainf.jira.plugin.emailissue.events.ServiceDeskEvent;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import com.metainf.jira.plugin.emailissue.util.CustomFieldUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;

public class NotificationEventEdit
extends TabSupport
implements EmailSupport {
    private static Logger logger = Logger.getLogger(NotificationEventEdit.class);
    private GlobalPermissionManager globalPermissionManager;
    private ProjectRoleManager projectRoleManager;
    private GroupManager groupManager;
    private CustomFieldManager customFieldManager;
    private TemplateDao templateDao;
    private NotificationEventDao notificationEventDao;
    private NotificationRecipientDao recipientDao;
    private UserResolver userResolver;
    private final EventTypeManager eventTypeManager;
    private Long notificationEventId;
    private NotificationEvent event;
    private Long[] eventTypeIds;
    private Long templateId;
    private String emailIssueTo;
    private String emailIssueCc;
    private String emailIssueBcc;
    private String[] recipients;
    private Set<String> recipientIndex = new HashSet<String>();
    private String[] blindcopyrecipients;
    private Set<String> blindcopyrecipientIndex = new HashSet<String>();
    private String[] copyrecipients;
    private Set<String> copyrecipientIndex = new HashSet<String>();
    private EmailOptions emailOptions = new EmailOptions("");
    private String addAttachments;
    private String emailIssueSubject;
    private String emailIssueBody;
    private String jqlQuery;
    private String sequenceNumber;
    private String[] changelogFilter;
    private String description;

    public NotificationEventEdit(Authorizer authorizer, DateTimeFormatterFactory dateTimeFormatterFactory, CustomFieldManager customFieldManager, ProjectRoleManager projectRoleManager, GroupManager groupManager, ConfigurationManager configurationManager, GlobalPermissionManager globalPermissionManager, NotificationEventDao notificationEventDao, TemplateDao templateDao, NotificationRecipientDao recipientDao, UserResolver userResolver, EventTypeManager eventTypeManager) {
        super(authorizer, dateTimeFormatterFactory, configurationManager, (AutoCompleteJsonGenerator)ComponentAccessor.getComponentOfType(AutoCompleteJsonGenerator.class));
        this.customFieldManager = customFieldManager;
        this.globalPermissionManager = globalPermissionManager;
        this.projectRoleManager = projectRoleManager;
        this.groupManager = groupManager;
        this.notificationEventDao = notificationEventDao;
        this.templateDao = templateDao;
        this.recipientDao = recipientDao;
        this.userResolver = userResolver;
        this.eventTypeManager = eventTypeManager;
    }

    @Override
    public String getActiveTabClass(String tabName) {
        return "notificationsTab".equals(tabName) ? "active-tab" : "";
    }

    public String getContentPage() {
        return this.event.isServiceDeskCustomerNotification() ? "/templates/emailissue/operation/config/customer-notification-edit.vm" : "/templates/emailissue/operation/config/notification-event-edit.vm";
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        NotificationEventEdit.logger = logger;
    }

    public Long getNotificationEventId() {
        return this.notificationEventId;
    }

    public void setNotificationEventId(Long notificationEventId) {
        this.notificationEventId = notificationEventId;
        this.event = this.notificationEventId != null ? (NotificationEvent)this.notificationEventDao.getById(this.notificationEventId) : null;
    }

    public NotificationEvent getNotificationEvent() {
        return this.event;
    }

    public List<EventType> getEventTypes() {
        ArrayList<EventType> types = new ArrayList<EventType>();
        if (this.event.isServiceDeskCustomerNotification()) {
            types.addAll(ServiceDeskEvent.toEventTypes());
        } else {
            types.addAll(this.eventTypeManager.getEventTypes());
            types.add(0, NotificationEvent.DEFAULT_EVENT_TYPE);
        }
        return types;
    }

    public List<Template> getTemplates() {
        ArrayList<Template> templates = new ArrayList<Template>();
        templates.addAll(Arrays.asList(this.templateDao.findAll("NAME ASC")));
        Collections.sort(templates, new Template.EntityComparator());
        if (this.event.isServiceDeskCustomerNotification()) {
            Set<EventType> events = this.event.getEventTypes();
            if (events != null && !events.isEmpty()) {
                ServiceDeskEvent requestEvent = ServiceDeskEvent.byIdOr(events.iterator().next().getId(), ServiceDeskEvent.REQUEST_UPDATED);
                Iterator<Template> it = templates.iterator();
                while (it.hasNext()) {
                    if (it.next().getTheme() == requestEvent.getTemplateTheme()) continue;
                    it.remove();
                }
            } else {
                templates.clear();
            }
        }
        return templates;
    }

    public Long[] getEventTypeIds() {
        return this.eventTypeIds;
    }

    public void setEventTypeIds(Long[] eventTypeIds) {
        this.eventTypeIds = eventTypeIds;
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    @Override
    public String getEmailIssueTo() {
        return this.emailIssueTo;
    }

    @Override
    public void setEmailIssueTo(String emailIssueTo) {
        this.emailIssueTo = emailIssueTo;
    }

    @Override
    public String getEmailIssueBcc() {
        return this.emailIssueBcc;
    }

    @Override
    public void setEmailIssueBcc(String emailIssueBcc) {
        this.emailIssueBcc = emailIssueBcc;
    }

    @Override
    public String getEmailIssueCc() {
        return this.emailIssueCc;
    }

    @Override
    public void setEmailIssueCc(String emailIssueCc) {
        this.emailIssueCc = emailIssueCc;
    }

    @Override
    public String[] getRecipients() {
        return this.recipients;
    }

    @Override
    public void setRecipients(String[] recipients) {
        this.recipients = recipients;
        this.recipientIndex = this.buildRecipients(recipients).keySet();
    }

    @Override
    public String[] getCopyrecipients() {
        return this.copyrecipients;
    }

    @Override
    public void setCopyrecipients(String[] copyrecipients) {
        this.copyrecipients = copyrecipients;
        this.copyrecipientIndex = this.buildRecipients(copyrecipients).keySet();
    }

    @Override
    public String[] getBlindcopyrecipients() {
        return this.blindcopyrecipients;
    }

    @Override
    public void setBlindcopyrecipients(String[] blindcopyrecipients) {
        this.blindcopyrecipients = blindcopyrecipients;
        this.blindcopyrecipientIndex = this.buildRecipients(blindcopyrecipients).keySet();
    }

    public EmailOptions getEmailOptions() {
        return this.emailOptions;
    }

    public void setEmailOptions(EmailOptions emailOptions) {
        this.emailOptions = emailOptions;
    }

    @Override
    public String getAddAttachments() {
        return this.addAttachments;
    }

    public void setAddAttachments(String addAttachments) {
        this.addAttachments = addAttachments;
    }

    @Override
    public String getEmailIssueSubject() {
        return this.emailIssueSubject;
    }

    public String getEmailIssueSubjectEscaped() {
        return this.emailIssueSubject == null ? null : this.emailIssueSubject.replaceAll("\"", "&quot;");
    }

    @Override
    public void setEmailIssueSubject(String emailIssueSubject) {
        this.emailIssueSubject = emailIssueSubject;
    }

    @Override
    public String getEmailIssueBody() {
        return this.emailIssueBody;
    }

    @Override
    public void setEmailIssueBody(String emailIssueBody) {
        this.emailIssueBody = emailIssueBody;
    }

    public String doCopy() throws Exception {
        NotificationEvent clone;
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        NotificationEvent ne = this.getNotificationEvent();
        if (ne != null && (clone = this.notificationEventDao.clone(ne)) != null) {
            this.notificationEventId = clone.getID();
            this.event = clone;
        }
        return this.doExecute();
    }

    public String doToggle() throws Exception {
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        NotificationEvent ne = this.getNotificationEvent();
        if (ne != null) {
            if (Boolean.TRUE.equals(ne.getDisabled())) {
                ne.setDisabled(Boolean.FALSE);
            } else {
                ne.setDisabled(Boolean.TRUE);
            }
            this.notificationEventDao.update(ne);
            return this.getRedirect("/secure/admin/jeti/jetiNotificationEvents.jspa?notificationTemplateId=" + ne.getNotificationTemplate().getID());
        }
        return this.doExecute();
    }

    @Override
    protected String doExecute() throws Exception {
        NotificationEvent event = this.getNotificationEvent();
        if (event != null) {
            this.setEmailIssueSubject(event.getEmailSubject());
            this.setEmailIssueBody(event.getEmailBody());
            this.setAddAttachments(event.getAddAttachmentsType());
            this.setJqlQuery(event.getJQLFilter());
            this.setSequenceNumber(event.getSequenceNumber() == null ? "1" : event.getSequenceNumber().toString());
            this.setDescription(event.getDescription());
            if (StringUtils.isNotEmpty((String)event.getEmailOptions())) {
                this.setOptions(event.getEmailOptions());
            } else {
                EmailSupportOptionsInitializer.initalizeEmailOptions(this, Collections.EMPTY_MAP, this.getGlobalConfiguration());
            }
            this.changelogFilter = event.getChangelogFilter() == null ? null : event.getChangelogFilter().split(",");
            for (NotificationRecipient nr : event.getRecipients()) {
                if ("to".equals(nr.getRecipientType())) {
                    if (nr.getRecipientKey() != null && nr.getRecipientKey().startsWith("to")) {
                        this.emailIssueTo = nr.getRecipientKey().substring(3);
                        continue;
                    }
                    this.recipientIndex.add(nr.getRecipientKey());
                    continue;
                }
                if ("cc".equals(nr.getRecipientType())) {
                    if (nr.getRecipientKey() != null && nr.getRecipientKey().startsWith("cc")) {
                        this.emailIssueCc = nr.getRecipientKey().substring(3);
                        continue;
                    }
                    this.copyrecipientIndex.add(nr.getRecipientKey());
                    continue;
                }
                if (nr.getRecipientKey() != null && nr.getRecipientKey().startsWith("bcc")) {
                    this.emailIssueBcc = nr.getRecipientKey().substring(4);
                    continue;
                }
                this.blindcopyrecipientIndex.add(nr.getRecipientKey());
            }
        }
        return super.doExecute();
    }

    public String doSave() {
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        NotificationEvent event = this.getNotificationEvent();
        if (event != null && this.eventTypeIds != null && this.eventTypeIds.length > 0) {
            Template template = this.templateId == null || this.templateId == 0L ? null : (Template)this.templateDao.getById(this.templateId);
            event.setTemplate(template);
            event.setEventTypeIds(StringUtils.join(Arrays.asList(this.eventTypeIds), (String)","));
            event.setEventTypeId(null);
            event.setEmailSubject(this.emailIssueSubject);
            event.setEmailBody(this.emailIssueBody);
            event.setAddAttachmentsType(this.addAttachments);
            event.setEmailOptions(this.emailOptions.toString());
            event.setJQLFilter(this.jqlQuery);
            event.setSequenceNumber(NumberUtils.toInt((String)this.getSequenceNumber(), (int)1));
            event.setDescription(this.description);
            event.setChangelogFilter(this.changelogFilter == null ? null : StringUtils.join((Object[])this.changelogFilter, (String)","));
            this.notificationEventDao.update(event);
            this.recipientDao.replaceRecipients(event, this.emailIssueTo, this.emailIssueCc, this.emailIssueBcc, this.recipientIndex, this.copyrecipientIndex, this.blindcopyrecipientIndex);
            return this.getRedirect("/secure/admin/jeti/jetiNotificationEvents.jspa?notificationTemplateId=" + event.getNotificationTemplate().getID());
        }
        return this.success();
    }

    @Override
    public boolean isHasBrowseUserPermission() {
        return this.getLoggedInUser() != null && this.globalPermissionManager.hasPermission(GlobalPermissionKey.USER_PICKER, this.getLoggedInUser());
    }

    @Override
    public boolean isRecipientSelected(String key) {
        return this.recipientIndex.contains(key);
    }

    @Override
    public boolean isCopyRecipientSelected(String key) {
        return this.copyrecipientIndex.contains(key);
    }

    public boolean isBlindCopyRecipientSelected(String key) {
        return this.blindcopyrecipientIndex.contains(key);
    }

    @Override
    public I18nHelper getI18n() {
        return this.getI18nHelper();
    }

    @Override
    public Collection<ProjectRole> getProjectRoles() {
        ArrayList<ProjectRole> roles = new ArrayList<ProjectRole>();
        if (this.event.isServiceDeskCustomerNotification()) {
            ProjectRole customerRole = this.projectRoleManager.getProjectRole("Service Desk Customers");
            if (customerRole != null) {
                roles.add(customerRole);
            }
        } else {
            roles.addAll(this.projectRoleManager.getProjectRoles());
            GlobalConfigHelper.excludeRoles(this.getGlobalConfiguration(), roles);
        }
        return roles;
    }

    @Override
    public Collection<Group> getGroups() {
        ArrayList<Group> groups = new ArrayList<Group>(this.userResolver.getAllUserGroups());
        GlobalConfigHelper.excludeGroups(this.getGlobalConfiguration(), groups);
        return groups;
    }

    @Override
    public List<CustomField> getCustomFields() {
        try {
            List<CustomField> fields = CustomFieldUtil.filterFields(this.getGlobalConfiguration(), this.customFieldManager.getCustomFieldObjects());
            if (this.event.isServiceDeskCustomerNotification()) {
                CustomField requestParticipantField = CustomFieldUtil.getServiceDeskRequestParticipantsField(fields);
                fields = new ArrayList<CustomField>(CustomFieldUtil.filterByType(fields, RenderableTextCFType.class));
                if (requestParticipantField != null) {
                    fields.add(requestParticipantField);
                }
            }
            return fields;
        }
        catch (IssuePermissionException e) {
            return Collections.EMPTY_LIST;
        }
    }

    public CustomField getRequestParticipantField() {
        List<CustomField> fields = CustomFieldUtil.filterFields(this.getGlobalConfiguration(), this.customFieldManager.getCustomFieldObjects());
        CustomField requestParticipantField = CustomFieldUtil.getServiceDeskRequestParticipantsField(fields);
        return requestParticipantField;
    }

    public Map<String, Recipient> buildRecipients(String[] recipientKeys) {
        return Recipient.buildRecipients(recipientKeys, this.customFieldManager, this.groupManager, this.projectRoleManager, this.getI18nHelper());
    }

    @Override
    public boolean isBypassCommentAllowed() {
        return this.getGlobalConfiguration().getBypassComment() == 1;
    }

    @Override
    public Collection<ProjectRole> getUserRoles() {
        return this.projectRoleManager.getProjectRoles();
    }

    @Override
    public boolean isCommentVisibilityGroups() {
        return ComponentAccessor.getApplicationProperties().getOption("jira.comment.level.visibility.groups");
    }

    @Override
    public Collection<String> getUserGroups() {
        ApplicationUser user = ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser();
        if (user == null) {
            return Collections.EMPTY_LIST;
        }
        return this.groupManager.getGroupNamesForUser(user);
    }

    public boolean isUserOptionsEnabled() {
        return !this.getGlobalConfiguration().isUserOptionsDisabled();
    }

    public boolean isAddToWatchers() {
        return this.emailOptions.isAddToWatchers();
    }

    public void setAddToWatchers(boolean addToWatchers) {
        this.emailOptions.setAddToWatchers(addToWatchers);
    }

    public boolean isReplyToMe() {
        return this.emailOptions.isReplyToMe();
    }

    public void setReplyToMe(boolean replyToMe) {
        this.emailOptions.setReplyToMe(replyToMe);
    }

    public boolean isMailAsMe() {
        return this.emailOptions.isMailAsMe();
    }

    public void setMailAsMe(boolean mailAsMe) {
        this.emailOptions.setMailAsMe(mailAsMe);
    }

    public boolean isAddComments() {
        return this.emailOptions.isAddComments();
    }

    public void setAddComments(boolean addComments) {
        this.emailOptions.setAddComments(addComments);
    }

    public boolean isSuppressCommentEvent() {
        return this.emailOptions.isSuppressCommentEvent();
    }

    public void setSuppressCommentEvent(boolean suppressCommentEvent) {
        this.emailOptions.setSuppressCommentEvent(suppressCommentEvent);
    }

    public String getEmailFormat() {
        return this.emailOptions.getEmailFormat();
    }

    public void setEmailFormat(String emailFormat) {
        this.emailOptions.setEmailFormat(emailFormat);
    }

    public String getCommentVisibility() {
        return this.emailOptions.getCommentVisibility();
    }

    public void setCommentVisibility(String commentVisibility) {
        this.emailOptions.setCommentVisibility(commentVisibility);
    }

    public boolean isBypassComment() {
        return this.emailOptions.isBypassComment();
    }

    public void setBypassComment(boolean bypassComment) {
        this.emailOptions.setBypassComment(bypassComment);
    }

    @Override
    public boolean isCommentVisibilitySelected(String cv) {
        return this.getCommentVisibility() != null && this.getCommentVisibility().equals(cv);
    }

    @Override
    public String getOptions() {
        return this.emailOptions.toString();
    }

    @Override
    public void setOptions(String options) {
        this.emailOptions = new EmailOptions(options);
    }

    public Collection<String> getErrorMessages() {
        return super.getErrorMessages();
    }

    public Map<String, String> getErrors() {
        return super.getErrors();
    }

    public String getJqlQuery() {
        return this.jqlQuery;
    }

    public void setJqlQuery(String jqlQuery) {
        this.jqlQuery = jqlQuery;
    }

    public boolean isBccEnabled() {
        return this.getGlobalConfiguration().isBccEnabled();
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public boolean isIgnoreMyChanges() {
        return this.emailOptions.isIgnoreMyChanges();
    }

    public void setIgnoreMyChanges(boolean ignoreMyChanges) {
        this.emailOptions.setIgnoreMyChanges(ignoreMyChanges);
    }

    public List<IssueField> getIssueFields() {
        ArrayList<IssueField> issueFields = new ArrayList<IssueField>(Arrays.asList(IssueField.values()));
        return issueFields;
    }

    public List<CustomField> getCustomFieldsForChangelogFilter() {
        ArrayList<CustomField> fields = new ArrayList<CustomField>(this.customFieldManager.getCustomFieldObjects());
        return fields;
    }

    public void setChangelogFilter(String[] changelogFilter) {
        this.changelogFilter = changelogFilter;
    }

    public boolean isSelectedInChangelogFilter(String fieldId) {
        HashSet<String> fields = new HashSet<String>();
        if (this.changelogFilter != null) {
            fields.addAll(Arrays.asList(this.changelogFilter));
        }
        return fields.contains(fieldId);
    }

    public GlobalPermissionManager getGlobalPermissionManager() {
        return this.globalPermissionManager;
    }

    public void setGlobalPermissionManager(GlobalPermissionManager globalPermissionManager) {
        this.globalPermissionManager = globalPermissionManager;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

