/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action.config;

import com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.metainf.jira.plugin.emailissue.action.config.TabSupport;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.AutoReplyParams;
import com.metainf.jira.plugin.emailissue.entity.AutoReplyParamsDao;
import com.metainf.jira.plugin.emailissue.entity.MailHandlerLog;
import com.metainf.jira.plugin.emailissue.entity.MailHandlerLogDao;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;

public class MailHandlerLogs
extends TabSupport {
    private static final int DEFAULT_LIMIT = 100;
    private String filter;
    private String emailFromDate;
    private String emailToDate;
    private int limit = 100;
    private int when = -7;
    private Long mailHandlerContextId;
    private Long mailHandlerLogId;
    private final ProjectManager projectManager;
    private final IssueTypeManager issueTypeManager;
    private final MailHandlerLogDao mailHandlerLogDao;
    private final AutoReplyParamsDao autoReplyParamsDao;

    public MailHandlerLogs(Authorizer authorizer, DateTimeFormatterFactory dateTimeFormatterFactory, ConfigurationManager configurationManager, ProjectManager projectManager, IssueTypeManager issueTypeManager, MailHandlerLogDao mailHandlerLogDao, AutoReplyParamsDao autoReplyParamsDao, DateTimeFormatterFactory dateTimeFormatterFactory1) {
        super(authorizer, dateTimeFormatterFactory, configurationManager);
        this.projectManager = projectManager;
        this.issueTypeManager = issueTypeManager;
        this.mailHandlerLogDao = mailHandlerLogDao;
        this.autoReplyParamsDao = autoReplyParamsDao;
    }

    public String doPurgePage() throws Exception {
        this.mailHandlerLogDao.deleteAll(this.getHandlerLog());
        return this.getRedirect("/secure/admin/jeti/jetiMailHandlerLog.jspa?mailHandlerContextId=" + this.mailHandlerContextId);
    }

    public String doPurgeAll() throws Exception {
        this.mailHandlerLogDao.deleteAll();
        return this.getRedirect("/secure/admin/jeti/jetiMailHandlerLog.jspa?mailHandlerContextId=" + this.mailHandlerContextId);
    }

    public AutoReplyParams getMailHandlerContext() {
        return this.mailHandlerContextId == null ? null : (AutoReplyParams)this.autoReplyParamsDao.getById(this.mailHandlerContextId);
    }

    public List<MailHandlerLog> getHandlerLog() {
        ArrayList<MailHandlerLog> auditLog = new ArrayList<MailHandlerLog>();
        try {
            AutoReplyParams mailHandlerContext = (AutoReplyParams)this.autoReplyParamsDao.getById(this.mailHandlerContextId);
            if (mailHandlerContext != null) {
                MailHandlerLog[] hits = null;
                Date laterThan = DateUtils.truncate((Date)DateUtils.addDays((Date)new Date(), (int)this.when), (int)5);
                if (StringUtils.isNotBlank((String)this.filter)) {
                    String like = "%" + this.filter + "%";
                    hits = (MailHandlerLog[])this.mailHandlerLogDao.filterAndOrderAndLimit("MAIL_HANDLER_CONTEXT_ID = ? AND PROCESSED_DATE >= ? AND (MESSAGE_ID = ? OR ISSUE_KEY LIKE ? OR ISSUE_SUMMARY LIKE ? OR EMAIL_SUBJECT LIKE ? OR EMAIL_BODY LIKE ? OR RECIPIENTS LIKE ? OR CC LIKE ? OR BCC LIKE ?)", "ID DESC", this.limit, new Object[]{mailHandlerContext.getID(), laterThan, like, like, like, like, like, like, like, like});
                } else {
                    hits = (MailHandlerLog[])this.mailHandlerLogDao.filterAndOrderAndLimit("MAIL_HANDLER_CONTEXT_ID = ? AND PROCESSED_DATE >= ?", "ID DESC", this.limit, new Object[]{mailHandlerContext.getID(), laterThan});
                }
                auditLog.addAll(Arrays.asList(hits));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return auditLog;
    }

    public Long getMailHandlerContextId() {
        return this.mailHandlerContextId;
    }

    public void setMailHandlerContextId(Long mailHandlerContextId) {
        this.mailHandlerContextId = mailHandlerContextId;
    }

    public static int getDefaultLimit() {
        return 100;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getEmailFromDate() {
        return this.emailFromDate;
    }

    public void setEmailFromDate(String emailFromDate) {
        this.emailFromDate = emailFromDate;
    }

    public String getEmailToDate() {
        return this.emailToDate;
    }

    public void setEmailToDate(String emailToDate) {
        this.emailToDate = emailToDate;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getWhen() {
        return this.when;
    }

    public void setWhen(int when) {
        this.when = when;
    }

    @Override
    public String getActiveTabClass(String tabName) {
        return "autoReplyTab".equals(tabName) ? "active-tab" : "";
    }

    public String getContentPage() {
        return "/templates/emailissue/operation/config/mailhandlerlog.vm";
    }

    public Long getMailHandlerLogId() {
        return this.mailHandlerLogId;
    }

    public void setMailHandlerLogId(Long mailHandlerLogId) {
        this.mailHandlerLogId = mailHandlerLogId;
    }

    @Override
    public String formatDate(Date date) {
        return date == null ? "" : this.dateTimeFormatter.format(date);
    }

    public Project getMailHandlerProject() {
        AutoReplyParams mhc = this.getMailHandlerContext();
        return mhc != null && mhc.getProjectId() != null ? this.projectManager.getProjectObj(mhc.getProjectId()) : null;
    }

    public IssueType getMailHandlerIssueType() {
        AutoReplyParams mhc = this.getMailHandlerContext();
        return mhc != null && mhc.getIssueTypeId() != null ? this.issueTypeManager.getIssueType(mhc.getIssueTypeId().toString()) : null;
    }
}

