/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action.config;

import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.metainf.jira.plugin.emailissue.action.config.TabSupport;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.AttachmentNameFilter;
import com.metainf.jira.plugin.emailissue.entity.AttachmentNameFilterDao;
import com.metainf.jira.plugin.emailissue.entity.Configuration;
import com.metainf.jira.plugin.emailissue.entity.MD5Pattern;
import com.metainf.jira.plugin.emailissue.entity.MD5PatternDao;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import com.metainf.jira.plugin.emailissue.util.MD5Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.java.ao.Entity;
import org.apache.commons.lang3.StringUtils;
import webwork.action.ServletActionContext;

public class MD5Patterns
extends TabSupport {
    private final MD5PatternDao md5PatternDao;
    private final AttachmentNameFilterDao attachmentNameFilterDao;
    private String desc;
    private String pattern;
    private Long patternId;
    private Long attachmentSize;

    public MD5Patterns(Authorizer authorizer, DateTimeFormatterFactory dateTimeFormatterFactory, ConfigurationManager configurationManager, MD5PatternDao md5PatternDao, AttachmentNameFilterDao attachmentNameFilterDao) {
        super(authorizer, dateTimeFormatterFactory, configurationManager);
        this.md5PatternDao = md5PatternDao;
        this.attachmentNameFilterDao = attachmentNameFilterDao;
    }

    public String getContentPage() {
        return this.isBeforeJira6() ? "/templates/emailissue/operation/config/md5-patterns.vm" : "/templates/emailissue/operation/config/md5-patterns6.vm";
    }

    @Override
    public String getActiveTabClass(String tabName) {
        return "patternsTab".equals(tabName) ? "active-tab" : "";
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Long getPatternId() {
        return this.patternId;
    }

    public void setPatternId(Long patternId) {
        this.patternId = patternId;
    }

    @Override
    protected String doExecute() throws Exception {
        this.attachmentSize = this.configurationManager.getGlobalConfiguration().getFileSizeThreshold();
        return super.doExecute();
    }

    public String doSaveSize() {
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        Configuration config = this.configurationManager.getGlobalConfiguration();
        config.setFileSizeThreshold(this.attachmentSize);
        this.configurationManager.updateGlobalConfiguration(config);
        return this.getRedirect("/secure/admin/jeti/md5patterns.jspa");
    }

    public String doDelete() {
        MD5Pattern md5p;
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        if (this.patternId != null && this.patternId != 0L && (md5p = (MD5Pattern)this.md5PatternDao.getById(this.patternId)) != null) {
            this.md5PatternDao.delete(md5p);
        }
        return this.getRedirect("/secure/admin/jeti/md5patterns.jspa");
    }

    public String doDeleteBlacklist() {
        AttachmentNameFilter filter;
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        if (this.patternId != null && this.patternId != 0L && (filter = (AttachmentNameFilter)this.attachmentNameFilterDao.getById(this.patternId)) != null) {
            this.attachmentNameFilterDao.delete(filter);
        }
        return this.getRedirect("/secure/admin/jeti/md5patterns.jspa");
    }

    public String doUpload() {
        File file = ServletActionContext.getMultiPartRequest().getFile("fileToHash");
        if (file != null && file.exists()) {
            try {
                String fingerPrint = MD5Util.md5Hex(file);
                String fileName = ServletActionContext.getMultiPartRequest().getFilesystemName("fileToHash");
                fileName = StringUtils.isBlank((CharSequence)fileName) ? file.getName() : fileName;
                MD5Pattern mD5Pattern = this.md5PatternDao.create(fileName, fingerPrint);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getRedirect("/secure/admin/jeti/md5patterns.jspa");
    }

    public String doAdd() {
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        MD5Pattern md5 = this.md5PatternDao.create(this.desc, this.pattern);
        return this.getRedirect("/secure/admin/jeti/md5patterns.jspa");
    }

    public String doAddBlacklist() {
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        AttachmentNameFilter md5 = this.attachmentNameFilterDao.create(this.desc, this.pattern);
        return this.getRedirect("/secure/admin/jeti/md5patterns.jspa");
    }

    public List<MD5Pattern> getPatterns() {
        return new ArrayList<Entity>(Arrays.asList(this.md5PatternDao.findAll("DESCRIPTION ASC")));
    }

    public List<AttachmentNameFilter> getBlacklist() {
        return new ArrayList<Entity>(Arrays.asList(this.attachmentNameFilterDao.findAll("DESCRIPTION ASC")));
    }

    public Long getAttachmentSize() {
        return this.attachmentSize;
    }

    public void setAttachmentSize(Long attachmentSize) {
        this.attachmentSize = attachmentSize;
    }
}

