/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action.config;

public enum IssueField {
    AFFECTED_VERSIONS("affectedVersion", "Affected Versions", "=", "Version"),
    ASSIGNEE("assignee", "Assignee", "="),
    ATTACHMENTS("Attachment", "Attachments", null),
    COMMENT("comment", "Comments", "~"),
    COMPONENTS("component", "Components", "=", "Component"),
    DESCRIPTION("description", "Description", "~"),
    DUEDATE("duedate", "Due Date", "="),
    ENVIRONMENT("environment", "Environment", "~"),
    FIX_VERSIONS("fixVersion", "Fix Versions", "=", "Fix Version"),
    ISSUEKEY("key", "Issue Key", "="),
    ISSUETYPE("issueType", "Issue Type", "="),
    LABELS("labels", "Labels", "=", "labels", true),
    ORIGINAL_ESTIMATE("originalEstimate", "Original Estimate", "=", "timeoriginalestimate"),
    PRIORITY("priority", "Priority", "="),
    PROJECT("project", "Project", "="),
    REPORTER("reporter", "Reporter", "="),
    SECURITY_LEVEL("securityLevel", "Security Level", null),
    STATUS("status", "Status", "="),
    SUMMARY("summary", "Summary", "~");

    private String id;
    private String name;
    private String jqlOperator;
    private String changelogFieldName;
    private boolean requiresExistingIssue = false;

    private IssueField(String id, String name, String jqlOperator) {
        this(id, name, jqlOperator, id);
    }

    private IssueField(String id, String name, String jqlOperator, String changelogFieldName) {
        this.id = id;
        this.name = name;
        this.jqlOperator = jqlOperator;
        this.changelogFieldName = changelogFieldName;
    }

    private IssueField(String id, String name, String jqlOperator, String changelogFieldName, boolean requiresExistingIssue) {
        this(id, name, jqlOperator, changelogFieldName);
        this.requiresExistingIssue = requiresExistingIssue;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public boolean isRequiresExistingIssue() {
        return this.requiresExistingIssue;
    }

    public static IssueField getById(String fieldId) {
        for (IssueField field : IssueField.values()) {
            if (!field.getId().equals(fieldId)) continue;
            return field;
        }
        return null;
    }

    public static IssueField getByChangelogFieldName(String changelogName) {
        for (IssueField field : IssueField.values()) {
            if (field.getChangelogFieldName() == null || !field.getChangelogFieldName().equals(changelogName)) continue;
            return field;
        }
        return null;
    }

    public String getJqlOperator() {
        return this.jqlOperator;
    }

    public String getChangelogFieldName() {
        return this.changelogFieldName;
    }

    public String toJqlFragment(String value) {
        value = "~".equals(this.jqlOperator) ? "\"\\\"" + value + "\\\"\"" : "\"" + value + "\"";
        return String.format("%s %s %s", this.id, this.jqlOperator, value);
    }
}

