/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action.config;

import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.metainf.jira.plugin.emailissue.action.config.IssueField;
import com.metainf.jira.plugin.emailissue.action.config.TabSupport;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.FieldContext;
import com.metainf.jira.plugin.emailissue.entity.FieldContextDao;
import com.metainf.jira.plugin.emailissue.entity.FieldRule;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import com.metainf.jira.plugin.emailissue.util.CustomFieldUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.java.ao.Entity;
import org.apache.commons.lang.StringUtils;

public class FieldContexts
extends TabSupport {
    protected final FieldContextDao fieldContextDao;
    protected final ProjectManager projectManager;
    protected final CustomFieldManager customFieldManager;
    protected final IssueTypeManager issueTypeManager;
    private Long fieldContextId;
    private Long projectId;
    private Long issueTypeId;
    private String description;

    public FieldContexts(Authorizer authorizer, DateTimeFormatterFactory dateTimeFormatterFactory, ConfigurationManager configurationManager, FieldContextDao fieldContextDao, ProjectManager projectManager, CustomFieldManager customFieldManager, IssueTypeManager issueTypeManager) {
        super(authorizer, dateTimeFormatterFactory, configurationManager);
        this.fieldContextDao = fieldContextDao;
        this.projectManager = projectManager;
        this.customFieldManager = customFieldManager;
        this.issueTypeManager = issueTypeManager;
    }

    public String getContentPage() {
        return "/templates/emailissue/operation/config/field-contexts.vm";
    }

    @Override
    public String getActiveTabClass(String tabName) {
        return "fieldsTab".equals(tabName) ? "active-tab" : "";
    }

    public String doAdd() {
        this.setProjectId(null);
        this.setIssueTypeId(null);
        this.setFieldContextId(null);
        this.setDescription(null);
        return this.success();
    }

    public String doDelete() {
        FieldContext fc = this.getFieldContext();
        if (fc != null) {
            this.fieldContextDao.delete(fc);
        }
        return this.getRedirect("/secure/admin/jeti/jetiFields.jspa");
    }

    public String doEdit() {
        if (this.getFieldContextId() == null) {
            return this.doAdd();
        }
        FieldContext fieldContext = (FieldContext)this.fieldContextDao.getById(this.getFieldContextId());
        if (fieldContext == null) {
            this.addErrorMessage("Field Context does not exist.");
        } else {
            this.setProjectId(fieldContext.getProjectId());
            this.setIssueTypeId(fieldContext.getIssueType());
            this.setDescription(fieldContext.getDescription());
        }
        return this.success();
    }

    public String doSave() {
        FieldContext fieldContext = this.fieldContextDao.findByProjectAndType(this.getProjectId(), this.getIssueTypeId());
        if (fieldContext != null && (this.getFieldContextId() == null || this.getFieldContextId() != null && fieldContext.getID() != this.getFieldContextId().intValue())) {
            this.addErrorMessage("Context exists for this combination of Project and Issue Type. Select another values.");
            return this.success();
        }
        fieldContext = this.getFieldContextId() != null ? (FieldContext)this.fieldContextDao.getById(this.getFieldContextId()) : (FieldContext)this.fieldContextDao.newEntity();
        fieldContext.setProjectId(this.getProjectId());
        fieldContext.setIssueType(this.getIssueTypeId());
        fieldContext.setDescription(this.getDescription());
        this.fieldContextDao.update(fieldContext);
        return this.getRedirect("/secure/admin/jeti/jetiFields.jspa");
    }

    public List<FieldContext> getFieldContexts() {
        ArrayList<Entity> ctxs = new ArrayList<Entity>(Arrays.asList(this.fieldContextDao.findAll()));
        Collections.sort(ctxs, new FieldContext.EntityComparator());
        return ctxs;
    }

    public String getProjectName(Long projectId) {
        if (projectId == null) {
            return "";
        }
        Project p = projectId == null ? null : this.projectManager.getProjectObj(projectId);
        return p == null ? "<span style='color:red; font-style:italic;'>Project has been deleted</span>" : p.getName();
    }

    public String getIssueTypeName(Long issueTypeId) {
        if (issueTypeId == null) {
            return "";
        }
        IssueType t = this.issueTypeManager.getIssueType(issueTypeId.toString());
        return t == null ? "<span style='color:red; font-style:italic;'>Issue type has been deleted</span>" : t.getNameTranslation();
    }

    public String getCustomFieldName(Long customFieldId) {
        if (customFieldId == null) {
            return "";
        }
        CustomField cf = customFieldId == null ? null : this.customFieldManager.getCustomFieldObject(customFieldId);
        return cf == null ? "<span style='color:red; font-style:italic;'>CustomField has been deleted</span>" : cf.getName();
    }

    public Long getFieldContextId() {
        return this.fieldContextId;
    }

    public void setFieldContextId(Long fieldContextId) {
        this.fieldContextId = fieldContextId;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getIssueTypeId() {
        return this.issueTypeId;
    }

    public void setIssueTypeId(Long issueTypeId) {
        this.issueTypeId = issueTypeId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Project> getProjects() {
        ArrayList<Project> projects = new ArrayList<Project>(this.projectManager.getProjectObjects());
        return projects;
    }

    public List<IssueType> getIssueTypes() {
        ArrayList<IssueType> types = new ArrayList<IssueType>(this.issueTypeManager.getIssueTypes());
        return types;
    }

    public FieldContext getFieldContext() {
        return this.getFieldContextId() == null ? null : (FieldContext)this.fieldContextDao.getById(this.getFieldContextId());
    }

    public String getFieldName(String fieldId) {
        String name = "";
        if (StringUtils.isNotBlank((String)fieldId)) {
            IssueField issueField;
            CustomField cf;
            name = CustomFieldUtil.CUSTOMFIELD_KEY.matcher(fieldId).matches() ? ((cf = this.customFieldManager.getCustomFieldObject(fieldId)) != null ? cf.getName() : "") : ((issueField = IssueField.getById(fieldId)) != null ? issueField.getName() : "");
        }
        return name;
    }

    public List<FieldRule> getFieldRules(FieldContext fieldContext) {
        ArrayList<FieldRule> fieldRules = new ArrayList<FieldRule>();
        if (fieldContext != null) {
            fieldRules.addAll(Arrays.asList(fieldContext.getFields()));
        }
        this.removeRulesForDeletedFields(fieldRules);
        Collections.sort(fieldRules, new FieldRule.EntityComparator());
        return fieldRules;
    }

    public List<FieldRule> getFieldInitializationRules(List<FieldRule> allRules) {
        ArrayList<FieldRule> fieldRules = new ArrayList<FieldRule>();
        for (FieldRule rule : allRules) {
            if (rule.getFieldRuleType() == FieldRule.FieldRuleType.LOOKUP || rule.getFieldRuleType() == FieldRule.FieldRuleType.WORKFLOW || rule.getFieldRuleType() == FieldRule.FieldRuleType.FILTER) continue;
            fieldRules.add(rule);
        }
        return fieldRules;
    }

    public List<FieldRule> getLookupRules(List<FieldRule> allRules) {
        ArrayList<FieldRule> fieldRules = new ArrayList<FieldRule>();
        for (FieldRule rule : allRules) {
            if (!Boolean.TRUE.equals(rule.isIssueLookupRule()) && rule.getFieldRuleType() != FieldRule.FieldRuleType.LOOKUP) continue;
            fieldRules.add(rule);
        }
        return fieldRules;
    }

    public List<FieldRule> getWorkflowRules(List<FieldRule> allRules) {
        ArrayList<FieldRule> fieldRules = new ArrayList<FieldRule>();
        for (FieldRule rule : allRules) {
            if (rule.getFieldRuleType() != FieldRule.FieldRuleType.WORKFLOW) continue;
            fieldRules.add(rule);
        }
        return fieldRules;
    }

    public List<FieldRule> getFilterRules(List<FieldRule> allRules) {
        ArrayList<FieldRule> fieldRules = new ArrayList<FieldRule>();
        for (FieldRule rule : allRules) {
            if (rule.getFieldRuleType() != FieldRule.FieldRuleType.FILTER) continue;
            fieldRules.add(rule);
        }
        return fieldRules;
    }

    protected void removeRulesForDeletedFields(ArrayList<FieldRule> fieldRules) {
        Iterator<FieldRule> it = fieldRules.iterator();
        while (it.hasNext()) {
            FieldRule fieldRule = it.next();
            if (!StringUtils.isNotBlank((String)fieldRule.getFieldId()) || !CustomFieldUtil.CUSTOMFIELD_KEY.matcher(fieldRule.getFieldId()).matches() || null != this.customFieldManager.getCustomFieldObject(fieldRule.getFieldId())) continue;
            it.remove();
        }
    }
}

