/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action.config;

import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.impl.DateCFType;
import com.atlassian.jira.issue.customfields.impl.DateTimeCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.template.TemplateManager;
import com.metainf.jira.plugin.emailissue.action.config.TabSupport;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.DefaultTemplate;
import com.metainf.jira.plugin.emailissue.entity.Template;
import com.metainf.jira.plugin.emailissue.entity.TemplateDao;
import com.metainf.jira.plugin.emailissue.template.EmailTemplateTheme;
import com.metainf.jira.plugin.emailissue.template.MailTemplateManager;
import com.metainf.jira.plugin.emailissue.template.TemplateField;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class EditTemplate
extends TabSupport {
    private TemplateDao templateDao;
    private MailTemplateManager mailTemplateManager;
    private Long templateId;
    private String jetiTemplateName;
    private String jetiTemplateDesc;
    private String jetiTemplateCat;
    private String jetiTemplateSubject;
    private String jetiTemplateHtml;
    private String jetiTemplateText;
    private String theme;
    private String editor = "richtext";
    private String baseTemplateOrThemeId;
    private String themeId;
    private CustomFieldManager customFieldManager;
    private TemplateManager templateManager;
    private Template template;

    public EditTemplate(Authorizer authorizer, DateTimeFormatterFactory dateTimeFormatterFactory, TemplateDao templateDao, CustomFieldManager customFieldManager, TemplateManager templateManager, MailTemplateManager mailTemplateManager, ConfigurationManager configurationManager) {
        super(authorizer, dateTimeFormatterFactory, configurationManager);
        this.templateDao = templateDao;
        this.customFieldManager = customFieldManager;
        this.templateManager = templateManager;
        this.mailTemplateManager = mailTemplateManager;
    }

    public String getContentPage() {
        return this.isBeforeJira6() ? "/templates/emailissue/operation/config/edit-template.vm" : "/templates/emailissue/operation/config/edit-template6.vm";
    }

    @Override
    public String getActiveTabClass(String tabName) {
        return "templatesTab".equals(tabName) ? "active-tab" : "";
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
        this.template = (Template)this.templateDao.getById(this.templateId);
    }

    public Template getTemplate() {
        return this.template;
    }

    public String doSave() throws Exception {
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        Template template = null;
        template = this.templateId == null || this.templateId == 0L ? (Template)this.templateDao.newEntity() : (Template)this.templateDao.getById(this.templateId);
        template.setName(this.jetiTemplateName);
        template.setDescription(this.jetiTemplateDesc);
        template.setSubject(this.jetiTemplateSubject);
        if (this.jetiTemplateHtml != null) {
            this.jetiTemplateHtml = this.jetiTemplateHtml.replaceAll("&amp;&amp;", "&&").replaceAll("&gt;", ">").replaceAll("&lt;", "<");
        }
        template.setHtml(this.jetiTemplateHtml);
        template.setText(this.jetiTemplateText);
        template.setLabels(this.jetiTemplateCat);
        template.setTheme(EmailTemplateTheme.valueOf(this.getTheme(), null));
        this.templateDao.update(template);
        return this.getRedirect("/secure/admin/jeti/jetiTemplates.jspa");
    }

    public String getJetiTemplateName() {
        return this.jetiTemplateName;
    }

    public void setJetiTemplateName(String jetiTemplateName) {
        this.jetiTemplateName = jetiTemplateName;
    }

    public String getJetiTemplateDesc() {
        return this.jetiTemplateDesc;
    }

    public void setJetiTemplateDesc(String jetiTemplateDesc) {
        this.jetiTemplateDesc = jetiTemplateDesc;
    }

    public String getJetiTemplateSubject() {
        return this.jetiTemplateSubject;
    }

    public void setJetiTemplateSubject(String jetiTemplateSubject) {
        this.jetiTemplateSubject = jetiTemplateSubject;
    }

    public String getJetiTemplateHtml() {
        return this.jetiTemplateHtml;
    }

    public void setJetiTemplateHtml(String jetiTemplateHtml) {
        this.jetiTemplateHtml = jetiTemplateHtml;
    }

    public String getJetiTemplateText() {
        return this.jetiTemplateText;
    }

    public void setJetiTemplateText(String jetiTemplateText) {
        this.jetiTemplateText = jetiTemplateText;
    }

    public String getBaseTemplateOrThemeId() {
        return this.baseTemplateOrThemeId;
    }

    public void setBaseTemplateOrThemeId(String baseTemplateOrThemeId) {
        this.baseTemplateOrThemeId = baseTemplateOrThemeId;
        if (StringUtils.isNumeric((CharSequence)baseTemplateOrThemeId)) {
            long templateId = Long.parseLong(baseTemplateOrThemeId);
            com.atlassian.jira.template.Template jiraTemplate = this.templateManager.getTemplate(Long.valueOf(templateId));
            this.template = jiraTemplate != null ? DefaultTemplate.fromJIRATemplate("Based on JIRA template " + jiraTemplate.getName(), this.getDefaultSubject(), this.templateManager.getTemplateContent(Long.valueOf(templateId), "html"), this.templateManager.getTemplateContent(Long.valueOf(templateId), "text")) : DefaultTemplate.fromTheme(EmailTemplateTheme.defaultTheme());
        } else {
            EmailTemplateTheme theme = StringUtils.isEmpty((CharSequence)baseTemplateOrThemeId) ? EmailTemplateTheme.defaultTheme() : EmailTemplateTheme.valueOf(baseTemplateOrThemeId, EmailTemplateTheme.defaultTheme());
            this.template = DefaultTemplate.fromTheme(theme);
            this.theme = theme.name();
        }
    }

    public String getDefaultSubject() {
        return this.mailTemplateManager.getSubjectTemplate();
    }

    public Collection<TemplateField> getCustomFields() {
        List fields = this.customFieldManager.getCustomFieldObjects();
        ArrayList<TemplateField> templateFields = new ArrayList<TemplateField>(fields.size());
        for (CustomField cf : fields) {
            if (cf.getCustomFieldType() instanceof DateCFType) {
                templateFields.add(new TemplateField(cf.getName(), "#renderCustomField($issue, \"" + cf.getId() + "\") &lt;br/&gt; #renderDate($issue.getCustomFieldValue(\"" + cf.getId() + "\"), \"\") &lt;br/&gt; #renderDate($issue.getCustomFieldValue(\"" + cf.getId() + "\"), \"&lt;date format pattern&gt;\")"));
                continue;
            }
            if (cf.getCustomFieldType() instanceof DateTimeCFType) {
                templateFields.add(new TemplateField(cf.getName(), "#renderCustomField($issue, \"" + cf.getId() + "\") &lt;br/&gt; #renderDateTime($issue.getCustomFieldValue(\"" + cf.getId() + "\"), \"\") &lt;br/&gt; #renderDateTime($issue.getCustomFieldValue(\"" + cf.getId() + "\"), \"&lt;date format pattern&gt;\")"));
                continue;
            }
            templateFields.add(new TemplateField(cf.getName(), "#renderCustomField($issue, \"" + cf.getId() + "\")"));
        }
        return templateFields;
    }

    public Collection<TemplateField> getSystemFields() {
        return TemplateField.systemFields;
    }

    public Collection<TemplateField> getComplexFields() {
        return TemplateField.complexFields;
    }

    public String getJetiTemplateCat() {
        return this.jetiTemplateCat;
    }

    public void setJetiTemplateCat(String jetiTemplateCat) {
        this.jetiTemplateCat = jetiTemplateCat;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public String getEditor() {
        return this.editor;
    }

    public void setEditor(String editor) {
        this.editor = editor;
    }

    public void setThemeId(String themeId) {
        this.themeId = themeId;
    }
}

