/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action.config;

import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.metainf.jira.plugin.emailissue.action.config.TabSupport;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.CannedResponse;
import com.metainf.jira.plugin.emailissue.entity.CannedResponseDao;
import com.metainf.jira.plugin.emailissue.util.Authorizer;

public class EditResponse
extends TabSupport {
    private final CannedResponseDao cannedResponseDao;
    private Long responseId;
    private String name;
    private String desc;
    private String response;
    private String labels;

    public EditResponse(Authorizer authorizer, DateTimeFormatterFactory dateTimeFormatterFactory, ConfigurationManager configurationManager, CannedResponseDao cannedResponseDao) {
        super(authorizer, dateTimeFormatterFactory, configurationManager);
        this.cannedResponseDao = cannedResponseDao;
    }

    @Override
    public String getActiveTabClass(String tabName) {
        return "responsesTab".equals(tabName) ? "active-tab" : "";
    }

    public String getContentPage() {
        return this.isBeforeJira6() ? "/templates/emailissue/operation/config/edit-response.vm" : "/templates/emailissue/operation/config/edit-response6.vm";
    }

    public String doEdit() throws Exception {
        CannedResponse response;
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        if (this.responseId != null && this.responseId > 0L && (response = (CannedResponse)this.cannedResponseDao.getById(this.responseId)) != null) {
            this.setName(response.getName());
            this.setDesc(response.getDescription());
            this.setResponse(response.getResponse());
            this.setLabels(response.getLabels());
        }
        return this.success();
    }

    public String doSave() throws Exception {
        CannedResponse response;
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        if (this.responseId != null && this.responseId > 0L && (response = (CannedResponse)this.cannedResponseDao.getById(this.responseId)) != null) {
            response.setName(this.getName());
            response.setDescription(this.getDesc());
            response.setResponse(this.getResponse());
            response.setLabels(this.getLabels());
            this.cannedResponseDao.update(response);
        }
        return this.getRedirect("/secure/admin/jeti/cannedResponses.jspa");
    }

    public Long getResponseId() {
        return this.responseId;
    }

    public void setResponseId(Long responseId) {
        this.responseId = responseId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public String getLabels() {
        return this.labels;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }
}

