/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action.config;

import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.metainf.jira.plugin.emailissue.action.config.TabSupport;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.NotificationTemplate;
import com.metainf.jira.plugin.emailissue.entity.NotificationTemplateDao;
import com.metainf.jira.plugin.emailissue.entity.RuleProcessorType;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EditNotification
extends TabSupport {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    private NotificationTemplateDao notificationTemplateDao;
    private String notificationName;
    private String notificationDescription;
    private String ruleProcessorType;
    private Long notificationId;

    public EditNotification(Authorizer authorizer, DateTimeFormatterFactory dateTimeFormatterFactory, ConfigurationManager configurationManager, NotificationTemplateDao notificationTemplateDao) {
        super(authorizer, dateTimeFormatterFactory, configurationManager);
        this.notificationTemplateDao = notificationTemplateDao;
    }

    public String doEdit() throws Exception {
        NotificationTemplate notificationTemplate;
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        if ((this.notificationId != null || this.notificationId != 0L) && (notificationTemplate = (NotificationTemplate)this.notificationTemplateDao.getById(this.notificationId)) != null) {
            this.setNotificationName(notificationTemplate.getName());
            this.setNotificationDescription(notificationTemplate.getDescription());
            this.setRuleProcessorType(notificationTemplate.getRuleProcessorType() == null ? RuleProcessorType.PROCESS_FIRST_MATCHING.name() : notificationTemplate.getRuleProcessorType().name());
        }
        return this.success();
    }

    public String doSave() throws Exception {
        NotificationTemplate notificationTemplate;
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        if ((this.notificationId != null || this.notificationId != 0L) && (notificationTemplate = (NotificationTemplate)this.notificationTemplateDao.getById(this.notificationId)) != null && StringUtils.isNotBlank((String)this.notificationName)) {
            notificationTemplate.setName(this.notificationName);
            notificationTemplate.setDescription(this.notificationDescription);
            Optional processorType = Enums.getIfPresent(RuleProcessorType.class, (String)this.getRuleProcessorType());
            notificationTemplate.setRuleProcessorType((RuleProcessorType)((Object)processorType.or((Object)RuleProcessorType.PROCESS_FIRST_MATCHING)));
            this.notificationTemplateDao.update(notificationTemplate);
        }
        return this.getRedirect("/secure/admin/jeti/jetiNotifications.jspa");
    }

    public String doToggle() throws Exception {
        NotificationTemplate notificationTemplate;
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        if ((this.notificationId != null || this.notificationId != 0L) && (notificationTemplate = (NotificationTemplate)this.notificationTemplateDao.getById(this.notificationId)) != null) {
            if (Boolean.TRUE.equals(notificationTemplate.getDisabled())) {
                notificationTemplate.setDisabled(Boolean.FALSE);
            } else {
                notificationTemplate.setDisabled(Boolean.TRUE);
            }
            this.notificationTemplateDao.update(notificationTemplate);
        }
        return this.getRedirect("/secure/admin/jeti/jetiNotifications.jspa");
    }

    @Override
    public String getActiveTabClass(String tabName) {
        return "notificationsTab".equals(tabName) ? "active-tab" : "";
    }

    public String getContentPage() {
        return this.isBeforeJira6() ? "/templates/emailissue/operation/config/edit-notification.vm" : "/templates/emailissue/operation/config/edit-notification6.vm";
    }

    public String getNotificationName() {
        return this.notificationName;
    }

    public void setNotificationName(String notificationName) {
        this.notificationName = notificationName;
    }

    public String getNotificationDescription() {
        return this.notificationDescription;
    }

    public void setNotificationDescription(String notificationDescription) {
        this.notificationDescription = notificationDescription;
    }

    public Long getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(Long notificationId) {
        this.notificationId = notificationId;
    }

    public String getRuleProcessorType() {
        return this.ruleProcessorType;
    }

    public void setRuleProcessorType(String ruleProcessorType) {
        this.ruleProcessorType = ruleProcessorType;
    }
}

