/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action.config;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.impl.MultiUserCFType;
import com.atlassian.jira.issue.customfields.impl.RenderableTextCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.component.jql.AutoCompleteJsonGenerator;
import com.metainf.jira.plugin.emailissue.action.config.TabSupport;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.desk.CustomerRequestType;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskManager;
import com.metainf.jira.plugin.emailissue.entity.AutoReplyParams;
import com.metainf.jira.plugin.emailissue.entity.AutoReplyParamsDao;
import com.metainf.jira.plugin.emailissue.entity.Template;
import com.metainf.jira.plugin.emailissue.entity.TemplateDao;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.java.ao.Entity;
import org.apache.commons.lang.StringUtils;

public class EditMailHandlerContext
extends TabSupport {
    public static final String WATCHERS = "WATCHERS";
    public static final String FIELD = "FIELD";
    public static final String EMAIL = "EMAIL";
    private Long contextId;
    private Long projectId;
    private Long issueTypeId;
    private Long templateId;
    private Long commentTemplateId;
    private Long senderFieldId;
    private Long senderNameFieldId;
    private Long recipientFieldId;
    private Long copyRecipientFieldId;
    private Long userRecipientFieldId;
    private String splitregex;
    private String excludeEmailsRegex;
    private String userRecipientsHandling;
    private Long linkType;
    private String commentCriteria;
    private String processingStrategy;
    private Long eventOnEmail;
    private boolean filterEmails;
    private boolean executeTransition;
    private boolean initializeIssueFields;
    private boolean overrideIssueLookup;
    private String mailHandlerUser;
    private boolean customersToParticipants;
    private String sdCommentVisibility;
    private Long participantAddedTemplateId;
    private Long customerCreatedTemplateId;
    private String sdRequestType;
    private String fingerPrintStrategy;
    private boolean ignoreIssueInHeader;
    private final AutoReplyParamsDao autoReplyParamsDao;
    private final TemplateDao templateDao;
    private final ProjectManager projectManager;
    private final IssueTypeManager issueTypeManager;
    private final CustomFieldManager customFieldManager;
    private final IssueLinkTypeManager linkTypeManager;
    private final SearchService searchService;
    private final EventTypeManager eventTypeManager;
    private final ServiceDeskManager serviceDeskManager;
    private final UserManager userManager;

    public EditMailHandlerContext(Authorizer authorizer, DateTimeFormatterFactory dateTimeFormatterFactory, ConfigurationManager configurationManager, AutoReplyParamsDao autoReplyParamsDao, TemplateDao templateDao, ProjectManager projectManager, IssueTypeManager issueTypeManager, CustomFieldManager customFieldManager, IssueLinkTypeManager linkTypeManager, SearchService searchService, EventTypeManager eventTypeManager, ServiceDeskManager serviceDeskManager, UserManager userManager) {
        super(authorizer, dateTimeFormatterFactory, configurationManager, (AutoCompleteJsonGenerator)ComponentManager.getComponentInstanceOfType(AutoCompleteJsonGenerator.class));
        this.autoReplyParamsDao = autoReplyParamsDao;
        this.templateDao = templateDao;
        this.projectManager = projectManager;
        this.issueTypeManager = issueTypeManager;
        this.customFieldManager = customFieldManager;
        this.linkTypeManager = linkTypeManager;
        this.searchService = searchService;
        this.eventTypeManager = eventTypeManager;
        this.serviceDeskManager = serviceDeskManager;
        this.userManager = userManager;
    }

    public String doEdit() throws Exception {
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        if (this.contextId != null && this.contextId != 0L) {
            AutoReplyParams context = (AutoReplyParams)this.autoReplyParamsDao.getById(this.contextId);
            if (context != null) {
                this.setProjectId(context.getProjectId());
                this.setIssueTypeId(context.getIssueTypeId());
                this.setTemplateId(context.getTemplate() == null ? null : new Long(context.getTemplate().getID()));
                this.setSenderFieldId(context.getSenderFieldId());
                this.setSenderNameFieldId(context.getSenderNameFieldId());
                this.setRecipientFieldId(context.getRecipientFieldId());
                this.setCopyRecipientFieldId(context.getCopyRecipientFieldId());
                this.setUserRecipientsHandling(context);
                this.setUserRecipientFieldId(context.getUserRecipientFieldId());
                this.setCommentTemplateId(context.getCommentTemplate() == null ? null : new Long(context.getCommentTemplate().getID()));
                this.setSplitregex(context.getSplitregex());
                this.setExcludeEmailsRegex(context.getExcludeEmailsRegex());
                this.setCommentCriteria(context.getCommentCriteria());
                this.setLinkType(context.getLinkType());
                this.setEventOnEmail(context.getEventOnEmail());
                this.setFilterEmails(Boolean.TRUE.equals(context.isFilterEmails()));
                this.setExecuteTransition(Boolean.TRUE.equals(context.isExecuteTransition()));
                this.setInitializeIssueFields(Boolean.TRUE.equals(context.getInitializeIssueFields()));
                this.setOverrideIssueLookup(Boolean.TRUE.equals(context.getOverrideIssueLookup()));
                AutoReplyParams.ProcessingType processingType = context.getProcessingStrategy();
                this.setProcessingStrategy(processingType == null ? null : processingType.name());
                this.setCustomersToParticipants(Boolean.TRUE.equals(context.getCustomersToParticipants()));
                this.setSdCommentVisibility(context.getSdCommentVisibility() != null ? context.getSdCommentVisibility().name() : AutoReplyParams.ServiceDeskCommentVisibility.DEFAULT.name());
                this.setCustomerCreatedTemplateId(context.getCustomerCreatedTemplateId());
                this.setParticipantAddedTemplateId(context.getParticipantAddedTemplateId());
                this.setSdRequestType(context.getRequestTypeKey());
                this.setFingerPrintStrategy(context.getFingerPrintStrategy() == null ? null : context.getFingerPrintStrategy().name());
                this.setIgnoreIssueInHeader(Boolean.TRUE.equals(context.getIgnoreIssueInHeader()));
                if (StringUtils.isNotBlank((String)context.getMailHandlerUser())) {
                    ApplicationUser au = ApplicationUsers.byKey((String)context.getMailHandlerUser());
                    this.setMailHandlerUser(au == null ? null : au.getName());
                }
            }
        } else {
            this.userRecipientsHandling = EMAIL;
        }
        return this.success();
    }

    private void setUserRecipientsHandling(AutoReplyParams context) {
        this.userRecipientsHandling = context.isUserRecipientsAsWatchers() ? WATCHERS : (context.getUserRecipientFieldId() != null && this.customFieldManager.getCustomFieldObject(context.getUserRecipientFieldId()) != null ? FIELD : EMAIL);
    }

    public String doSave() throws Exception {
        ApplicationUser au;
        SearchService.ParseResult pr;
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        AutoReplyParams existingContext = this.autoReplyParamsDao.findByProjectAndType(this.projectId, this.issueTypeId);
        if (existingContext != null && (this.contextId == null || this.contextId == 0L)) {
            this.addErrorMessage("Context exists for this combination of Project and Issue Type(s). Please delete the existing context first or set another project and/or issue type.");
        } else if (AutoReplyParams.ProcessingType.valueOf(this.getProcessingStrategy()) == AutoReplyParams.ProcessingType.SERVICEDESK) {
            if (this.getProjectId() == null || this.getProjectId() == 0L) {
                this.addErrorMessage("Service Desk Processing Strategy requires you to select a Service Desk Project.");
            } else if (!this.serviceDeskManager.isServiceDeskProject(this.getProjectId())) {
                this.addErrorMessage("The selected Project is not a Service Desk Project. If you want to use Service Desk Processing Strategy, you must select a Service Desk Project.");
            }
            if (this.getIssueTypeId() == null || this.getIssueTypeId() == 0L) {
                this.addErrorMessage("Service Desk Processing Strategy requires you to select an Issue Type.");
            }
            if (!this.serviceDeskManager.isServiceDeskAddOnEnabled()) {
                this.addErrorMessage("You cannot configure Service Desk Processing Strategy without installing JIRA Service Desk. Please select a different strategy.");
            }
        }
        if (this.getProjectId() != null && this.getProjectId() > 0L && this.getIssueTypeId() != null && this.getIssueTypeId() > 0L && !this.isIssueTypeValidInProject()) {
            this.addErrorMessage("The selected issue type is not available in the selected project.");
        }
        if (this.getHasErrorMessages()) {
            return this.success();
        }
        if (StringUtils.isNotBlank((String)this.getCommentCriteria()) && this.getProcessingType().isCommentCriteriaEnabled() && (pr = this.searchService.parseQuery(this.getLoggedInUser(), this.getCommentCriteria())).getErrors().hasAnyErrors()) {
            this.addErrorMessages(pr.getErrors().getErrorMessages());
            return this.success();
        }
        Template template = this.getTemplateId() == null || this.getTemplateId() == 0L ? null : (Template)this.templateDao.getById(this.getTemplateId());
        Template commentTemplate = this.commentTemplateId != null && this.commentTemplateId != 0L ? (Template)this.templateDao.getById(this.commentTemplateId) : null;
        String mailHandlerUserKey = null;
        if (StringUtils.isNotBlank((String)this.getMailHandlerUser()) && (au = this.userManager.getUserByName(this.getMailHandlerUser())) != null) {
            mailHandlerUserKey = au.getKey();
        }
        AutoReplyParams context = this.contextId != null && this.contextId != 0L ? (AutoReplyParams)this.autoReplyParamsDao.getById(this.contextId) : null;
        context = context == null ? (AutoReplyParams)this.autoReplyParamsDao.newEntity() : context;
        context.setProjectId(this.getProjectId());
        context.setIssueTypeId(this.getIssueTypeId());
        context.setTemplate(template);
        context.setCommentTemplate(commentTemplate);
        context.setSenderFieldId(this.getSenderFieldId());
        context.setSenderNameFieldId(this.getSenderNameFieldId());
        context.setRecipientFieldId(this.getRecipientFieldId());
        context.setCopyRecipientFieldId(this.getCopyRecipientFieldId());
        context.setUserRecipientsAsWatchers(this.getUserRecipientsHandling().equals(WATCHERS));
        context.setUserRecipientFieldId(this.getUserRecipientsHandling().equals(FIELD) ? this.getUserRecipientFieldId() : null);
        context.setSplitregex(this.getSplitregex());
        context.setExcludeEmailsRegex(this.getExcludeEmailsRegex());
        context.setProcessingStrategy(AutoReplyParams.ProcessingType.valueOf(this.getProcessingStrategy()));
        context.setCommentCriteria(this.getCommentCriteria());
        context.setLinkType(this.getLinkType());
        context.setEventOnEmail(this.getEventOnEmail());
        context.setFilterEmails(this.isFilterEmails());
        context.setExecuteTransition(this.isExecuteTransition());
        context.setInitializeIssueFields(this.isInitializeIssueFields());
        context.setOverrideIssueLookup(this.isOverrideIssueLookup());
        context.setMailHandlerUser(mailHandlerUserKey);
        context.setSdCommentVisibility(AutoReplyParams.ServiceDeskCommentVisibility.valueOf(this.getSdCommentVisibility()));
        context.setCustomerCreatedTemplateId(this.getCustomerCreatedTemplateId());
        context.setParticipantAddedTemplateId(this.getParticipantAddedTemplateId());
        context.setRequestTypeKey(this.getSdRequestType());
        context.setFingerPrintStrategy(StringUtils.isBlank((String)this.getFingerPrintStrategy()) ? null : AutoReplyParams.FingerPrintStrategy.valueOf(this.getFingerPrintStrategy()));
        context.setIgnoreIssueInHeader(this.isIgnoreIssueInHeader());
        this.autoReplyParamsDao.update(context);
        return this.getRedirect("/secure/admin/jeti/jetiAutoReply.jspa");
    }

    public String getContentPage() {
        return this.isBeforeJira6() ? "/templates/emailissue/operation/config/edit-mailhandlercontext.vm" : "/templates/emailissue/operation/config/edit-mailhandlercontext6.vm";
    }

    @Override
    public String getActiveTabClass(String tabName) {
        return "autoReplyTab".equals(tabName) ? "active-tab" : "";
    }

    public Long getContextId() {
        return this.contextId;
    }

    public void setContextId(Long contextId) {
        this.contextId = contextId;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getIssueTypeId() {
        return this.issueTypeId;
    }

    public void setIssueTypeId(Long issueTypeId) {
        this.issueTypeId = issueTypeId;
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public Long getSenderFieldId() {
        return this.senderFieldId;
    }

    public void setSenderFieldId(Long senderFieldId) {
        this.senderFieldId = senderFieldId;
    }

    public Long getRecipientFieldId() {
        return this.recipientFieldId;
    }

    public void setRecipientFieldId(Long recipientFieldId) {
        this.recipientFieldId = recipientFieldId;
    }

    public Long getCopyRecipientFieldId() {
        return this.copyRecipientFieldId;
    }

    public void setCopyRecipientFieldId(Long copyRecipientFieldId) {
        this.copyRecipientFieldId = copyRecipientFieldId;
    }

    public boolean isSelectedType(String issueType) {
        return this.issueTypeId != null ? this.issueTypeId.toString().equals(issueType) : issueType == null;
    }

    public List<Project> getProjects() {
        ArrayList<Project> projects = new ArrayList<Project>(this.projectManager.getProjectObjects());
        return projects;
    }

    public List<IssueType> getIssueTypes() {
        ArrayList<IssueType> types = new ArrayList<IssueType>(this.issueTypeManager.getIssueTypes());
        return types;
    }

    public List<Template> getTemplates() {
        ArrayList<Entity> templates = new ArrayList<Entity>(Arrays.asList(this.templateDao.findAll("NAME ASC")));
        Collections.sort(templates, new Template.EntityComparator());
        return templates;
    }

    public List<Template> getCustomersCreatedTemplates() {
        List<Template> cutomersCreateTemplates = Collections.EMPTY_LIST;
        Template[] templates = (Template[])this.templateDao.filterAndOrder("LABELS = ?", "NAME ASC", new Object[]{"Service Desk Customer Invitation"});
        if (templates != null && templates.length > 0) {
            cutomersCreateTemplates = Arrays.asList(templates);
        }
        return cutomersCreateTemplates;
    }

    public List<Template> getParticipantsAddedTemplates() {
        List<Template> participantsAddedTemplates = Collections.EMPTY_LIST;
        Template[] templates = (Template[])this.templateDao.filterAndOrder("LABELS = ?", "NAME ASC", new Object[]{"Service Desk Request Participant Added Notification"});
        if (templates != null && templates.length > 0) {
            participantsAddedTemplates = Arrays.asList(templates);
        }
        return participantsAddedTemplates;
    }

    public List<CustomField> getCustomFields() {
        try {
            ArrayList<CustomField> fields = new ArrayList<CustomField>(this.customFieldManager.getCustomFieldObjects());
            Iterator it = fields.iterator();
            while (it.hasNext()) {
                CustomField customField = (CustomField)it.next();
                CustomFieldType fieldType = customField.getCustomFieldType();
                if (fieldType instanceof RenderableTextCFType) continue;
                it.remove();
            }
            return fields;
        }
        catch (IssuePermissionException e) {
            return Collections.EMPTY_LIST;
        }
    }

    public List<CustomField> getMultiUserPickerFields() {
        try {
            ArrayList<CustomField> fields = new ArrayList<CustomField>(this.customFieldManager.getCustomFieldObjects());
            Iterator it = fields.iterator();
            while (it.hasNext()) {
                CustomField customField = (CustomField)it.next();
                CustomFieldType fieldType = customField.getCustomFieldType();
                if (fieldType instanceof MultiUserCFType) continue;
                it.remove();
            }
            return fields;
        }
        catch (IssuePermissionException e) {
            return Collections.EMPTY_LIST;
        }
    }

    public Long getCommentTemplateId() {
        return this.commentTemplateId;
    }

    public void setCommentTemplateId(Long commentTemplateId) {
        this.commentTemplateId = commentTemplateId;
    }

    public String getSplitregex() {
        return this.splitregex;
    }

    public void setSplitregex(String splitregex) {
        this.splitregex = splitregex;
    }

    public String getProcessingStrategy() {
        return this.processingStrategy;
    }

    public void setProcessingStrategy(String processingStrategy) {
        this.processingStrategy = processingStrategy;
    }

    public List<AutoReplyParams.ProcessingType> getProcessingTypes() {
        return Arrays.asList(AutoReplyParams.ProcessingType.values());
    }

    public String getExcludeEmailsRegex() {
        return this.excludeEmailsRegex;
    }

    public void setExcludeEmailsRegex(String excludeEmailsRegex) {
        this.excludeEmailsRegex = excludeEmailsRegex;
    }

    public Collection<IssueLinkType> getLinkTypes() {
        ArrayList<IssueLinkType> linkTypes = new ArrayList<IssueLinkType>(this.linkTypeManager.getIssueLinkTypes());
        Collections.sort(linkTypes);
        return linkTypes;
    }

    public Long getLinkType() {
        return this.linkType;
    }

    public void setLinkType(Long linkType) {
        this.linkType = linkType;
    }

    public String getCommentCriteria() {
        return this.commentCriteria;
    }

    public void setCommentCriteria(String commentCriteria) {
        this.commentCriteria = commentCriteria;
    }

    public AutoReplyParams.ProcessingType getProcessingType() {
        return AutoReplyParams.ProcessingType.valueOf(this.getProcessingStrategy());
    }

    public Long getUserRecipientFieldId() {
        return this.userRecipientFieldId;
    }

    public void setUserRecipientFieldId(Long userRecipientFieldId) {
        this.userRecipientFieldId = userRecipientFieldId;
    }

    public String getUserRecipientsHandling() {
        return this.userRecipientsHandling;
    }

    public void setUserRecipientsHandling(String userRecipientsHandling) {
        this.userRecipientsHandling = userRecipientsHandling;
    }

    public List<EventType> getEventTypes() {
        ArrayList<EventType> types = new ArrayList<EventType>(this.eventTypeManager.getEventTypes());
        return types;
    }

    public Long getEventOnEmail() {
        return this.eventOnEmail;
    }

    public void setEventOnEmail(Long eventOnEmail) {
        this.eventOnEmail = eventOnEmail;
    }

    public boolean isExecuteTransition() {
        return this.executeTransition;
    }

    public void setExecuteTransition(boolean executeTransition) {
        this.executeTransition = executeTransition;
    }

    public boolean isInitializeIssueFields() {
        return this.initializeIssueFields;
    }

    public void setInitializeIssueFields(boolean initializeIssueFields) {
        this.initializeIssueFields = initializeIssueFields;
    }

    public boolean isOverrideIssueLookup() {
        return this.overrideIssueLookup;
    }

    public void setOverrideIssueLookup(boolean overrideIssueLookup) {
        this.overrideIssueLookup = overrideIssueLookup;
    }

    public boolean isCustomersToParticipants() {
        return this.customersToParticipants;
    }

    public void setCustomersToParticipants(boolean customersToParticipants) {
        this.customersToParticipants = customersToParticipants;
    }

    private boolean isIssueTypeValidInProject() {
        IssueType issueType;
        boolean valid = false;
        Project project = this.getProjectId() != null && this.getProjectId() > 0L ? this.projectManager.getProjectObj(this.getProjectId()) : null;
        IssueType issueType2 = issueType = this.getIssueTypeId() != null && this.getIssueTypeId() > 0L ? this.issueTypeManager.getIssueType(this.getIssueTypeId().toString()) : null;
        if (project != null && issueType != null) {
            valid = project.getIssueTypes().contains(issueType);
        }
        return valid;
    }

    public String getMailHandlerUser() {
        return this.mailHandlerUser;
    }

    public void setMailHandlerUser(String mailHandlerUser) {
        this.mailHandlerUser = mailHandlerUser;
    }

    public boolean isFilterEmails() {
        return this.filterEmails;
    }

    public void setFilterEmails(boolean filterEmails) {
        this.filterEmails = filterEmails;
    }

    public Long getSenderNameFieldId() {
        return this.senderNameFieldId;
    }

    public void setSenderNameFieldId(Long senderNameFieldId) {
        this.senderNameFieldId = senderNameFieldId;
    }

    public String getSdCommentVisibility() {
        return this.sdCommentVisibility;
    }

    public void setSdCommentVisibility(String sdCommentVisibility) {
        this.sdCommentVisibility = sdCommentVisibility;
    }

    public Long getParticipantAddedTemplateId() {
        return this.participantAddedTemplateId;
    }

    public void setParticipantAddedTemplateId(Long participantAddedTemplateId) {
        this.participantAddedTemplateId = participantAddedTemplateId;
    }

    public Long getCustomerCreatedTemplateId() {
        return this.customerCreatedTemplateId;
    }

    public void setCustomerCreatedTemplateId(Long customerCreatedTemplateId) {
        this.customerCreatedTemplateId = customerCreatedTemplateId;
    }

    public String getSdRequestType() {
        return this.sdRequestType;
    }

    public void setSdRequestType(String sdRequestType) {
        this.sdRequestType = sdRequestType;
    }

    public Collection<CustomerRequestType> getCustomerRequestTypes() {
        if (this.getProjectId() != null && this.getIssueTypeId() != null) {
            return this.serviceDeskManager.getCustomerRequestTypes(this.getProjectId(), String.valueOf(this.getIssueTypeId()));
        }
        return Collections.emptyList();
    }

    public String getFingerPrintStrategy() {
        return this.fingerPrintStrategy;
    }

    public void setFingerPrintStrategy(String fingerPrintStrategy) {
        this.fingerPrintStrategy = fingerPrintStrategy;
    }

    public boolean isIgnoreIssueInHeader() {
        return this.ignoreIssueInHeader;
    }

    public void setIgnoreIssueInHeader(boolean ignoreIssueInHeader) {
        this.ignoreIssueInHeader = ignoreIssueInHeader;
    }
}

