/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action.config;

import com.atlassian.gzipfilter.org.apache.commons.lang.math.NumberUtils;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.metainf.jira.plugin.emailissue.action.UserResolver;
import com.metainf.jira.plugin.emailissue.action.config.Config;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.Configuration;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class EditDefaults
extends Config {
    private final ProjectManager projectManager;
    private final IssueTypeManager issueTypeManager;
    private final UserResolver userResolver;
    private String sequenceNumber;
    private Long projectId;
    private String issueTypeId;
    private Long defaultsId;
    private String fromAddresses;

    public EditDefaults(Authorizer authorizer, DateTimeFormatterFactory dateTimeFormatterFactory, ProjectRoleManager projectRoleManager, GroupManager groupManager, CustomFieldManager customFieldManager, EventTypeManager eventTypeManager, GlobalPermissionManager globalPermissionManager, ConfigurationManager configurationManager, ProjectManager projectManager, IssueTypeManager issueTypeManager, UserResolver userResolver) {
        super(authorizer, dateTimeFormatterFactory, projectRoleManager, groupManager, customFieldManager, eventTypeManager, globalPermissionManager, configurationManager, userResolver);
        this.projectManager = projectManager;
        this.issueTypeManager = issueTypeManager;
        this.userResolver = userResolver;
    }

    @Override
    public String getActiveTabClass(String tabName) {
        return "defaultsTab".equals(tabName) ? "active-tab" : "";
    }

    @Override
    public String doDefault() throws Exception {
        if (this.getDefaultsId() != null && this.getDefaultsId() > 0L && this.getDefaultsId() != (long)this.configurationManager.getGlobalConfiguration().getID()) {
            Configuration config = this.configurationManager.getConfiguration(this.getDefaultsId());
            this.showConfiguration(config);
            this.setFromAddresses(config.getFromAddresses());
            this.setProjectId(config.getProjectId());
            this.setIssueTypeId(config.getIssueTypes());
            this.setSequenceNumber(config.getSequenceNumber() != null ? config.getSequenceNumber().toString() : "1");
        }
        return this.success();
    }

    @Override
    public String getContentPage() {
        return "/templates/emailissue/operation/config/defaults-edit.vm";
    }

    public String doSave() {
        try {
            Configuration config = null;
            if (this.getProjectId() == null && this.getIssueTypeId() == null && StringUtils.isBlank((CharSequence)this.getJqltext())) {
                this.addErrorMessage("Project or issue type or JQL filter is mandatory.");
            }
            this.validateEmailAddresses(this.getFromAddresses());
            if (this.getHasErrorMessages()) {
                return this.success();
            }
            if (this.getDefaultsId() != null && this.getDefaultsId() > 0L && this.getDefaultsId() != (long)this.configurationManager.getGlobalConfiguration().getID()) {
                config = this.configurationManager.getConfiguration(this.getDefaultsId());
            }
            if (config == null) {
                config = this.configurationManager.newConfiguration();
            }
            this.saveInConfiguration(config);
            config.setFromAddresses(this.getFromAddresses());
            config.setSequenceNumber(NumberUtils.toInt((String)this.getSequenceNumber(), (int)1));
            config.setProjectId(this.getProjectId());
            config.setIssueTypes(StringUtils.isBlank((CharSequence)this.getIssueTypeId()) ? null : this.getIssueTypeId());
            config.setJQLFilter(StringUtils.isBlank((CharSequence)this.getJqltext()) ? null : this.getJqltext());
            this.configurationManager.updateConfiguration(config);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.getRedirect("/secure/admin/jeti/jetiDefaults.jspa");
    }

    private void validateEmailAddresses(String fromAddresses) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fromAddresses})) {
            for (String token : fromAddresses.split("\r\n")) {
                if (this.userResolver.isEmailAddress(token) || this.userResolver.isExtendedEmailAddress(token)) continue;
                this.addErrorMessage("From Address is not recognized as email address: " + token);
            }
        }
    }

    public Long getDefaultsId() {
        return this.defaultsId;
    }

    public void setDefaultsId(Long defaultsId) {
        this.defaultsId = defaultsId;
    }

    public List<Project> getProjects() {
        ArrayList<Project> projects = new ArrayList<Project>(this.projectManager.getProjectObjects());
        return projects;
    }

    public List<IssueType> getIssueTypes() {
        ArrayList<IssueType> types = new ArrayList<IssueType>(this.issueTypeManager.getIssueTypes());
        return types;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getIssueTypeId() {
        return this.issueTypeId;
    }

    public void setIssueTypeId(String issueTypeId) {
        this.issueTypeId = issueTypeId;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String getFromAddresses() {
        return this.fromAddresses;
    }

    public void setFromAddresses(String fromAddresses) {
        this.fromAddresses = fromAddresses;
    }
}

