/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action.config;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.impl.MultiUserCFType;
import com.atlassian.jira.issue.customfields.impl.RenderableTextCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.web.component.jql.AutoCompleteJsonGenerator;
import com.metainf.jira.plugin.emailissue.action.UserResolver;
import com.metainf.jira.plugin.emailissue.action.config.TabSupport;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.CannedResponseDao;
import com.metainf.jira.plugin.emailissue.entity.Context;
import com.metainf.jira.plugin.emailissue.entity.ContextDao;
import com.metainf.jira.plugin.emailissue.entity.NotificationTemplate;
import com.metainf.jira.plugin.emailissue.entity.NotificationTemplateDao;
import com.metainf.jira.plugin.emailissue.entity.Template;
import com.metainf.jira.plugin.emailissue.entity.TemplateDao;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import com.metainf.jira.plugin.emailissue.util.CustomFieldUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.java.ao.Entity;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;

public class EditContext
extends TabSupport {
    private final ContextDao contextDao;
    private final NotificationTemplateDao notificationTemplateDao;
    private final TemplateDao templateDao;
    private final ProjectManager projectManager;
    private final IssueTypeManager issueTypeManager;
    private final CustomFieldManager customFieldManager;
    private final CannedResponseDao cannedResponseDao;
    private final UserResolver userResolver;
    private Long contextId;
    private Long projectId;
    private Long issueTypeId;
    private int templateId;
    private int notificationId;
    private String senderTemplate;
    private String fromAddress;
    private String bccAddress;
    private Long prefillTemplateId;
    private Long externalWatcherFieldId;
    private Long userRecipientField;
    private boolean emailDetailsInComment;
    private String[] selectedResponseCategories;
    private boolean cannedResponsesEnabled;
    private String[] selectedTemplateCategories;
    private String jqlFilter;
    private String sequenceNumber;

    public EditContext(Authorizer authorizer, DateTimeFormatterFactory dateTimeFormatterFactory, ConfigurationManager configurationManager, ContextDao contextDao, NotificationTemplateDao notificationTemplateDao, TemplateDao templateDao, ProjectManager projectManager, IssueTypeManager issueTypeManager, CustomFieldManager customFieldManager, CannedResponseDao cannedResponseDao, UserResolver userResolver) {
        super(authorizer, dateTimeFormatterFactory, configurationManager, (AutoCompleteJsonGenerator)ComponentAccessor.getComponentOfType(AutoCompleteJsonGenerator.class));
        this.contextDao = contextDao;
        this.notificationTemplateDao = notificationTemplateDao;
        this.templateDao = templateDao;
        this.projectManager = projectManager;
        this.customFieldManager = customFieldManager;
        this.issueTypeManager = issueTypeManager;
        this.cannedResponseDao = cannedResponseDao;
        this.userResolver = userResolver;
    }

    public String doEdit() throws Exception {
        Context context;
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        if (this.contextId != null && this.contextId != 0L && (context = (Context)this.contextDao.getById(this.contextId)) != null) {
            this.setProjectId(context.getProjectId() == null ? null : context.getProjectId());
            this.setIssueTypeId(context.getIssueTypes() == null ? null : Long.valueOf(Long.parseLong(context.getIssueTypes())));
            this.setTemplateId(context.getTemplate() == null ? 0 : context.getTemplate().getID());
            this.setNotificationId(context.getNotification() == null ? 0 : context.getNotification().getID());
            this.setSenderTemplate(context.getSenderTemplate());
            this.setExternalWatcherFieldId(context.getExternalWatcherFieldId());
            this.setUserRecipientField(context.getUserRecipientField());
            this.setEmailDetailsInComment(context.isEmailDetailsInComment());
            this.setFromAddress(context.getFromAddress());
            this.setBccAddress(context.getBccAddress());
            this.setPrefillTemplateId(context.getPrefillTemplate() == null ? null : new Long(context.getPrefillTemplate().getID()));
            this.setSelectedResponseCategories(StringUtils.isNotBlank((CharSequence)context.getResponseCategories()) ? context.getResponseCategories().split(",") : new String[]{});
            this.setSelectedTemplateCategories(StringUtils.isNotBlank((CharSequence)context.getTemplateCategories()) ? context.getTemplateCategories().split(",") : new String[]{});
            this.setCannedResponsesEnabled(context.getDisableCannedResponses() == null || Boolean.FALSE.equals(context.getDisableCannedResponses()));
            this.setJqlFilter(context.getJQLFilter());
            this.setSequenceNumber(context.getSequenceNumber() == null ? "1" : context.getSequenceNumber().toString());
        }
        return this.success();
    }

    public String doSave() throws Exception {
        Context context;
        Template template;
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        if (StringUtils.isNotBlank((CharSequence)this.getBccAddress()) && !this.userResolver.isEmailAddress(this.getBccAddress())) {
            this.addErrorMessage("The content of BCC Address is not recognized as a single email address. Please correct it.");
            return this.success();
        }
        NotificationTemplate notificationTemplate = this.getNotificationId() != 0 ? (NotificationTemplate)this.notificationTemplateDao.getById(new Long(this.getNotificationId())) : null;
        Template template2 = template = this.getTemplateId() != 0 ? (Template)this.templateDao.getById(new Long(this.getTemplateId())) : null;
        if (notificationTemplate == null && template == null) {
            this.addErrorMessage("Please select a Template and/or a Notification Template.");
            return this.success();
        }
        Context context2 = context = this.contextId != null && this.contextId != 0L ? (Context)this.contextDao.getById(this.contextId) : (Context)this.contextDao.newEntity();
        if (context != null) {
            context.setProjectId(this.getProjectId());
            context.setIssueTypes(this.getIssueTypeId() == null ? null : this.getIssueTypeId().toString());
            context.setTemplate(template);
            context.setNotification(notificationTemplate);
            context.setSenderTemplate(this.getSenderTemplate());
            context.setFromAddress(this.getFromAddress());
            context.setExternalWatcherFieldId(this.getExternalWatcherFieldId());
            context.setUserRecipientField(this.getUserRecipientField());
            context.setBccAddress(this.getBccAddress());
            context.setEmailDetailsInComment(this.isEmailDetailsInComment());
            context.setPrefillTemplate(this.getPrefillTemplateId() == null || this.getPrefillTemplateId() == 0L ? null : (Template)this.templateDao.getById(this.getPrefillTemplateId()));
            if (this.getSelectedResponseCategories() != null && this.getSelectedResponseCategories().length > 0) {
                context.setResponseCategories(StringUtils.join((Object[])this.getSelectedResponseCategories(), (String)","));
            } else {
                context.setResponseCategories(null);
            }
            if (this.getSelectedTemplateCategories() != null && this.getSelectedTemplateCategories().length > 0) {
                context.setTemplateCategories(StringUtils.join((Object[])this.getSelectedTemplateCategories(), (String)","));
            } else {
                context.setTemplateCategories(null);
            }
            context.setDisableCannedResponses(!this.isCannedResponsesEnabled());
            context.setJQLFilter(this.getJqlFilter());
            context.setSequenceNumber(NumberUtils.toInt((String)this.getSequenceNumber(), (int)1));
            this.contextDao.update(context);
        }
        return this.getRedirect("/secure/admin/jeti/jetiProjects.jspa");
    }

    public String getContentPage() {
        return this.isBeforeJira6() ? "/templates/emailissue/operation/config/edit-context.vm" : "/templates/emailissue/operation/config/edit-context6.vm";
    }

    @Override
    public String getActiveTabClass(String tabName) {
        return "projectsTab".equals(tabName) ? "active-tab" : "";
    }

    public Long getContextId() {
        return this.contextId;
    }

    public void setContextId(Long contextId) {
        this.contextId = contextId;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getIssueTypeId() {
        return this.issueTypeId;
    }

    public void setIssueTypeId(Long issueTypeId) {
        this.issueTypeId = issueTypeId;
    }

    public int getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(int templateId) {
        this.templateId = templateId;
    }

    public int getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(int notificationId) {
        this.notificationId = notificationId;
    }

    public String getSenderTemplate() {
        return this.senderTemplate;
    }

    public void setSenderTemplate(String senderTemplate) {
        this.senderTemplate = senderTemplate;
    }

    public List<Project> getProjects() {
        ArrayList<Project> projects = new ArrayList<Project>(this.projectManager.getProjectObjects());
        return projects;
    }

    public List<IssueType> getIssueTypes() {
        ArrayList<IssueType> types = new ArrayList<IssueType>(this.issueTypeManager.getIssueTypes());
        return types;
    }

    public List<Template> getTemplates() {
        ArrayList<Entity> templates = new ArrayList<Entity>(Arrays.asList(this.templateDao.findAll("NAME ASC")));
        Collections.sort(templates, new Template.EntityComparator());
        return templates;
    }

    public List<NotificationTemplate> getNotificationTemplates() {
        ArrayList<Entity> templates = new ArrayList<Entity>(Arrays.asList(this.notificationTemplateDao.findAll()));
        Collections.sort(templates, new NotificationTemplate.EntityComparator());
        return templates;
    }

    public boolean isSelectedType(String issueType) {
        return this.issueTypeId != null ? this.issueTypeId.toString().equals(issueType) : issueType == null;
    }

    public Long getExternalWatcherFieldId() {
        return this.externalWatcherFieldId;
    }

    public void setExternalWatcherFieldId(Long externalWatcherFieldId) {
        this.externalWatcherFieldId = externalWatcherFieldId;
    }

    public List<CustomField> getCustomFields() {
        try {
            ArrayList<CustomField> fields = new ArrayList<CustomField>(this.customFieldManager.getCustomFieldObjects());
            CustomFieldUtil.filterByType(fields, RenderableTextCFType.class);
            return fields;
        }
        catch (IssuePermissionException e) {
            return Collections.EMPTY_LIST;
        }
    }

    public List<CustomField> getMultiUserPickerCustomFields() {
        try {
            ArrayList<CustomField> fields = new ArrayList<CustomField>(this.customFieldManager.getCustomFieldObjects());
            CustomFieldUtil.filterByType(fields, MultiUserCFType.class);
            return fields;
        }
        catch (IssuePermissionException e) {
            return Collections.EMPTY_LIST;
        }
    }

    public boolean isEmailDetailsInComment() {
        return this.emailDetailsInComment;
    }

    public void setEmailDetailsInComment(boolean emailDetailsInComment) {
        this.emailDetailsInComment = emailDetailsInComment;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public Long getPrefillTemplateId() {
        return this.prefillTemplateId;
    }

    public void setPrefillTemplateId(Long prefillTemplateId) {
        this.prefillTemplateId = prefillTemplateId;
    }

    public Long getUserRecipientField() {
        return this.userRecipientField;
    }

    public void setUserRecipientField(Long userRecipientField) {
        this.userRecipientField = userRecipientField;
    }

    public List<String> getResponseCategories() {
        LinkedList<String> categories = new LinkedList<String>(this.cannedResponseDao.getAllCategories());
        return categories;
    }

    public List<String> getTemplateCategories() {
        LinkedList<String> categories = new LinkedList<String>(this.templateDao.getAllCategories());
        return categories;
    }

    public boolean isResponseCategorySelected(String category) {
        boolean selected = false;
        if (this.getSelectedResponseCategories() != null && this.getSelectedResponseCategories().length > 0) {
            for (String cat : this.getSelectedResponseCategories()) {
                if (!cat.equalsIgnoreCase(category)) continue;
                selected = true;
                break;
            }
        }
        return selected;
    }

    public boolean isTemplateCategorySelected(String category) {
        boolean selected = false;
        if (this.getSelectedTemplateCategories() != null && this.getSelectedTemplateCategories().length > 0) {
            for (String cat : this.getSelectedTemplateCategories()) {
                if (!cat.equalsIgnoreCase(category)) continue;
                selected = true;
                break;
            }
        }
        return selected;
    }

    public String[] getSelectedResponseCategories() {
        return this.selectedResponseCategories;
    }

    public void setSelectedResponseCategories(String[] selectedResponseCategories) {
        this.selectedResponseCategories = selectedResponseCategories;
    }

    public boolean isCannedResponsesEnabled() {
        return this.cannedResponsesEnabled;
    }

    public void setCannedResponsesEnabled(boolean cannedResponsesEnabled) {
        this.cannedResponsesEnabled = cannedResponsesEnabled;
    }

    public String getBccAddress() {
        return this.bccAddress;
    }

    public void setBccAddress(String bccAddress) {
        this.bccAddress = bccAddress;
    }

    public String getJqlFilter() {
        return this.jqlFilter;
    }

    public void setJqlFilter(String jqlFilter) {
        this.jqlFilter = jqlFilter;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String[] getSelectedTemplateCategories() {
        return this.selectedTemplateCategories;
    }

    public void setSelectedTemplateCategories(String[] selectedTemplateCategories) {
        this.selectedTemplateCategories = selectedTemplateCategories;
    }
}

