/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action.config;

import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.web.component.jql.AutoCompleteJsonGenerator;
import com.metainf.jira.plugin.emailissue.action.Recipient;
import com.metainf.jira.plugin.emailissue.action.config.TabSupport;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.Configuration;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Defaults
extends TabSupport {
    private final ConfigurationManager configurationManager;
    private final ProjectManager projectManager;
    private final IssueTypeManager issueTypeManager;
    private final ProjectRoleManager projectRoleManager;
    private final GroupManager groupManager;
    private final CustomFieldManager customFieldManager;
    private Long configurationId;

    public Defaults(Authorizer authorizer, DateTimeFormatterFactory dateTimeFormatterFactory, ConfigurationManager configurationManager, ConfigurationManager configurationManager1, ProjectManager projectManager, IssueTypeManager issueTypeManager, ProjectRoleManager projectRoleManager, GroupManager groupManager, CustomFieldManager customFieldManager) {
        super(authorizer, dateTimeFormatterFactory, configurationManager);
        this.configurationManager = configurationManager1;
        this.projectManager = projectManager;
        this.issueTypeManager = issueTypeManager;
        this.projectRoleManager = projectRoleManager;
        this.groupManager = groupManager;
        this.customFieldManager = customFieldManager;
    }

    public Defaults(Authorizer authorizer, DateTimeFormatterFactory dateTimeFormatterFactory, ConfigurationManager configurationManager, AutoCompleteJsonGenerator autoCompleteJsonGenerator, ConfigurationManager configurationManager1, ProjectManager projectManager, IssueTypeManager issueTypeManager, ProjectRoleManager projectRoleManager, GroupManager groupManager, CustomFieldManager customFieldManager) {
        super(authorizer, dateTimeFormatterFactory, configurationManager, autoCompleteJsonGenerator);
        this.configurationManager = configurationManager1;
        this.projectManager = projectManager;
        this.issueTypeManager = issueTypeManager;
        this.projectRoleManager = projectRoleManager;
        this.groupManager = groupManager;
        this.customFieldManager = customFieldManager;
    }

    public String doDelete() {
        if (this.getConfigurationId() != null && this.getConfigurationId() > 0L) {
            Configuration configuration = this.configurationManager.getConfiguration(this.getConfigurationId());
            this.configurationManager.deleteConfiguration(configuration);
        }
        return this.getRedirect("/secure/admin/jeti/jetiDefaults.jspa");
    }

    public String doSave() {
        if (this.getConfigurationId() != null && this.getConfigurationId() > 0L) {
            Configuration configuration = this.configurationManager.getConfiguration(this.getConfigurationId());
            this.configurationManager.updateConfiguration(configuration);
        }
        return this.getRedirect("/secure/admin/jeti/jetiDefaults.jspa");
    }

    @Override
    public String getActiveTabClass(String tabName) {
        return "defaultsTab".equals(tabName) ? "active-tab" : "";
    }

    public Long getConfigurationId() {
        return this.configurationId;
    }

    public void setConfigurationId(Long configurationId) {
        this.configurationId = configurationId;
    }

    public List<DefaultsModel> getConfigurations() {
        List<Configuration> configs = this.configurationManager.getAllNonGlobalConfigurations();
        ArrayList<DefaultsModel> models = new ArrayList<DefaultsModel>(configs.size());
        for (Configuration c : configs) {
            models.add(this.toModel(c));
        }
        return models;
    }

    public String getContentPage() {
        return "/templates/emailissue/operation/config/defaults.vm";
    }

    public String getProjectName(Long projectId) {
        if (projectId == null) {
            return "";
        }
        Project p = projectId == null ? null : this.projectManager.getProjectObj(projectId);
        return p == null ? "<span style='color:red; font-style:italic;'>Project has been deleted</span>" : p.getName();
    }

    public String getIssueTypeName(String issueTypeId) {
        if (issueTypeId == null) {
            return "";
        }
        IssueType t = this.issueTypeManager.getIssueType(issueTypeId);
        return t == null ? "<span style='color:red; font-style:italic;'>Issue type has been deleted</span>" : t.getNameTranslation();
    }

    private DefaultsModel toModel(Configuration config) {
        DefaultsModel model = new DefaultsModel();
        model.setId(config.getID());
        model.setProjectName(config.getProjectId() != null && config.getProjectId() > 0L ? this.getProjectName(config.getProjectId()) : null);
        model.setIssueTypeName(StringUtils.isNotBlank((CharSequence)config.getIssueTypes()) ? this.getIssueTypeName(config.getIssueTypes()) : null);
        model.setJql(config.getJQLFilter());
        model.setTo(config.getEmailIssueTo());
        model.setCc(config.getEmailIssueCc());
        model.setBcc(config.getEmailIssueBcc());
        Map<String, Recipient> recipientIndex = Recipient.buildRecipients(config.getRecipients() == null ? new String[]{} : config.getRecipients().split(","), this.customFieldManager, this.groupManager, this.projectRoleManager, this.getI18n());
        model.setRecipients(this.getRecipientNames(recipientIndex));
        recipientIndex = Recipient.buildRecipients(config.getCopyrecipients() == null ? new String[]{} : config.getCopyrecipients().split(","), this.customFieldManager, this.groupManager, this.projectRoleManager, this.getI18n());
        model.setCcRecipients(this.getRecipientNames(recipientIndex));
        recipientIndex = Recipient.buildRecipients(config.getBlindcopyrecipients() == null ? new String[]{} : config.getBlindcopyrecipients().split(","), this.customFieldManager, this.groupManager, this.projectRoleManager, this.getI18n());
        model.setBccRecipients(this.getRecipientNames(recipientIndex));
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{config.getFromAddresses()})) {
            model.getFromAddresses().addAll(Arrays.asList(config.getFromAddresses().split("\r\n")));
        }
        model.setEmailFormat(config.getEmailFormat());
        model.setAddRecipientToWatchers(config.getAddToWatchers() == 1);
        model.setSendAsUser(config.getMailAsMe() == 1);
        model.setReplyToUser(config.getReplyToMe() == 1);
        model.setAddCommentsToEmail(config.getAddComments() == 1);
        model.setSuppressCommentEvent(config.getSuppressCommentEvent() == 1);
        if (StringUtils.isNotBlank((CharSequence)config.getCommentVisibility())) {
            if (config.getCommentVisibility().startsWith("g:")) {
                model.setCommentVisibility(config.getCommentVisibility().substring(2));
            } else if (config.getCommentVisibility().startsWith("r:")) {
                long roleId = Long.parseLong(config.getCommentVisibility().substring(2));
                ProjectRole role = this.projectRoleManager.getProjectRole(Long.valueOf(roleId));
                model.setCommentVisibility(role == null ? null : role.getName());
            }
        }
        return model;
    }

    private List<String> getRecipientNames(Map<String, Recipient> recipientIndex) {
        LinkedList<String> names = new LinkedList<String>();
        for (Recipient r : recipientIndex.values()) {
            names.add(r.getDisplayName());
        }
        return names;
    }

    public static class DefaultsModel {
        private long id;
        private String projectName;
        private String issueTypeName;
        private String jql;
        private String to;
        private List<String> recipients;
        private String cc;
        private List<String> ccRecipients;
        private String bcc;
        private List<String> bccRecipients;
        private List<String> fromAddresses = new LinkedList<String>();
        private String emailFormat;
        private boolean addRecipientToWatchers;
        private boolean sendAsUser;
        private boolean replyToUser;
        private boolean addCommentsToEmail;
        private String commentVisibility;
        private boolean suppressCommentEvent;

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public String getIssueTypeName() {
            return this.issueTypeName;
        }

        public void setIssueTypeName(String issueTypeName) {
            this.issueTypeName = issueTypeName;
        }

        public String getJql() {
            return this.jql;
        }

        public void setJql(String jql) {
            this.jql = jql;
        }

        public String getTo() {
            return this.to;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public List<String> getRecipients() {
            return this.recipients;
        }

        public void setRecipients(List<String> recipients) {
            this.recipients = recipients;
        }

        public String getCc() {
            return this.cc;
        }

        public void setCc(String cc) {
            this.cc = cc;
        }

        public List<String> getCcRecipients() {
            return this.ccRecipients;
        }

        public void setCcRecipients(List<String> ccRecipients) {
            this.ccRecipients = ccRecipients;
        }

        public String getBcc() {
            return this.bcc;
        }

        public void setBcc(String bcc) {
            this.bcc = bcc;
        }

        public List<String> getBccRecipients() {
            return this.bccRecipients;
        }

        public void setBccRecipients(List<String> bccRecipients) {
            this.bccRecipients = bccRecipients;
        }

        public String getEmailFormat() {
            return this.emailFormat;
        }

        public void setEmailFormat(String emailFormat) {
            this.emailFormat = emailFormat;
        }

        public boolean isAddRecipientToWatchers() {
            return this.addRecipientToWatchers;
        }

        public void setAddRecipientToWatchers(boolean addRecipientToWatchers) {
            this.addRecipientToWatchers = addRecipientToWatchers;
        }

        public boolean isSendAsUser() {
            return this.sendAsUser;
        }

        public void setSendAsUser(boolean sendAsUser) {
            this.sendAsUser = sendAsUser;
        }

        public boolean isReplyToUser() {
            return this.replyToUser;
        }

        public void setReplyToUser(boolean replyToUser) {
            this.replyToUser = replyToUser;
        }

        public boolean isAddCommentsToEmail() {
            return this.addCommentsToEmail;
        }

        public void setAddCommentsToEmail(boolean addCommentsToEmail) {
            this.addCommentsToEmail = addCommentsToEmail;
        }

        public String getCommentVisibility() {
            return this.commentVisibility;
        }

        public void setCommentVisibility(String commentVisibility) {
            this.commentVisibility = commentVisibility;
        }

        public boolean isSuppressCommentEvent() {
            return this.suppressCommentEvent;
        }

        public void setSuppressCommentEvent(boolean suppressCommentEvent) {
            this.suppressCommentEvent = suppressCommentEvent;
        }

        public List<String> getFromAddresses() {
            return this.fromAddresses;
        }

        public void setFromAddresses(List<String> fromAddresses) {
            this.fromAddresses = fromAddresses;
        }
    }
}

