/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action.config;

import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.project.ProjectManager;
import com.metainf.jira.plugin.emailissue.action.config.EmailField;
import com.metainf.jira.plugin.emailissue.action.config.FieldContexts;
import com.metainf.jira.plugin.emailissue.action.config.IssueField;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.FieldContext;
import com.metainf.jira.plugin.emailissue.entity.FieldContextDao;
import com.metainf.jira.plugin.emailissue.entity.FieldDao;
import com.metainf.jira.plugin.emailissue.entity.FieldRule;
import com.metainf.jira.plugin.emailissue.field.FieldContextProcessor;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import com.metainf.jira.plugin.emailissue.util.CustomFieldUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class ConfigureFieldContext
extends FieldContexts {
    private Long fieldId;
    private String field;
    private String regex;
    private String order;
    private String value;
    private String emailField;
    private String valueType;
    private int captureGroup;
    private String expressionTest;
    private String goal;
    private boolean showForm;
    private boolean showTestForm;
    private String emailHeaderName;
    private String forwardEmailAddress;
    private String emailFilterType;
    private static final Pattern NUMBER = Pattern.compile("[1-9][0-9]{0,5}");
    private Map<FieldRule, String> testResult;
    private final FieldContextProcessor fieldContextProcessor;
    private final FieldDao fieldDao;

    public ConfigureFieldContext(FieldContextProcessor fieldContextProcessor, FieldDao fieldDao, Authorizer authorizer, DateTimeFormatterFactory dateTimeFormatterFactory, ConfigurationManager configurationManager, FieldContextDao fieldContextDao, ProjectManager projectManager, CustomFieldManager customFieldManager, IssueTypeManager issueTypeManager) {
        super(authorizer, dateTimeFormatterFactory, configurationManager, fieldContextDao, projectManager, customFieldManager, issueTypeManager);
        this.fieldDao = fieldDao;
        this.fieldContextProcessor = fieldContextProcessor;
    }

    @Override
    public String getContentPage() {
        return "/templates/emailissue/operation/config/configure-field-context.vm";
    }

    public String doConfigure() {
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        return this.success();
    }

    public String doTest() {
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        this.setShowTestForm(true);
        Map<FieldRule, String> testResult = this.fieldContextProcessor.test(this.getFieldContext(), this.getExpressionTest());
        this.setTestResult(testResult);
        return this.success();
    }

    public String doShowTest() {
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        this.setShowTestForm(true);
        return this.success();
    }

    protected void doValidation() {
        try {
            super.doValidation();
            if (StringUtils.isNotBlank((String)this.getOrder()) && !NUMBER.matcher(this.getOrder()).matches()) {
                this.addErrorMessage("Order must be an integer");
            }
            if (StringUtils.isNotBlank((String)this.getField()) && StringUtils.isBlank((String)this.getRegex())) {
                this.addErrorMessage("Regular Expression is required");
            }
            if (FieldRule.FieldRuleType.FILTER.name().equals(this.getGoal()) && "forward".equalsIgnoreCase(this.getEmailFilterType()) && StringUtils.isBlank((String)this.getForwardEmailAddress())) {
                this.addErrorMessage("Forward Email Address is required");
            }
            if (FieldRule.FieldRuleType.FILTER.name().equals(this.getGoal()) && "forward".equalsIgnoreCase(this.getEmailFilterType()) && StringUtils.isNotBlank((String)this.getForwardEmailAddress()) && !this.getForwardEmailAddress().matches("[A-Za-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[A-Za-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[A-Za-z0-9](?:[A-Za-z0-9-]*[A-Za-z0-9])?\\.)+[A-Za-z0-9](?:[A-Za-z0-9-]*[A-Za-z0-9])?")) {
                this.addErrorMessage("Forward Email Address is not a valid email address");
            }
        }
        catch (Exception e) {
            this.addErrorMessage(e.getMessage());
        }
    }

    @Override
    public String doDelete() {
        FieldRule field;
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        if (this.getFieldId() != null && (field = (FieldRule)this.fieldDao.getById(this.getFieldId())) != null) {
            this.fieldDao.delete(field);
        }
        return this.getRedirect("/secure/admin/jeti/jetiConfigureFields.jspa?fieldContextId=" + this.getFieldContextId());
    }

    @Override
    public String doEdit() {
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        if (this.getFieldId() != null) {
            FieldRule fieldRule = (FieldRule)this.fieldDao.getById(this.getFieldId());
            if (fieldRule != null) {
                this.setField(fieldRule.getFieldId());
                this.setRegex(fieldRule.getRegexp());
                this.setCaptureGroup(fieldRule.getGroup());
                this.setOrder(String.valueOf(fieldRule.getOrder()));
                this.setValue(fieldRule.getValue());
                this.setEmailField(fieldRule.getEmailField() != null ? fieldRule.getEmailField().name() : EmailField.BODY.name());
                this.setValueType(fieldRule.isValueFromCaptureGroup() ? "captureGroup" : "manual");
                this.setEmailFilterType(fieldRule.getFieldRuleType() == FieldRule.FieldRuleType.FILTER ? fieldRule.getValue() : null);
                this.setForwardEmailAddress(fieldRule.getFieldRuleType() == FieldRule.FieldRuleType.FILTER ? fieldRule.getValueExt() : null);
                this.setGoal(fieldRule.getFieldRuleType() != null ? fieldRule.getFieldRuleType().name() : (Boolean.TRUE.equals(fieldRule.isIssueLookupRule()) ? FieldRule.FieldRuleType.LOOKUP.name() : FieldRule.FieldRuleType.SET.name()));
                this.setEmailHeaderName(fieldRule.getEmailHeaderName());
            }
        } else {
            this.setField(null);
            this.setRegex(null);
            this.setCaptureGroup(0);
            this.setOrder(null);
            this.setValue(null);
            this.setEmailField(EmailField.BODY.name());
            this.setGoal(FieldRule.FieldRuleType.SET.name());
            this.setForwardEmailAddress(null);
            this.setEmailFilterType(null);
        }
        this.showForm = true;
        return this.success();
    }

    @Override
    public String doSave() {
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        this.doValidation();
        if (this.getHasErrorMessages()) {
            return this.success();
        }
        FieldContext fieldContext = this.getFieldContext();
        FieldRule field = this.getFieldId() == null ? (FieldRule)this.fieldDao.newEntity() : (FieldRule)this.fieldDao.getById(this.getFieldId());
        field.setFieldId(this.getField());
        field.setRegexp(this.getRegex());
        field.setGroup(this.getCaptureGroup());
        field.setOrder(StringUtils.isBlank((String)this.getOrder()) ? 1 : Integer.parseInt(this.getOrder()));
        field.setValue(this.getValue());
        field.setFieldContext(fieldContext);
        field.setEmailField(EmailField.valueOf(this.getEmailField(), null));
        field.setValueFromCaptureGroup("captureGroup".equals(this.getValueType()));
        field.setIssueLookupRule(FieldRule.FieldRuleType.LOOKUP.name().equals(this.getGoal()));
        field.setFieldRuleType(FieldRule.FieldRuleType.valueOf(this.getGoal()));
        if (FieldRule.FieldRuleType.FILTER.name().equals(this.getGoal())) {
            field.setValue(this.getEmailFilterType());
            field.setValueExt(this.getForwardEmailAddress());
        }
        field.setEmailHeaderName(this.getEmailHeaderName());
        this.fieldDao.update(field);
        return this.getRedirect("/secure/admin/jeti/jetiConfigureFields.jspa?fieldContextId=" + this.getFieldContextId());
    }

    public Long getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(Long fieldId) {
        this.fieldId = fieldId;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public int getCaptureGroup() {
        return this.captureGroup;
    }

    public void setCaptureGroup(int captureGroup) {
        this.captureGroup = captureGroup;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public List<IssueField> getIssueFields() {
        ArrayList<IssueField> issueFields = new ArrayList<IssueField>(Arrays.asList(IssueField.values()));
        return issueFields;
    }

    public List<CustomField> getCustomFields() {
        ArrayList<CustomField> fields = new ArrayList<CustomField>(CustomFieldUtil.filterForSettableFields(this.customFieldManager.getCustomFieldObjects()));
        return fields;
    }

    public List<FieldRule> getFieldRules() {
        return this.getFieldRules(this.getFieldContext());
    }

    public FieldRule getFieldRule() {
        return this.getFieldId() == null ? null : (FieldRule)this.fieldDao.getById(this.getFieldId());
    }

    public boolean isShowForm() {
        return this.showForm;
    }

    public void setShowForm(boolean showForm) {
        this.showForm = showForm;
    }

    public List<EmailField> getEmailFields() {
        return new ArrayList<EmailField>(Arrays.asList(EmailField.values()));
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getEmailField() {
        return this.emailField;
    }

    public void setEmailField(String emailField) {
        this.emailField = emailField;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public boolean isShowTestForm() {
        return this.showTestForm;
    }

    public void setShowTestForm(boolean showTestForm) {
        this.showTestForm = showTestForm;
    }

    public String getExpressionTest() {
        return this.expressionTest;
    }

    public void setExpressionTest(String expressionTest) {
        this.expressionTest = expressionTest;
    }

    public Map<FieldRule, String> getTestResult() {
        return this.testResult;
    }

    public void setTestResult(Map<FieldRule, String> testResult) {
        this.testResult = testResult;
    }

    public String getGoal() {
        return this.goal;
    }

    public void setGoal(String goal) {
        this.goal = goal;
    }

    public String getForwardEmailAddress() {
        return this.forwardEmailAddress;
    }

    public void setForwardEmailAddress(String forwardEmailAddress) {
        this.forwardEmailAddress = forwardEmailAddress;
    }

    public String getEmailFilterType() {
        return this.emailFilterType;
    }

    public void setEmailFilterType(String emailFilterType) {
        this.emailFilterType = emailFilterType;
    }

    public String getEmailHeaderName() {
        return this.emailHeaderName;
    }

    public void setEmailHeaderName(String emailHeaderName) {
        this.emailHeaderName = emailHeaderName;
    }
}

