/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action.config;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.component.jql.AutoCompleteJsonGenerator;
import com.metainf.jira.plugin.emailissue.action.EditorType;
import com.metainf.jira.plugin.emailissue.action.EmailOptions;
import com.metainf.jira.plugin.emailissue.action.Recipient;
import com.metainf.jira.plugin.emailissue.action.UserResolver;
import com.metainf.jira.plugin.emailissue.action.config.TabSupport;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.Configuration;
import com.metainf.jira.plugin.emailissue.util.ArrayUtils;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import com.metainf.jira.plugin.emailissue.util.Enums;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Config
extends TabSupport {
    protected ConfigurationManager configurationManager;
    private boolean addToWatchers;
    private boolean replyToMe;
    private boolean mailAsMe;
    private boolean addComments;
    private boolean suppressCommentEvent;
    private String emailFormat;
    private String commentVisibility;
    private boolean bypassComment;
    private String emailIssueTo;
    private String emailIssueCc;
    private String emailIssueBcc;
    private String[] recipients;
    private Map<String, Recipient> recipientIndex = new HashMap<String, Recipient>();
    private boolean saveSettings;
    private String[] copyrecipients;
    private Map<String, Recipient> copyrecipientIndex = new HashMap<String, Recipient>();
    private String[] blindcopyrecipients;
    private Map<String, Recipient> blindcopyrecipientIndex = new HashMap<String, Recipient>();
    private Long[] permissionRoles;
    private String[] permissionGroups;
    private Long[] restrictionRoles;
    private String[] restrictionGroups;
    private String[] restrictionFields;
    private String[] hiddenFields;
    private String userGroupBlacklist;
    private String recipientWhitelist;
    private String recipientBlacklist;
    private String senderBlacklist;
    private boolean externalRecipients;
    private boolean projectRecipients;
    private boolean bccEnabled;
    private boolean bulkOperationDisabled;
    private boolean userOptionsDisabled;
    private boolean popupGroupPicker;
    private boolean inactiveRecipients;
    private boolean enableJeditor;
    private String editorType;
    private String emailLogDisplay;
    private Long eventType;
    private boolean multipartMixed;
    private boolean fixOutlookBlankLine;
    private String attachmentPolicy;
    private boolean sanitizeEmailFields;
    private String jqltext;
    private ProjectRoleManager projectRoleManager;
    private GroupManager groupManager;
    private CustomFieldManager customFieldManager;
    private GlobalPermissionManager globalPermissionManager;
    private EventTypeManager eventTypeManager;
    private final UserResolver userResolver;

    public Config(Authorizer authorizer, DateTimeFormatterFactory dateTimeFormatterFactory, ProjectRoleManager projectRoleManager, GroupManager groupManager, CustomFieldManager customFieldManager, EventTypeManager eventTypeManager, GlobalPermissionManager globalPermissionManager, ConfigurationManager configurationManager, UserResolver userResolver) {
        super(authorizer, dateTimeFormatterFactory, configurationManager, (AutoCompleteJsonGenerator)ComponentAccessor.getComponentOfType(AutoCompleteJsonGenerator.class));
        this.configurationManager = configurationManager;
        this.userResolver = userResolver;
        this.eventTypeManager = eventTypeManager;
        this.globalPermissionManager = globalPermissionManager;
        this.projectRoleManager = projectRoleManager;
        this.groupManager = groupManager;
        this.customFieldManager = customFieldManager;
    }

    @Override
    public String getActiveTabClass(String tabName) {
        return "configurationTab".equals(tabName) ? "active-tab" : "";
    }

    public String getContentPage() {
        return "/templates/emailissue/operation/config/configuration6.vm";
    }

    public String doDefault() throws Exception {
        Configuration config = this.configurationManager.getGlobalConfiguration();
        this.showConfiguration(config);
        return this.success();
    }

    protected void showConfiguration(Configuration config) {
        this.addComments = config.getAddComments() == 1;
        this.addToWatchers = config.getAddToWatchers() == 1;
        this.bypassComment = config.getBypassComment() == 1;
        this.commentVisibility = config.getCommentVisibility();
        this.emailFormat = config.getEmailFormat();
        this.mailAsMe = config.getMailAsMe() == 1;
        this.replyToMe = config.getReplyToMe() == 1;
        this.suppressCommentEvent = config.getSuppressCommentEvent() == 1;
        this.emailIssueTo = config.getEmailIssueTo();
        this.emailIssueCc = config.getEmailIssueCc();
        this.emailIssueBcc = config.getEmailIssueBcc();
        this.recipients = config.getRecipients() == null ? new String[]{} : config.getRecipients().split(",");
        this.copyrecipients = config.getCopyrecipients() == null ? new String[]{} : config.getCopyrecipients().split(",");
        this.blindcopyrecipients = config.getBlindcopyrecipients() == null ? new String[]{} : config.getBlindcopyrecipients().split(",");
        this.recipientIndex = Recipient.buildRecipients(this.recipients, this.customFieldManager, this.groupManager, this.projectRoleManager, this.getI18n());
        this.copyrecipientIndex = Recipient.buildRecipients(this.copyrecipients, this.customFieldManager, this.groupManager, this.projectRoleManager, this.getI18n());
        this.blindcopyrecipientIndex = Recipient.buildRecipients(this.blindcopyrecipients, this.customFieldManager, this.groupManager, this.projectRoleManager, this.getI18n());
        this.recipientWhitelist = config.getRecipientWhitelist();
        this.recipientBlacklist = config.getRecipientBlacklist();
        this.senderBlacklist = config.getSenderBlacklist();
        this.permissionRoles = ArrayUtils.getLongArray(config.getPermissionRoles());
        this.permissionGroups = config.getPermissionGroups() == null ? new String[]{} : config.getPermissionGroups().split(",");
        this.restrictionRoles = ArrayUtils.getLongArray(config.getExcludeRoles());
        this.restrictionGroups = config.getExcludeGroups() == null ? new String[]{} : config.getExcludeGroups().split(",");
        this.restrictionFields = config.getExcludeFields() == null ? new String[]{} : config.getExcludeFields().split(",");
        this.hiddenFields = config.getHiddenFields() == null ? new String[]{} : config.getHiddenFields().split(",");
        this.userGroupBlacklist = config.getUserGroupBlacklist();
        this.externalRecipients = config.getExternalRecipients() == 1;
        this.projectRecipients = config.getProjectUserRecipients() == 1;
        this.eventType = config.getEventId();
        this.bulkOperationDisabled = config.getDisableBulk() == 1;
        this.userOptionsDisabled = config.isUserOptionsDisabled();
        this.bccEnabled = config.isBccEnabled();
        this.popupGroupPicker = config.isPopupGroupPicker();
        this.enableJeditor = config.isJeditorEnabled();
        this.editorType = (config.getEditorType() != null ? config.getEditorType() : (config.isJeditorEnabled() ? EditorType.JEDITOR : EditorType.WIKI)).name();
        this.emailLogDisplay = config.getEmailLogDisplay() != null ? config.getEmailLogDisplay().name() : (config.isEmailLogDisabled() ? Configuration.EmailLogDisplayOption.HIDE.name() : Configuration.EmailLogDisplayOption.FOR_PERMITTED_USERS.name());
        this.multipartMixed = Boolean.TRUE.equals(config.isMultipartMixed());
        this.fixOutlookBlankLine = Boolean.TRUE.equals(config.isFixOutlookBlankLine());
        this.attachmentPolicy = (config.getAttachmentPolicy() != null ? config.getAttachmentPolicy() : (Boolean.TRUE.equals(config.isDisableAttachments()) ? Configuration.AttachmentPolicy.IMPLICIT_ONLY : Configuration.AttachmentPolicy.MANUAL_IMPLICIT)).name();
        this.inactiveRecipients = Boolean.TRUE.equals(config.isInactiveRecipients());
        this.jqltext = config.getJQLFilter();
        this.sanitizeEmailFields = Boolean.TRUE.equals(config.getSanitizeEmails());
    }

    public String doSaveConfiguration() {
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        try {
            Configuration config = this.configurationManager.getGlobalConfiguration();
            this.saveInConfiguration(config);
            this.configurationManager.updateGlobalConfiguration(config);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.getRedirect("/secure/admin/jeti/jetiConfiguration!default.jspa");
    }

    protected void saveInConfiguration(Configuration config) {
        config.setAddComments(this.isAddComments() ? 1 : 0);
        config.setAddToWatchers(this.isAddToWatchers() ? 1 : 0);
        config.setBypassComment(this.isBypassComment() ? 1 : 0);
        config.setCommentVisibility(this.getCommentVisibility());
        config.setEmailFormat(this.getEmailFormat());
        config.setMailAsMe(this.isMailAsMe() ? 1 : 0);
        config.setReplyToMe(this.isReplyToMe() ? 1 : 0);
        config.setSuppressCommentEvent(this.isSuppressCommentEvent() ? 1 : 0);
        config.setEmailIssueCc(this.getEmailIssueCc());
        config.setEmailIssueTo(this.getEmailIssueTo());
        config.setEmailIssueBcc(this.getEmailIssueBcc());
        config.setRecipients(ArrayUtils.join(this.getRecipients()));
        config.setCopyrecipients(ArrayUtils.join(this.getCopyrecipients()));
        config.setBlindcopyrecipients(ArrayUtils.join(this.getBlindcopyrecipients()));
        config.setRecipientWhitelist(this.getRecipientWhitelist());
        config.setRecipientBlacklist(this.getRecipientBlacklist());
        config.setSenderBlacklist(this.getSenderBlacklist());
        config.setPermissionRoles(ArrayUtils.join(this.getPermissionRoles()));
        config.setPermissionGroups(ArrayUtils.join(this.getPermissionGroups()));
        config.setExcludeRoles(ArrayUtils.join(this.getRestrictionRoles()));
        config.setExcludeGroups(ArrayUtils.join(this.getRestrictionGroups()));
        config.setExcludeFields(ArrayUtils.join(this.getRestrictionFields()));
        config.setHiddenFields(ArrayUtils.join(this.getHiddenFields()));
        config.setUserGroupBlacklist(this.getUserGroupBlacklist());
        config.setExternalRecipients(this.isExternalRecipients() ? 1 : 0);
        config.setProjectUserRecipients(this.isProjectRecipients() ? 1 : 0);
        config.setEventId(this.getEventType());
        config.setDisableBulk(this.isBulkOperationDisabled() ? 1 : 0);
        config.setUserOptionsDisabled(this.isUserOptionsDisabled());
        config.setBccEnabled(this.isBccEnabled());
        config.setPopupGroupPicker(this.isPopupGroupPicker());
        config.setJeditorEnabled(this.isEnableJeditor());
        config.setEditorType(Enums.valueOf(this.getEditorType(), EditorType.WIKI));
        if (this.getEmailLogDisplay() != null && Configuration.EmailLogDisplayOption.valueOf(this.getEmailLogDisplay()) != null) {
            config.setEmailLogDisplay(Configuration.EmailLogDisplayOption.valueOf(this.getEmailLogDisplay()));
        }
        config.setMultipartMixed(this.isMultipartMixed());
        config.setFixOutlookBlankLine(this.isFixOutlookBlankLine());
        Configuration.AttachmentPolicy policy = Enums.valueOf(this.getAttachmentPolicy(), Configuration.AttachmentPolicy.MANUAL_IMPLICIT);
        config.setAttachmentPolicy(policy);
        config.setInactiveRecipients(this.isInactiveRecipients());
        config.setJQLFilter(this.getJqltext());
        config.setSanitizeEmails(this.isSanitizeEmailFields());
    }

    public boolean isAddToWatchers() {
        return this.addToWatchers;
    }

    public void setAddToWatchers(boolean addToWatchers) {
        this.addToWatchers = addToWatchers;
    }

    public boolean isReplyToMe() {
        return this.replyToMe;
    }

    public void setReplyToMe(boolean replyToMe) {
        this.replyToMe = replyToMe;
    }

    public boolean isMailAsMe() {
        return this.mailAsMe;
    }

    public void setMailAsMe(boolean mailAsMe) {
        this.mailAsMe = mailAsMe;
    }

    public boolean isAddComments() {
        return this.addComments;
    }

    public void setAddComments(boolean addComments) {
        this.addComments = addComments;
    }

    public boolean isBypassComment() {
        return this.bypassComment;
    }

    public void setBypassComment(boolean bypassComment) {
        this.bypassComment = bypassComment;
    }

    public boolean isSuppressCommentEvent() {
        return this.suppressCommentEvent;
    }

    public void setSuppressCommentEvent(boolean suppressCommentEvent) {
        this.suppressCommentEvent = suppressCommentEvent;
    }

    public String getEmailFormat() {
        return this.emailFormat;
    }

    public void setEmailFormat(String emailFormat) {
        this.emailFormat = emailFormat;
    }

    public String getCommentVisibility() {
        return this.commentVisibility;
    }

    public void setCommentVisibility(String commentVisibility) {
        this.commentVisibility = commentVisibility;
    }

    public String getEmailIssueTo() {
        return this.emailIssueTo;
    }

    public void setEmailIssueTo(String emailIssueTo) {
        this.emailIssueTo = emailIssueTo;
    }

    public String getEmailIssueCc() {
        return this.emailIssueCc;
    }

    public void setEmailIssueCc(String emailIssueCc) {
        this.emailIssueCc = emailIssueCc;
    }

    public String getEmailIssueBcc() {
        return this.emailIssueBcc;
    }

    public void setEmailIssueBcc(String emailIssueBcc) {
        this.emailIssueBcc = emailIssueBcc;
    }

    public String[] getRecipients() {
        return this.recipients;
    }

    public void setRecipients(String[] recipients) {
        this.recipients = recipients;
    }

    public Map<String, Recipient> getRecipientIndex() {
        return this.recipientIndex;
    }

    public void setRecipientIndex(Map<String, Recipient> recipientIndex) {
        this.recipientIndex = recipientIndex;
    }

    public String getOptions() {
        return null;
    }

    public void setOptions(String options) {
    }

    public EmailOptions getEmailOptions() {
        return null;
    }

    public void setEmailOptions(EmailOptions emailOptions) {
    }

    public boolean isSaveSettings() {
        return this.saveSettings;
    }

    public void setSaveSettings(boolean saveSettings) {
        this.saveSettings = saveSettings;
    }

    public String[] getCopyrecipients() {
        return this.copyrecipients;
    }

    public void setCopyrecipients(String[] copyrecipients) {
        this.copyrecipients = copyrecipients;
    }

    public Map<String, Recipient> getCopyrecipientIndex() {
        return this.copyrecipientIndex;
    }

    public void setCopyrecipientIndex(Map<String, Recipient> copyrecipientIndex) {
        this.copyrecipientIndex = copyrecipientIndex;
    }

    public String[] getBlindcopyrecipients() {
        return this.blindcopyrecipients;
    }

    public void setBlindcopyrecipients(String[] blindcopyrecipients) {
        this.blindcopyrecipients = blindcopyrecipients;
    }

    public Map<String, Recipient> getBlindcopyrecipientIndex() {
        return this.blindcopyrecipientIndex;
    }

    public void setBlindcopyrecipientIndex(Map<String, Recipient> blindcopyrecipientIndex) {
        this.blindcopyrecipientIndex = blindcopyrecipientIndex;
    }

    public boolean isHasBrowseUserPermission() {
        return this.getLoggedInUser() != null && this.globalPermissionManager.hasPermission(GlobalPermissionKey.USER_PICKER, this.getLoggedInUser());
    }

    public boolean isRecipientSelected(String key) {
        return this.recipientIndex.containsKey(key);
    }

    public boolean isCopyRecipientSelected(String key) {
        return this.copyrecipientIndex.containsKey(key);
    }

    public boolean isBlindCopyRecipientSelected(String key) {
        return this.blindcopyrecipientIndex.containsKey(key);
    }

    public boolean isCommentVisibilityGroups() {
        return ComponentAccessor.getApplicationProperties().getOption("jira.comment.level.visibility.groups");
    }

    public boolean isAddAttachments() {
        throw new UnsupportedOperationException();
    }

    public Collection<ProjectRole> getProjectRoles() {
        return this.projectRoleManager.getProjectRoles();
    }

    public Collection<ProjectRole> getUserRoles() {
        return this.projectRoleManager.getProjectRoles();
    }

    public Collection<Group> getGroups() {
        return this.userResolver.getAllUserGroups();
    }

    public Collection<String> getUserGroups() {
        ApplicationUser user = ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser();
        if (user == null) {
            return Collections.EMPTY_LIST;
        }
        return this.groupManager.getGroupNamesForUser(user);
    }

    public List<CustomField> getCustomFields() {
        try {
            ArrayList<CustomField> fields = new ArrayList<CustomField>(this.customFieldManager.getCustomFieldObjects());
            return fields;
        }
        catch (IssuePermissionException e) {
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public I18nHelper getI18n() {
        return this.getI18nHelper();
    }

    public boolean isBypassCommentAllowed() {
        return this.isBypassComment();
    }

    public List<EventType> getEventTypes() {
        ArrayList<EventType> types = new ArrayList<EventType>(this.eventTypeManager.getEventTypes());
        return types;
    }

    public Long getEventType() {
        return this.eventType;
    }

    public void setEventType(Long eventType) {
        this.eventType = eventType;
    }

    public String getEmailIssueSubject() {
        return null;
    }

    public void setEmailIssueSubject(String v) {
    }

    public String getEmailIssueBody() {
        return null;
    }

    public void setEmailIssueBody(String v) {
    }

    public Long[] getPermissionRoles() {
        return this.permissionRoles;
    }

    public void setPermissionRoles(Long[] permissionRoles) {
        this.permissionRoles = permissionRoles;
    }

    public String[] getPermissionGroups() {
        return this.permissionGroups;
    }

    public void setPermissionGroups(String[] permissionGroups) {
        this.permissionGroups = permissionGroups;
    }

    public Long[] getRestrictionRoles() {
        return this.restrictionRoles;
    }

    public void setRestrictionRoles(Long[] restrictionRoles) {
        this.restrictionRoles = restrictionRoles;
    }

    public String[] getRestrictionGroups() {
        return this.restrictionGroups;
    }

    public void setRestrictionGroups(String[] restrictionGroups) {
        this.restrictionGroups = restrictionGroups;
    }

    public String[] getRestrictionFields() {
        return this.restrictionFields;
    }

    public void setRestrictionFields(String[] restrictionFields) {
        this.restrictionFields = restrictionFields;
    }

    public boolean isExternalRecipients() {
        return this.externalRecipients;
    }

    public void setExternalRecipients(boolean externalRecipients) {
        this.externalRecipients = externalRecipients;
    }

    public boolean isBulkOperationDisabled() {
        return this.bulkOperationDisabled;
    }

    public void setBulkOperationDisabled(boolean bulkOperationDisabled) {
        this.bulkOperationDisabled = bulkOperationDisabled;
    }

    public boolean isRestrictionFieldSelected(String fieldId) {
        return ArrayUtils.isInArray(this.restrictionFields, fieldId);
    }

    public boolean isHiddenFieldSelected(String fieldId) {
        return ArrayUtils.isInArray(this.hiddenFields, fieldId);
    }

    public boolean isRestrictionRoleSelected(Long roleId) {
        return ArrayUtils.isInArray(this.restrictionRoles, roleId);
    }

    public boolean isRestrictionGroupSelected(String groupName) {
        return ArrayUtils.isInArray(this.restrictionGroups, groupName);
    }

    public boolean isPermissionRoleSelected(Long roleId) {
        return ArrayUtils.isInArray(this.permissionRoles, roleId);
    }

    public boolean isPermissionGroupSelected(String groupName) {
        return ArrayUtils.isInArray(this.permissionGroups, groupName);
    }

    public boolean isProjectRecipients() {
        return this.projectRecipients;
    }

    public void setProjectRecipients(boolean projectRecipients) {
        this.projectRecipients = projectRecipients;
    }

    public boolean isUserOptionsDisabled() {
        return this.userOptionsDisabled;
    }

    public void setUserOptionsDisabled(boolean userOptionsDisabled) {
        this.userOptionsDisabled = userOptionsDisabled;
    }

    public boolean isBccEnabled() {
        return this.bccEnabled;
    }

    public void setBccEnabled(boolean bccEnabled) {
        this.bccEnabled = bccEnabled;
    }

    public String getRecipientWhitelist() {
        return this.recipientWhitelist;
    }

    public void setRecipientWhitelist(String recipientWhitelist) {
        this.recipientWhitelist = recipientWhitelist;
    }

    public boolean isPopupGroupPicker() {
        return this.popupGroupPicker;
    }

    public void setPopupGroupPicker(boolean popupGroupPicker) {
        this.popupGroupPicker = popupGroupPicker;
    }

    public boolean isEnableJeditor() {
        return this.enableJeditor;
    }

    public void setEnableJeditor(boolean enableJeditor) {
        this.enableJeditor = enableJeditor;
    }

    public String getEmailLogDisplay() {
        return this.emailLogDisplay;
    }

    public void setEmailLogDisplay(String emailLogDisplay) {
        this.emailLogDisplay = emailLogDisplay;
    }

    public String getSenderBlacklist() {
        return this.senderBlacklist;
    }

    public void setSenderBlacklist(String senderBlacklist) {
        this.senderBlacklist = senderBlacklist;
    }

    public boolean isMultipartMixed() {
        return this.multipartMixed;
    }

    public void setMultipartMixed(boolean multipartMixed) {
        this.multipartMixed = multipartMixed;
    }

    public boolean isFixOutlookBlankLine() {
        return this.fixOutlookBlankLine;
    }

    public void setFixOutlookBlankLine(boolean fixOutlookBlankLine) {
        this.fixOutlookBlankLine = fixOutlookBlankLine;
    }

    public String getJqltext() {
        return this.jqltext;
    }

    public void setJqltext(String jqltext) {
        this.jqltext = jqltext;
    }

    public boolean isInactiveRecipients() {
        return this.inactiveRecipients;
    }

    public void setInactiveRecipients(boolean inactiveRecipients) {
        this.inactiveRecipients = inactiveRecipients;
    }

    public Configuration.EmailLogDisplayOption[] getEmailLogDisplayOptions() {
        return Configuration.EmailLogDisplayOption.values();
    }

    public String getRecipientBlacklist() {
        return this.recipientBlacklist;
    }

    public void setRecipientBlacklist(String recipientBlacklist) {
        this.recipientBlacklist = recipientBlacklist;
    }

    public boolean isSanitizeEmailFields() {
        return this.sanitizeEmailFields;
    }

    public void setSanitizeEmailFields(boolean sanitizeEmailFields) {
        this.sanitizeEmailFields = sanitizeEmailFields;
    }

    public String[] getHiddenFields() {
        return this.hiddenFields;
    }

    public void setHiddenFields(String[] hiddenFields) {
        this.hiddenFields = hiddenFields;
    }

    public String getEditorType() {
        return this.editorType;
    }

    public void setEditorType(String editorType) {
        this.editorType = editorType;
    }

    public String getAttachmentPolicy() {
        return this.attachmentPolicy;
    }

    public void setAttachmentPolicy(String attachmentPolicy) {
        this.attachmentPolicy = attachmentPolicy;
    }

    public String getUserGroupBlacklist() {
        return this.userGroupBlacklist;
    }

    public void setUserGroupBlacklist(String userGroupBlacklist) {
        this.userGroupBlacklist = userGroupBlacklist;
    }
}

