/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action.config;

import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.impl.RenderableTextCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugin.ComponentClassManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.service.services.file.AbstractMessageHandlingService;
import com.atlassian.jira.service.util.ServiceUtils;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.metainf.jira.plugin.emailissue.action.config.TabSupport;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskManager;
import com.metainf.jira.plugin.emailissue.entity.AutoReplyParams;
import com.metainf.jira.plugin.emailissue.entity.AutoReplyParamsDao;
import com.metainf.jira.plugin.emailissue.entity.MailHandlerLogDao;
import com.metainf.jira.plugin.emailissue.entity.Template;
import com.metainf.jira.plugin.emailissue.entity.TemplateDao;
import com.metainf.jira.plugin.emailissue.handler.EmailThisIssueMailHandler;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.java.ao.Entity;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AutoReplyContexts
extends TabSupport {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    public static final String KEY_PROJECT = "project";
    public static final String KEY_ISSUETYPE = "issuetype";
    private TemplateDao templateDao;
    private Long senderFieldId;
    private Long senderNameFieldId;
    private Long recipientFieldId;
    private Long copyRecipientFieldId;
    private Long templateId;
    private Long commentTemplateId;
    private String splitregex;
    private String excludeEmailsRegex;
    private String processingStrategy;
    private Long projectId;
    private Long issueTypeId;
    private Long autoReplyContextId;
    private AutoReplyParamsDao autoReplyParamsDao;
    private boolean overwriteContext;
    private ProjectManager projectManager;
    private IssueTypeManager issueTypeManager;
    private CustomFieldManager customFieldManager;
    private boolean treatUserRecipientsAsWatchers;
    private final ServiceManager serviceManager;
    private final PluginAccessor pluginAccessor;
    private final ComponentClassManager componentClassManager;
    private Collection<JiraServiceContainer> emailHandlerServices;
    private final EventTypeManager eventTypeManager;
    private final ServiceDeskManager serviceDeskManager;
    private final AvatarService avatarService;
    private final MailHandlerLogDao mailHandlerLogDao;

    public AutoReplyContexts(Authorizer authorizer, DateTimeFormatterFactory dateTimeFormatterFactory, CustomFieldManager customFieldManager, TemplateDao templateDao, AutoReplyParamsDao autoReplyParamsDao, ProjectManager projectManager, IssueTypeManager issueTypeManager, ConfigurationManager configurationManager, ServiceManager serviceManager, PluginAccessor pluginAccessor, EventTypeManager eventTypeManager, ServiceDeskManager serviceDeskManager, AvatarService avatarService, MailHandlerLogDao mailHandlerLogDao) {
        super(authorizer, dateTimeFormatterFactory, configurationManager);
        this.autoReplyParamsDao = autoReplyParamsDao;
        this.serviceManager = serviceManager;
        this.pluginAccessor = pluginAccessor;
        this.eventTypeManager = eventTypeManager;
        this.serviceDeskManager = serviceDeskManager;
        this.avatarService = avatarService;
        this.mailHandlerLogDao = mailHandlerLogDao;
        this.componentClassManager = ComponentAccessor.getComponentClassManager();
        this.projectManager = projectManager;
        this.issueTypeManager = issueTypeManager;
        this.customFieldManager = customFieldManager;
        this.templateDao = templateDao;
    }

    public String getContentPage() {
        return this.isBeforeJira6() ? "/templates/emailissue/operation/config/autoreply-contexts.vm" : "/templates/emailissue/operation/config/autoreply-contexts6.vm";
    }

    @Override
    public String getActiveTabClass(String tabName) {
        return "autoReplyTab".equals(tabName) ? "active-tab" : "";
    }

    public String doDelete() {
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return this.error();
        }
        if (this.autoReplyContextId != null && this.autoReplyContextId != 0L) {
            AutoReplyParams ctx = (AutoReplyParams)this.autoReplyParamsDao.getById(this.autoReplyContextId);
            this.autoReplyParamsDao.delete(ctx);
        }
        return this.getRedirect("/secure/admin/jeti/jetiAutoReply.jspa");
    }

    public Long getSenderFieldId() {
        return this.senderFieldId;
    }

    public void setSenderFieldId(Long senderFieldId) {
        this.senderFieldId = senderFieldId;
    }

    public Long getRecipientFieldId() {
        return this.recipientFieldId;
    }

    public void setRecipientFieldId(Long recipientFieldId) {
        this.recipientFieldId = recipientFieldId;
    }

    public Long getCopyRecipientFieldId() {
        return this.copyRecipientFieldId;
    }

    public void setCopyRecipientFieldId(Long copyRecipientFieldId) {
        this.copyRecipientFieldId = copyRecipientFieldId;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getIssueTypeId() {
        return this.issueTypeId;
    }

    public void setIssueTypeId(Long issueTypeId) {
        this.issueTypeId = issueTypeId;
    }

    public Long getAutoReplyContextId() {
        return this.autoReplyContextId;
    }

    public void setAutoReplyContextId(Long autoReplyContextId) {
        this.autoReplyContextId = autoReplyContextId;
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public boolean isOverwriteContext() {
        return this.overwriteContext;
    }

    public void setOverwriteContext(boolean overwriteContext) {
        this.overwriteContext = overwriteContext;
    }

    public List<AutoReplyParams> getContexts() {
        ArrayList<Entity> ctxs = new ArrayList<Entity>(Arrays.asList(this.autoReplyParamsDao.findAll()));
        Collections.sort(ctxs, new AutoReplyParams.EntityComparator());
        for (AutoReplyParams autoReplyParams : ctxs) {
            if (autoReplyParams.getProcessingStrategy() != null) continue;
            autoReplyParams.setProcessingStrategy(AutoReplyParams.ProcessingType.CREATE_OR_COMMENT);
        }
        this.emailHandlerServices = this.getMailHandlers();
        return ctxs;
    }

    public boolean isNotAllContextHasHandler() {
        boolean notAll = false;
        for (AutoReplyParams ctx : this.getContexts()) {
            if (this.isContextHasMailHandler(ctx)) continue;
            notAll = true;
            break;
        }
        return notAll;
    }

    public boolean isServiceDeskNeededButNotFound() {
        boolean neededButNotFound = false;
        boolean serviceDeskAvailable = this.isServiceDeskAvailable();
        for (AutoReplyParams ctx : this.getContexts()) {
            if (ctx.getProcessingStrategy() == null || ctx.getProcessingStrategy() != AutoReplyParams.ProcessingType.SERVICEDESK || serviceDeskAvailable) continue;
            neededButNotFound = true;
            break;
        }
        return neededButNotFound;
    }

    public boolean isContextHasMailHandler(@Nonnull AutoReplyParams autoReplyParams) {
        boolean hasHandler = false;
        for (JiraServiceContainer jsc : this.emailHandlerServices) {
            Project mailHandlerProject = this.getMailHandlerProject(jsc);
            IssueConstant mailHandlerIssueType = this.getMailHandlerIssueType(jsc);
            if (mailHandlerProject == null || mailHandlerIssueType == null) continue;
            if (autoReplyParams.getProjectId() != null && autoReplyParams.getIssueTypeId() != null) {
                if (!mailHandlerProject.getId().equals(autoReplyParams.getProjectId()) || !new Long(mailHandlerIssueType.getId()).equals(autoReplyParams.getIssueTypeId())) continue;
                hasHandler = true;
                break;
            }
            if (autoReplyParams.getProjectId() == null && autoReplyParams.getIssueTypeId() != null) {
                if (!new Long(mailHandlerIssueType.getId()).equals(autoReplyParams.getIssueTypeId())) continue;
                hasHandler = true;
                break;
            }
            if (autoReplyParams.getProjectId() != null && autoReplyParams.getIssueTypeId() == null) {
                if (!mailHandlerProject.getId().equals(autoReplyParams.getProjectId())) continue;
                hasHandler = true;
                break;
            }
            hasHandler = true;
            break;
        }
        return hasHandler;
    }

    public List<Project> getProjects() {
        ArrayList<Project> projects = new ArrayList<Project>(this.projectManager.getProjectObjects());
        return projects;
    }

    public List<IssueType> getIssueTypes() {
        ArrayList<IssueType> types = new ArrayList<IssueType>(this.issueTypeManager.getIssueTypes());
        return types;
    }

    public List<Template> getTemplates() {
        ArrayList<Entity> templates = new ArrayList<Entity>(Arrays.asList(this.templateDao.findAll("NAME ASC")));
        Collections.sort(templates, new Template.EntityComparator());
        return templates;
    }

    public List<CustomField> getCustomFields() {
        try {
            ArrayList<CustomField> fields = new ArrayList<CustomField>(this.customFieldManager.getCustomFieldObjects());
            Iterator it = fields.iterator();
            while (it.hasNext()) {
                CustomField customField = (CustomField)it.next();
                CustomFieldType fieldType = customField.getCustomFieldType();
                if (fieldType instanceof RenderableTextCFType) continue;
                it.remove();
            }
            return fields;
        }
        catch (IssuePermissionException e) {
            return Collections.EMPTY_LIST;
        }
    }

    public boolean isCustomFieldExists(Long customFieldId) {
        if (customFieldId == null) {
            return false;
        }
        CustomField cf = customFieldId == null ? null : this.customFieldManager.getCustomFieldObject(customFieldId);
        return cf != null;
    }

    public String getCustomFieldName(Long customFieldId) {
        if (customFieldId == null) {
            return "";
        }
        CustomField cf = customFieldId == null ? null : this.customFieldManager.getCustomFieldObject(customFieldId);
        return cf == null ? "<span style='color:red; font-style:italic;'>CustomField has been deleted</span>" : cf.getName();
    }

    public String getProjectName(Long projectId) {
        if (projectId == null) {
            return "";
        }
        Project p = projectId == null ? null : this.projectManager.getProjectObj(projectId);
        return p == null ? "<span style='color:red; font-style:italic;'>Project has been deleted</span>" : p.getName();
    }

    public Project getProject(Long projectId) {
        return this.projectManager.getProjectObj(projectId);
    }

    public String getIssueTypeName(Long issueTypeId) {
        if (issueTypeId == null) {
            return "";
        }
        IssueType t = this.issueTypeManager.getIssueType(issueTypeId.toString());
        return t == null ? "<span style='color:red; font-style:italic;'>Issue type has been deleted</span>" : t.getNameTranslation();
    }

    public IssueType getIssueType(String issueTypeId) {
        return this.issueTypeManager.getIssueType(issueTypeId);
    }

    public boolean isTreatUserRecipientsAsWatchers() {
        return this.treatUserRecipientsAsWatchers;
    }

    public void setTreatUserRecipientsAsWatchers(boolean treatUserRecipientsAsWatchers) {
        this.treatUserRecipientsAsWatchers = treatUserRecipientsAsWatchers;
    }

    public Collection<JiraServiceContainer> getMailHandlers() {
        Iterable services = this.serviceManager.getServicesManageableBy(this.getLoggedInUser());
        final class IsMailHandlerFilter
        implements Predicate<JiraServiceContainer> {
            IsMailHandlerFilter() {
            }

            public boolean apply(JiraServiceContainer jiraServiceContainer) {
                boolean matchFilter = false;
                try {
                    matchFilter = AbstractMessageHandlingService.class.isAssignableFrom(AutoReplyContexts.this.componentClassManager.loadClass(jiraServiceContainer.getServiceClass()));
                    if (matchFilter) {
                        try {
                            String handlerClass = jiraServiceContainer.getProperty("handler");
                            handlerClass = StringUtils.isBlank((String)handlerClass) ? "" : handlerClass;
                            matchFilter = EmailThisIssueMailHandler.class.getName().equalsIgnoreCase(handlerClass);
                        }
                        catch (ObjectConfigurationException handlerClass) {}
                    }
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
                return matchFilter;
            }
        }
        ImmutableList jiraServiceContainers = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)services, (Predicate)new IsMailHandlerFilter()));
        return jiraServiceContainers;
    }

    @Nullable
    public Project getMailHandlerProject(JiraServiceContainer service) {
        String id = this.getRelatedProjectKey(service);
        return id == null ? null : this.projectManager.getProjectObjByKey(id);
    }

    @Nullable
    public String getRelatedProjectKey(JiraServiceContainer service) {
        Map<String, String> params = this.parseHandlerParams(service);
        String project = params == null ? null : params.get(KEY_PROJECT);
        return project == null ? null : project.toUpperCase(Locale.getDefault());
    }

    @Nullable
    public String getRelatedIssueId(JiraServiceContainer service) {
        Map<String, String> params = this.parseHandlerParams(service);
        return params != null ? StringUtils.trimToNull((String)params.get(KEY_ISSUETYPE)) : null;
    }

    @Nullable
    public IssueConstant getMailHandlerIssueType(JiraServiceContainer service) {
        String issueType = this.getRelatedIssueId(service);
        return issueType == null ? null : this.getConstantsManager().getIssueType(issueType);
    }

    @Nullable
    Map<String, String> parseHandlerParams(JiraServiceContainer service) {
        String params;
        if (!service.isUsable()) {
            return null;
        }
        try {
            params = service.getProperty("handler.params");
            if (params == null) {
                return null;
            }
        }
        catch (ObjectConfigurationException e) {
            return null;
        }
        return ServiceUtils.getParameterMap((String)params);
    }

    public Long getCommentTemplateId() {
        return this.commentTemplateId;
    }

    public void setCommentTemplateId(Long commentTemplateId) {
        this.commentTemplateId = commentTemplateId;
    }

    public String getSplitregex() {
        return this.splitregex;
    }

    public void setSplitregex(String splitregex) {
        this.splitregex = splitregex;
    }

    public String getProcessingStrategy() {
        return this.processingStrategy;
    }

    public void setProcessingStrategy(String processingStrategy) {
        this.processingStrategy = processingStrategy;
    }

    public List<AutoReplyParams.ProcessingType> getProcessingTypes() {
        return Arrays.asList(AutoReplyParams.ProcessingType.values());
    }

    public String getExcludeEmailsRegex() {
        return this.excludeEmailsRegex;
    }

    public void setExcludeEmailsRegex(String excludeEmailsRegex) {
        this.excludeEmailsRegex = excludeEmailsRegex;
    }

    public String getEventTypeName(Long eventTypeId) {
        try {
            EventType eventType = eventTypeId != null ? this.eventTypeManager.getEventType(eventTypeId) : null;
            return eventType != null ? eventType.getName() : null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean isServiceDeskAvailable() {
        return this.serviceDeskManager.isServiceDeskAddOnEnabled();
    }

    public ApplicationUser getUserByKey(String key) {
        return key == null ? null : ApplicationUsers.byKey((String)key);
    }

    public String getAvatarUrl(ApplicationUser user) {
        return user == null ? null : this.avatarService.getAvatarUrlNoPermCheck(user, Avatar.Size.SMALL).toString();
    }

    public Long getSenderNameFieldId() {
        return this.senderNameFieldId;
    }

    public void setSenderNameFieldId(Long senderNameFieldId) {
        this.senderNameFieldId = senderNameFieldId;
    }

    public long getMailHandlerLogCount(AutoReplyParams ctx) {
        return this.mailHandlerLogDao.count(ctx);
    }
}

