/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action.config;

import com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.sal.api.ApplicationProperties;
import com.metainf.jira.plugin.emailissue.action.UserResolver;
import com.metainf.jira.plugin.emailissue.action.config.TabSupport;
import com.metainf.jira.plugin.emailissue.audit.AuditLogBean;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.AuditLogDao;
import com.metainf.jira.plugin.emailissue.entity.AuditLogEntry;
import com.metainf.jira.plugin.emailissue.entity.TemplateDao;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;

public class AuditLogs
extends TabSupport {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    private final AuditLogDao auditLogDao;
    private final ApplicationProperties applicationProperties;
    private final AvatarService avatarService;
    private final UserResolver userResolver;
    private final IssueManager issueManager;
    private final TemplateDao templateDao;
    private static final int DEFAULT_LIMIT = 100;
    private String filter;
    private String emailFromDate;
    private String emailToDate;
    private int limit = 100;
    private int when = -7;

    public AuditLogs(Authorizer authorizer, DateTimeFormatterFactory dateTimeFormatterFactory, ConfigurationManager configurationManager, AuditLogDao auditLogDao, AvatarService avatarService, UserResolver userResolver, ApplicationProperties applicationProperties, IssueManager issueManager, TemplateDao templateDao) {
        super(authorizer, dateTimeFormatterFactory, configurationManager);
        this.auditLogDao = auditLogDao;
        this.avatarService = avatarService;
        this.applicationProperties = applicationProperties;
        this.userResolver = userResolver;
        this.issueManager = issueManager;
        this.templateDao = templateDao;
    }

    public String getContentPage() {
        return this.isBeforeJira6() ? "/templates/emailissue/operation/config/auditlog.vm" : "/templates/emailissue/operation/config/auditlog6.vm";
    }

    @Override
    public String getActiveTabClass(String tabName) {
        return "auditLogTab".equals(tabName) ? "active-tab" : "";
    }

    public List<AuditLogBean> getAuditLog() {
        ArrayList<AuditLogBean> auditLog = new ArrayList<AuditLogBean>();
        try {
            AuditLogEntry[] hits = null;
            Date laterThan = DateUtils.truncate((Date)DateUtils.addDays((Date)new Date(), (int)this.when), (int)5);
            if (StringUtils.isNotBlank((String)this.filter)) {
                String like = "%" + this.filter + "%";
                hits = (AuditLogEntry[])this.auditLogDao.filterAndOrderAndLimit("SEND_TIME_STAMP >= ? AND (ISSUE_KEY LIKE ? OR ISSUE_SUMMARY LIKE ? OR EMAIL_SUBJECT LIKE ? OR EMAIL_BODY LIKE ? OR TO LIKE ? OR RECIPIENTS LIKE ? OR CC LIKE ? OR BCC LIKE ?)", "ID DESC", this.limit, new Object[]{laterThan, like, like, like, like, like, like, like, like});
            } else {
                hits = (AuditLogEntry[])this.auditLogDao.filterAndOrderAndLimit("SEND_TIME_STAMP >= ?", "ID DESC", this.limit, new Object[]{laterThan});
            }
            for (AuditLogEntry log : hits) {
                MutableIssue issue = log.getIssueId() != null ? this.issueManager.getIssueObject(log.getIssueId()) : null;
                try {
                    auditLog.add(new AuditLogBean((Issue)issue, log, this.getDateTimeFormatter().forLoggedInUser(), this.getI18nHelper(), this.avatarService, this.userResolver, this.applicationProperties, this.templateDao));
                }
                catch (Exception e) {
                    this.logger.error((Object)(e.getMessage() + ", " + log), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            auditLog = new ArrayList();
        }
        return auditLog;
    }

    public String getBaseUrl() {
        return ComponentAccessor.getApplicationProperties().getString("jira.baseurl");
    }

    public String doSearch() {
        return this.success();
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getEmailFromDate() {
        return this.emailFromDate;
    }

    public void setEmailFromDate(String emailFromDate) {
        this.emailFromDate = emailFromDate;
    }

    public String getEmailToDate() {
        return this.emailToDate;
    }

    public void setEmailToDate(String emailToDate) {
        this.emailToDate = emailToDate;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getWhen() {
        return this.when;
    }

    public void setWhen(int when) {
        this.when = when;
    }
}

