/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action;

import com.atlassian.jira.user.ApplicationUser;
import com.metainf.jira.plugin.emailissue.action.RecipientFilter;
import org.apache.commons.lang.StringUtils;

public class WhitelistRecipientFilter
implements RecipientFilter {
    protected String[] whitelistRegExpressions;

    public WhitelistRecipientFilter(String whitelist) {
        this.whitelistRegExpressions = StringUtils.isNotBlank((String)whitelist) ? whitelist.split("\r\n") : new String[]{};
    }

    @Override
    public boolean acceptsEmailAddress(String emailAddress) {
        return this.isEmailAddressMatchesExpressions(emailAddress);
    }

    @Override
    public boolean acceptsUser(ApplicationUser user) {
        return user != null ? this.isEmailAddressMatchesExpressions(user.getEmailAddress()) : true;
    }

    protected boolean isEmailAddressMatchesExpressions(String email) {
        if (StringUtils.isBlank((String)email) || this.whitelistRegExpressions == null || this.whitelistRegExpressions.length == 0) {
            return true;
        }
        for (String regex : this.whitelistRegExpressions) {
            if (!StringUtils.isNotBlank((String)regex) || !email.matches(regex)) continue;
            return true;
        }
        return false;
    }
}

