/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.group.search.GroupPickerSearchService;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.impl.CalculatedCFType;
import com.atlassian.jira.issue.customfields.impl.MultiGroupCFType;
import com.atlassian.jira.issue.customfields.impl.MultiSelectCFType;
import com.atlassian.jira.issue.customfields.impl.MultiUserCFType;
import com.atlassian.jira.issue.customfields.impl.RenderableTextCFType;
import com.atlassian.jira.issue.customfields.impl.SelectCFType;
import com.atlassian.jira.issue.customfields.impl.UserCFType;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.metainf.jira.plugin.emailissue.action.EmailDefinition;
import com.metainf.jira.plugin.emailissue.action.Recipient;
import com.metainf.jira.plugin.emailissue.action.RecipientFilterChain;
import com.metainf.jira.plugin.emailissue.action.UserResolver;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.operation.PermissionChecker;
import com.metainf.jira.plugin.emailissue.util.CustomFieldUtil;
import com.metainf.jira.plugin.emailissue.util.ObjectFactory;
import com.metainf.jira.plugin.emailissue.util.UserCompatibilityHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class UserResolverImpl
implements UserResolver {
    public static final String EMAIL_REGEXP = "[A-Za-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[A-Za-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[A-Za-z0-9](?:[A-Za-z0-9-]*[A-Za-z0-9])?\\.)+[A-Za-z0-9](?:[A-Za-z0-9-]*[A-Za-z0-9])?";
    private WatcherManager watcherManager;
    private CustomFieldManager customFieldManager;
    private ProjectRoleManager projectRoleManager;
    private GroupManager groupManager;
    private final UserManager userManager;
    private final ConfigurationManager configurationManager;
    private final PermissionManager permissionManager;
    private final PermissionChecker permissionChecker;
    private final UserSearchService userSearchService;
    private final GroupPickerSearchService groupPickerSearchService;
    private final GlobalPermissionManager globalPermissionManager;

    public UserResolverImpl(PermissionManager permissionManager, WatcherManager watcherManager, CustomFieldManager customFieldManager, ProjectRoleManager projectRoleManager, GroupManager groupManager, UserManager userManager, ConfigurationManager configurationManager, PermissionChecker permissionChecker, UserSearchService userSearchService, GroupPickerSearchService groupPickerSearchService, GlobalPermissionManager globalPermissionManager) {
        this.permissionChecker = permissionChecker;
        this.userSearchService = userSearchService;
        this.groupPickerSearchService = groupPickerSearchService;
        this.globalPermissionManager = globalPermissionManager;
        if (watcherManager == null) {
            throw new IllegalArgumentException("WatcherManager must not be null");
        }
        if (customFieldManager == null) {
            throw new IllegalArgumentException("CustomFieldManager must not be null");
        }
        if (projectRoleManager == null) {
            throw new IllegalArgumentException("ProjectRoleManager must not be null");
        }
        this.watcherManager = watcherManager;
        this.customFieldManager = customFieldManager;
        this.projectRoleManager = projectRoleManager;
        this.groupManager = groupManager;
        this.userManager = userManager;
        this.configurationManager = configurationManager;
        this.permissionManager = permissionManager;
    }

    @Override
    public Set<String> getRecipients(EmailDefinition emailDefinition) {
        Set<String> emailAddresses = this.getAllEmailAddresses(emailDefinition, emailDefinition.getRecipientObjects(), emailDefinition.getEmailIssueTo());
        return emailAddresses;
    }

    @Override
    public Set<String> getAuthorizedRecipients(EmailDefinition emailDefinition, RecipientFilterChain filter) {
        return this.getAuthorizedEmailAddresses(emailDefinition, emailDefinition.getRecipientObjects(), emailDefinition.getEmailIssueTo(), filter);
    }

    @Override
    public Set<String> getCopyRecipients(EmailDefinition emailDefinition) {
        Set<String> emailAddresses = this.getAllEmailAddresses(emailDefinition, emailDefinition.getCopyrecipientObjects(), emailDefinition.getEmailIssueCc());
        return emailAddresses;
    }

    @Override
    public Set<String> getAuthorizedCopyRecipients(EmailDefinition emailDefinition, RecipientFilterChain filter) {
        return this.getAuthorizedEmailAddresses(emailDefinition, emailDefinition.getCopyrecipientObjects(), emailDefinition.getEmailIssueCc(), filter);
    }

    @Override
    public Set<String> getBlindCopyRecipients(EmailDefinition emailDefinition) {
        Set<String> emailAddresses = this.getAllEmailAddresses(emailDefinition, emailDefinition.getBlindCopyrecipientObjects(), emailDefinition.getEmailIssueBcc());
        return emailAddresses;
    }

    @Override
    public Set<String> getAuthorizedBlindCopyRecipients(EmailDefinition emailDefinition, RecipientFilterChain filter) {
        return this.getAuthorizedEmailAddresses(emailDefinition, emailDefinition.getBlindCopyrecipientObjects(), emailDefinition.getEmailIssueBcc(), filter);
    }

    @Override
    public Set<ApplicationUser> getUsers(EmailDefinition emailDefinition) {
        HashSet<ApplicationUser> users = new HashSet<ApplicationUser>();
        this.addJiraUsers(emailDefinition.getEmailIssueTo(), users);
        this.addJiraUsers(emailDefinition.getEmailIssueCc(), users);
        users.addAll(this.resolveUsers(emailDefinition, emailDefinition.getRecipientObjects()));
        users.addAll(this.resolveUsers(emailDefinition, emailDefinition.getCopyrecipientObjects()));
        return users;
    }

    @Override
    public Collection<Group> getAllUserGroups() {
        return this.groupManager.getAllGroups();
    }

    @Override
    public Set<String> getUnresolvables(String tokenString) {
        HashSet<String> invalidTokens = new HashSet<String>();
        if (StringUtils.isNotBlank((String)tokenString)) {
            String[] tokens = Splitter.BY_COMMA.split(tokenString);
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i].trim();
                if (StringUtils.isEmpty((String)token) || this.isUser(token) || this.isEmailAddress(token) || this.isExtendedEmailAddress(token)) continue;
                invalidTokens.add(token);
            }
            if (!invalidTokens.isEmpty()) {
                HashSet<String> invalidTokensBySpaces = new HashSet<String>();
                String[] tokensBySpaces = Splitter.BY_COMMA_SPACE.split(tokenString);
                for (int i = 0; i < tokensBySpaces.length; ++i) {
                    String token = tokensBySpaces[i].trim();
                    if (StringUtils.isEmpty((String)token) || this.isUser(token) || this.isEmailAddress(token) || this.isExtendedEmailAddress(token)) continue;
                    invalidTokensBySpaces.add(token);
                }
                if (invalidTokensBySpaces.isEmpty()) {
                    invalidTokens = invalidTokensBySpaces;
                }
            }
        }
        return invalidTokens;
    }

    @Override
    public Set<String> getExternalRecipients(EmailDefinition def) {
        return this.getExternalRecipients(def, def.getEmailIssueTo(), def.getEmailIssueCc(), def.getEmailIssueBcc(), def.getRecipientObjects(), def.getCopyrecipientObjects(), def.getBlindCopyrecipientObjects());
    }

    @Override
    public Set<String> getExternalRecipients(EmailDefinition emailDefinition, String emailIssueTo, String emailIssueCc, String emailIssueBcc, List<Recipient> recipientObjects, List<Recipient> copyrecipientObjects, List<Recipient> blindcopyrecipientObjects) {
        HashSet<String> emailAddresses = new HashSet<String>();
        emailAddresses.addAll(this.getExternalRecipients(emailIssueTo));
        emailAddresses.addAll(this.getExternalRecipients(emailIssueCc));
        emailAddresses.addAll(this.getExternalRecipients(emailIssueBcc));
        emailAddresses.addAll(this.resolveNonUserEmailAddresses(emailDefinition, recipientObjects));
        emailAddresses.addAll(this.resolveNonUserEmailAddresses(emailDefinition, copyrecipientObjects));
        emailAddresses.addAll(this.resolveNonUserEmailAddresses(emailDefinition, blindcopyrecipientObjects));
        return emailAddresses;
    }

    protected Set<String> getAllEmailAddresses(EmailDefinition emailDefinition, List<Recipient> recipientObjects, String recipients) {
        Set<ApplicationUser> users = this.resolveUsers(emailDefinition, recipientObjects);
        this.addJiraUsers(recipients, users);
        HashSet<String> emails = new HashSet<String>();
        emails.addAll(this.resolveNonUserEmailAddresses(emailDefinition, recipientObjects));
        emails.addAll(this.getExternalRecipients(recipients));
        for (ApplicationUser user : users) {
            emails.add(user.getEmailAddress());
        }
        return emails;
    }

    @Override
    public Set<ApplicationUser> getAuthorizedUserRecipients(EmailDefinition emailDefinition, List<Recipient> recipientObjects, String recipients, RecipientFilterChain filter) {
        ApplicationUser user;
        Iterator<ApplicationUser> it;
        Set<ApplicationUser> users = this.resolveUsers(emailDefinition, recipientObjects);
        this.addJiraUsers(recipients, users);
        if (filter != null) {
            it = users.iterator();
            while (it.hasNext()) {
                user = it.next();
                if (filter.acceptsUser(user)) continue;
                it.remove();
            }
        }
        if (this.configurationManager.getGlobalConfiguration().getProjectUserRecipients() == 1) {
            it = users.iterator();
            while (it.hasNext()) {
                user = it.next();
                if (this.permissionChecker.isAllowedToViewIssue(user, emailDefinition.getIssueObject())) continue;
                it.remove();
            }
        }
        return users;
    }

    @Override
    public Set<String> getAuthorizedNonUserRecipients(EmailDefinition emailDefinition, List<Recipient> recipientObjects, String recipients, RecipientFilterChain filter) {
        HashSet<String> emails = new HashSet<String>();
        if (this.configurationManager.getGlobalConfiguration().getExternalRecipients() != 1) {
            emails.addAll(this.resolveNonUserEmailAddresses(emailDefinition, recipientObjects));
            emails.addAll(this.getExternalRecipients(recipients));
            if (filter != null) {
                Iterator it = emails.iterator();
                while (it.hasNext()) {
                    if (filter.acceptsEmailAddress((String)it.next())) continue;
                    it.remove();
                }
            }
            emailDefinition.setHasExternalRecipients(emailDefinition.isHasExternalRecipients() || !emails.isEmpty());
        }
        return emails;
    }

    protected Set<String> getAuthorizedEmailAddresses(EmailDefinition emailDefinition, List<Recipient> recipientObjects, String recipients, RecipientFilterChain filter) {
        Set<ApplicationUser> users = this.getAuthorizedUserRecipients(emailDefinition, recipientObjects, recipients, filter);
        Set<String> emails = this.getAuthorizedNonUserRecipients(emailDefinition, recipientObjects, recipients, filter);
        for (ApplicationUser user : users) {
            emails.add(user.getEmailAddress());
        }
        return emails;
    }

    protected void addUser(Collection<ApplicationUser> users, ApplicationUser user) {
        if (user != null) {
            users.add(user);
        }
    }

    protected Set<ApplicationUser> resolveUsers(EmailDefinition emailDefinition, List<Recipient> recipients) {
        HashSet<ApplicationUser> users = new HashSet<ApplicationUser>();
        if (recipients != null) {
            block7: for (Recipient r : recipients) {
                switch (r.getType()) {
                    case USER: {
                        this.addUser(users, this.userManager.getUserByName(r.getId()));
                        break;
                    }
                    case OTHER_USER: {
                        if (r.isMe()) {
                            this.addUser(users, emailDefinition.getRemoteUser());
                            break;
                        }
                        if (r.isReporter()) {
                            this.addUser(users, emailDefinition.getIssueObject().getReporter());
                            break;
                        }
                        if (r.isAssignee()) {
                            this.addUser(users, emailDefinition.getIssueObject().getAssignee());
                            break;
                        }
                        if (r.isWatchers()) {
                            users.addAll(this.watcherManager.getWatchers(emailDefinition.getIssueObject(), emailDefinition.getI18n().getLocale()));
                            break;
                        }
                        if (r.isProjectLead()) {
                            this.addUser(users, emailDefinition.getIssueObject().getProjectObject().getProjectLead());
                            break;
                        }
                        if (!r.isComponentLead()) break;
                        for (ProjectComponent component : emailDefinition.getIssueObject().getComponents()) {
                            if (component.getComponentLead() == null) continue;
                            this.addUser(users, component.getComponentLead());
                        }
                        continue block7;
                    }
                    case ROLE: {
                        ProjectRole projectRole = this.projectRoleManager.getProjectRole(Long.valueOf(Long.parseLong(r.getId())));
                        this.addUsersFromRole(projectRole, users, emailDefinition.getIssueObject().getProjectObject());
                        break;
                    }
                    case GROUP: {
                        Group group = this.groupManager.getGroup(r.getId());
                        this.addUsersFromGroup(group, users);
                        break;
                    }
                    case FIELD: {
                        this.addJiraUsersFromCustomField(r.getId(), emailDefinition.getIssueObject(), users);
                    }
                }
            }
        }
        return users;
    }

    protected Set<String> resolveNonUserEmailAddresses(EmailDefinition emailDefinition, List<Recipient> recipients) {
        HashSet<String> emailAddresses = new HashSet<String>();
        if (recipients != null) {
            block4: for (Recipient r : recipients) {
                switch (r.getType()) {
                    case EMAIL: {
                        emailAddresses.add(r.getId());
                        break;
                    }
                    case FIELD: {
                        String value;
                        CustomField cf = this.customFieldManager.getCustomFieldObject(r.getId());
                        if (cf == null || emailDefinition == null) break;
                        CustomFieldType fieldType = cf.getCustomFieldType();
                        Object fieldValue = emailDefinition.getIssueObject().getCustomFieldValue(cf);
                        if (fieldValue == null) break;
                        if (CustomFieldUtil.isBugWatcherField(fieldType)) {
                            String[] tokens;
                            String emailWatchers;
                            Map watchers = (Map)fieldValue;
                            if (watchers == null || watchers.size() <= 0 || !watchers.containsKey("directIssueWatchers") || !StringUtils.isNotBlank((String)(emailWatchers = (String)watchers.get("directIssueWatchers")))) continue block4;
                            for (String token : tokens = emailWatchers.split(",")) {
                                String emailAddress;
                                if (token == null || !token.trim().startsWith("e:") || !StringUtils.isNotBlank((String)(emailAddress = token.trim().substring(2)))) continue;
                                emailAddresses.add(emailAddress);
                            }
                            continue block4;
                        }
                        if (fieldType instanceof RenderableTextCFType || CustomFieldUtil.isJIRAToolkitUserPropertyField(fieldType)) {
                            value = (String)fieldValue;
                            emailAddresses.addAll(this.getExternalRecipients(value));
                            break;
                        }
                        if (fieldType instanceof MultiSelectCFType && fieldValue instanceof Collection) {
                            Collection options = (Collection)fieldValue;
                            for (Object o : options) {
                                if (!(o instanceof Option)) continue;
                                emailAddresses.addAll(this.getExternalRecipients(((Option)o).getValue()));
                            }
                            continue block4;
                        }
                        if (fieldType instanceof CalculatedCFType && fieldValue != null) {
                            value = fieldValue.toString();
                            emailAddresses.addAll(this.getExternalRecipients(value));
                            break;
                        }
                        if (CustomFieldUtil.isCRMField(fieldType)) {
                            if (!(fieldValue instanceof String)) break;
                            if (this.isEmailAddress((String)fieldValue)) {
                                emailAddresses.add((String)fieldValue);
                                break;
                            }
                            Object contactValue = ObjectFactory.invokeMethod(fieldType, fieldType.getClass(), "getContactEmail", new Class[]{String.class}, new Object[]{fieldValue});
                            if (contactValue == null || !(contactValue instanceof String)) continue block4;
                            for (String emailAddress : ((String)contactValue).split(",")) {
                                if (!this.isEmailAddress(emailAddress = emailAddress.trim())) continue;
                                emailAddresses.add(emailAddress);
                            }
                            continue block4;
                        }
                        if (!(fieldType instanceof SelectCFType) || !(fieldValue instanceof Option)) break;
                        Option option = (Option)fieldValue;
                        emailAddresses.addAll(this.getExternalRecipients(option.getValue()));
                        break;
                    }
                }
            }
        }
        return emailAddresses;
    }

    protected void addJiraUsersFromCustomField(String customFieldKey, Issue issue, Set<ApplicationUser> users) {
        CustomField cf = this.customFieldManager.getCustomFieldObject(customFieldKey);
        if (cf != null) {
            CustomFieldType fieldType = cf.getCustomFieldType();
            Object fieldValue = issue.getCustomFieldValue(cf);
            if (CustomFieldUtil.isBugWatcherField(fieldType) && fieldValue != null) {
                String groupsAndRoles;
                Map watchers = (Map)fieldValue;
                if (watchers != null && watchers.containsKey("indirectIssueWatchers") && StringUtils.isNotBlank((String)(groupsAndRoles = (String)watchers.get("indirectIssueWatchers")))) {
                    for (String token : groupsAndRoles.split(",")) {
                        if (token == null) continue;
                        if ((token = token.trim()).startsWith("r:")) {
                            ProjectRole projectRole = this.projectRoleManager.getProjectRole(Long.valueOf(Long.parseLong(token.substring(2))));
                            this.addUsersFromRole(projectRole, users, issue.getProjectObject());
                            continue;
                        }
                        if (!token.startsWith("g:")) continue;
                        Group group = this.groupManager.getGroup(token.substring(2));
                        this.addUsersFromGroup(group, users);
                    }
                }
            } else if (fieldType instanceof UserCFType && fieldValue != null && UserCompatibilityHelper.isUserObject(fieldValue)) {
                users.add(UserCompatibilityHelper.toApplicationUser(fieldValue));
            } else if (fieldType instanceof MultiUserCFType && fieldValue instanceof Collection) {
                for (Object value : (Collection)fieldValue) {
                    if (value == null || !UserCompatibilityHelper.isUserObject(value)) continue;
                    users.add(UserCompatibilityHelper.toApplicationUser(value));
                }
            } else if (fieldType instanceof MultiGroupCFType && fieldValue instanceof Collection) {
                for (Object value : (Collection)fieldValue) {
                    if (!(value instanceof Group)) continue;
                    Group group = (Group)value;
                    this.addUsersFromGroup(group, users);
                }
            } else if (fieldType instanceof RenderableTextCFType || CustomFieldUtil.isJIRAToolkitUserPropertyField(fieldType)) {
                String value = (String)fieldValue;
                this.addJiraUsers(value, users);
            } else if (fieldType != null && CustomFieldUtil.isServiceDeskParticipantField(fieldType) && fieldValue instanceof Collection) {
                for (Object value : (Collection)fieldValue) {
                    if (value == null || !UserCompatibilityHelper.isUserObject(value)) continue;
                    users.add(UserCompatibilityHelper.toApplicationUser(value));
                }
            } else if (fieldType instanceof MultiSelectCFType && fieldValue instanceof Collection) {
                Collection options = (Collection)fieldValue;
                for (Object o : options) {
                    if (!(o instanceof Option)) continue;
                    this.addJiraUsers(((Option)o).getValue(), users);
                }
            } else if (fieldType instanceof SelectCFType && fieldValue instanceof Option) {
                Option option = (Option)fieldValue;
                this.addJiraUsers(option.getValue(), users);
            } else if (fieldType instanceof CalculatedCFType && fieldValue != null) {
                String valueAsString = fieldValue.toString();
                this.addJiraUsers(valueAsString, users);
            }
        }
    }

    protected void addJiraUsers(String userNamesOrEmailAddresses, Set<ApplicationUser> users) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)userNamesOrEmailAddresses)) {
            return;
        }
        String[] tokens = Splitter.BY_COMMA.split(userNamesOrEmailAddresses);
        String[] tokensByCommaAndSpace = Splitter.BY_COMMA_SPACE.split(userNamesOrEmailAddresses);
        HashSet<String> allTokens = new HashSet<String>(Arrays.asList(tokens));
        allTokens.addAll(Arrays.asList(tokensByCommaAndSpace));
        HashSet<String> tokensProcessed = new HashSet<String>();
        for (String token : allTokens) {
            String email;
            if (StringUtils.isEmpty((String)(token = token.trim())) || tokensProcessed.contains(token)) continue;
            tokensProcessed.add(token);
            if (this.isUser(token)) {
                ApplicationUser user = this.userManager.getUserByName(token);
                if (user != null) {
                    users.add(user);
                } else {
                    user = this.userManager.getUserByKey(token);
                    if (user != null) {
                        users.add(user);
                    }
                }
            }
            if (this.isEmailAddress(token)) {
                users.addAll(this.getUsersByEmail(token));
                continue;
            }
            if (!this.isExtendedEmailAddress(token) || (email = this.getEmailAddressFromExtendedAddress(token)) == null) continue;
            users.addAll(this.getUsersByEmail(email));
        }
    }

    @Override
    public Set<ApplicationUser> getUsersByEmail(String email) {
        HashSet<ApplicationUser> users = new HashSet<ApplicationUser>();
        for (ApplicationUser au : this.userSearchService.findUsersByEmail(email)) {
            users.add(au);
        }
        return users;
    }

    @Override
    public boolean isEmailAddress(String token) {
        return token != null && token.matches(EMAIL_REGEXP);
    }

    @Override
    public String getEmailAddressFromExtendedAddress(String token) {
        if (this.isExtendedEmailAddress(token)) {
            int s = token.indexOf("<");
            int e = token.indexOf(">");
            if (token != null && s > -1 && e > s) {
                token = token.substring(s + 1, e);
                return token;
            }
            return null;
        }
        return token;
    }

    @Override
    public boolean isExtendedEmailAddress(String token) {
        if (StringUtils.isBlank((String)token)) {
            return false;
        }
        int s = token.indexOf("<");
        int e = token.indexOf(">");
        if (s > -1 && e > s) {
            return (token = token.substring(s + 1, e)) != null && token.matches(EMAIL_REGEXP);
        }
        return false;
    }

    @Override
    public boolean isUser(String token) {
        return this.userManager.getUserByName(token) != null || this.userManager.getUserByKey(token) != null;
    }

    @Override
    public boolean isGroup(String token) {
        return this.groupManager.groupExists(token);
    }

    private Set<String> getExternalRecipients(String recipients) {
        HashSet<String> emailAddresses = new HashSet<String>();
        if (recipients != null) {
            String[] tokens;
            for (String token : tokens = Splitter.BY_COMMA_SPACE.split(recipients)) {
                String email;
                if (token == null) continue;
                if (this.isEmailAddress(token = token.trim()) && this.getUsersByEmail(token).isEmpty()) {
                    emailAddresses.add(token);
                    continue;
                }
                if (!this.isExtendedEmailAddress(token) || !this.getUsersByEmail(token).isEmpty() || !StringUtils.isNotBlank((String)(email = this.getEmailAddressFromExtendedAddress(token)))) continue;
                emailAddresses.add(email);
            }
        }
        return emailAddresses;
    }

    @Override
    public ApplicationUser getFirstApplicationUserForEmailAddress(String emailAddress) {
        if (StringUtils.isBlank((String)emailAddress)) {
            return null;
        }
        Iterator it = this.userSearchService.findUsersByEmail(emailAddress).iterator();
        return it.hasNext() ? (ApplicationUser)it.next() : null;
    }

    @Override
    public ApplicationUser getFirstUserForEmailAddress(String emailAddress) {
        ApplicationUser userForEmail = this.getFirstApplicationUserForEmailAddress(emailAddress);
        return userForEmail;
    }

    @Override
    public ApplicationUser getFirstApplicationUserForFullName(String fullName) {
        ApplicationUser user = null;
        if (StringUtils.isNotBlank((String)fullName)) {
            String userName;
            Iterable userNames = this.userSearchService.findUserKeysByFullName(fullName);
            String string = userName = userNames != null && userNames.iterator() != null ? (String)userNames.iterator().next() : null;
            if (userName != null) {
                user = this.userManager.getUserByName(userName);
            }
        }
        return user;
    }

    protected void addUsersFromGroup(Group group, Collection<ApplicationUser> users) {
        if (group != null) {
            users.addAll(this.groupManager.getUsersInGroup(group));
        }
    }

    private void addUsersFromRole(ProjectRole projectRole, Collection<ApplicationUser> users, Project project) {
        ProjectRoleActors actors;
        if (projectRole != null && (actors = this.projectRoleManager.getProjectRoleActors(projectRole, project)) != null) {
            users.addAll(actors.getUsers());
        }
    }

    @Override
    public ApplicationUser getFirstAdminUser() {
        ApplicationUser sysAdmin = null;
        for (String s : this.globalPermissionManager.getGroupNamesWithPermission(GlobalPermissionKey.SYSTEM_ADMIN)) {
            Collection users;
            Group g = this.groupManager.getGroup(s);
            if (g == null || (users = this.groupManager.getUsersInGroup(g)) == null || users.isEmpty()) continue;
            sysAdmin = (ApplicationUser)users.iterator().next();
            break;
        }
        return sysAdmin;
    }

    private static enum Splitter {
        BY_COMMA("[,;]"),
        BY_COMMA_SPACE("[,; ]");

        private String delimiter;

        private Splitter(String delimiter) {
            this.delimiter = delimiter;
        }

        public String[] split(String values) {
            return StringUtils.isBlank((String)values) ? new String[]{} : values.split(this.delimiter);
        }
    }
}

