/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action;

import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.metainf.jira.plugin.emailissue.action.EmailDefinition;
import com.metainf.jira.plugin.emailissue.action.RecipientFilter;
import org.apache.commons.lang.StringUtils;

public class SecuredCommentsRecipientFilter
implements RecipientFilter {
    private final EmailDefinition emailDefinition;
    private final GroupManager groupManager;
    private final ProjectRoleManager projectRoleManager;

    public SecuredCommentsRecipientFilter(EmailDefinition emailDefinition, GroupManager groupManager, ProjectRoleManager projectRoleManager) {
        this.emailDefinition = emailDefinition;
        this.groupManager = groupManager;
        this.projectRoleManager = projectRoleManager;
    }

    @Override
    public boolean acceptsEmailAddress(String emailAddress) {
        return false;
    }

    @Override
    public boolean acceptsUser(ApplicationUser user) {
        return StringUtils.isNotBlank((String)this.emailDefinition.getIssueEvent().getComment().getGroupLevel()) && this.groupManager.getGroupNamesForUser(user).contains(this.emailDefinition.getIssueEvent().getComment().getGroupLevel()) || this.emailDefinition.getIssueEvent().getComment().getRoleLevel() != null && this.projectRoleManager.isUserInProjectRole(user, this.emailDefinition.getIssueEvent().getComment().getRoleLevel(), this.emailDefinition.getIssueObject().getProjectObject());
    }
}

