/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action;

import com.atlassian.jira.user.ApplicationUser;
import com.metainf.jira.plugin.emailissue.action.RecipientFilter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class RecipientFilterChain {
    private int numberOfExcludedUsers;
    private int numberOfExcludedEmailAddresses;
    private Set<ApplicationUser> excludedUsers = new HashSet<ApplicationUser>();
    private Set<String> excludedEmailAddresses = new HashSet<String>();
    private List<RecipientFilter> filterChain = new LinkedList<RecipientFilter>();

    public RecipientFilterChain next(RecipientFilter filter) {
        this.filterChain.add(filter);
        return this;
    }

    public boolean acceptsEmailAddress(String emailAddress) {
        for (RecipientFilter filter : this.filterChain) {
            if (filter.acceptsEmailAddress(emailAddress)) continue;
            ++this.numberOfExcludedEmailAddresses;
            this.excludedEmailAddresses.add(emailAddress);
            return false;
        }
        return true;
    }

    public boolean acceptsUser(ApplicationUser user) {
        for (RecipientFilter filter : this.filterChain) {
            if (filter.acceptsUser(user)) continue;
            ++this.numberOfExcludedUsers;
            this.excludedUsers.add(user);
            return false;
        }
        return true;
    }

    public int getNumberOfExcludedUsers() {
        return this.numberOfExcludedUsers;
    }

    public int getNumberOfExcludedEmailAddresses() {
        return this.numberOfExcludedEmailAddresses;
    }

    public Set<ApplicationUser> getExcludedUsers() {
        return this.excludedUsers;
    }

    public Set<String> getExcludedEmailAddresses() {
        return this.excludedEmailAddresses;
    }
}

