/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.util.I18nHelper;
import java.util.HashMap;
import java.util.Map;

public class Recipient
implements Comparable<Recipient> {
    private String key;
    private String displayName;
    private Type type;

    public Recipient(String key, String displayName, Type type) {
        this.key = key;
        this.displayName = displayName;
        this.type = type;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getId() {
        return this.getKey().substring(this.getKey().indexOf(":") + 1);
    }

    @Override
    public int compareTo(Recipient o) {
        return this.type.compareTo(o.type);
    }

    public boolean isMe() {
        return "o:me".equals(this.getKey());
    }

    public boolean isReporter() {
        return "o:reporter".equals(this.getKey());
    }

    public boolean isAssignee() {
        return "o:assignee".equals(this.getKey());
    }

    public boolean isWatchers() {
        return "o:watchers".equals(this.getKey());
    }

    public boolean isProjectLead() {
        return "o:lead".equals(this.getKey());
    }

    public boolean isComponentLead() {
        return "o:comp".equals(this.getKey());
    }

    public static Map<String, Recipient> buildRecipients(String[] recipientKeys, CustomFieldManager customFieldManager, GroupManager groupManager, ProjectRoleManager projectRoleManager, I18nHelper i18n) {
        HashMap<String, Recipient> result = null;
        if (recipientKeys == null) {
            result = new HashMap<String, Recipient>(0);
        } else {
            result = new HashMap(recipientKeys.length);
            block6: for (String r : recipientKeys) {
                r = r == null ? "" : r.trim();
                int p = r.indexOf(":");
                if (p <= -1) continue;
                String id = r.substring(p + 1);
                Type type = Type.fromKey(r.substring(0, p + 1));
                switch (type) {
                    case OTHER_USER: {
                        String displayName = null;
                        if (r.equals("o:me")) {
                            displayName = i18n.getText("issuemail.form.cc.me");
                        } else if (r.equals("o:reporter")) {
                            displayName = i18n.getText("issuemail.form.to.reporter");
                        } else if (r.equals("o:assignee")) {
                            displayName = i18n.getText("issuemail.form.to.assignee");
                        } else if (r.equals("o:watchers")) {
                            displayName = i18n.getText("issuemail.form.to.watchers");
                        } else if (r.equals("o:lead")) {
                            displayName = i18n.getText("issuemail.form.cc.lead");
                        } else if (r.equals("o:comp")) {
                            displayName = i18n.getText("issuemail.form.componentleads");
                        }
                        result.put(r, new Recipient(r, displayName, type));
                        continue block6;
                    }
                    case GROUP: {
                        Group g = groupManager.getGroup(id);
                        if (g == null) continue block6;
                        result.put(r, new Recipient(r, g.getName(), Type.GROUP));
                        continue block6;
                    }
                    case ROLE: {
                        ProjectRole role = projectRoleManager.getProjectRole(Long.valueOf(Long.parseLong(id)));
                        if (role == null) continue block6;
                        result.put(r, new Recipient(r, role.getName(), Type.ROLE));
                        continue block6;
                    }
                    case FIELD: {
                        CustomField cf = customFieldManager.getCustomFieldObject(id);
                        if (cf == null) continue block6;
                        result.put(r, new Recipient(r, cf.getName(), Type.FIELD));
                        continue block6;
                    }
                }
            }
        }
        return result;
    }

    public static Recipient buildRecipient(String recipientKey, CustomFieldManager customFieldManager, GroupManager groupManager, ProjectRoleManager projectRoleManager, I18nHelper i18n) {
        Recipient recipient = null;
        int p = (recipientKey = recipientKey == null ? "" : recipientKey.trim()).indexOf(":");
        if (p > -1) {
            String id = recipientKey.substring(p + 1);
            Type type = Type.fromKey(recipientKey.substring(0, p + 1));
            switch (type) {
                case OTHER_USER: {
                    String displayName = null;
                    if (recipientKey.equals("o:me")) {
                        displayName = i18n.getText("issuemail.form.cc.me");
                    } else if (recipientKey.equals("o:reporter")) {
                        displayName = i18n.getText("issuemail.form.to.reporter");
                    } else if (recipientKey.equals("o:assignee")) {
                        displayName = i18n.getText("issuemail.form.to.assignee");
                    } else if (recipientKey.equals("o:watchers")) {
                        displayName = i18n.getText("issuemail.form.to.watchers");
                    } else if (recipientKey.equals("o:lead")) {
                        displayName = i18n.getText("issuemail.form.cc.lead");
                    } else if (recipientKey.equals("o:comp")) {
                        displayName = i18n.getText("issuemail.form.componentleads");
                    }
                    recipient = new Recipient(recipientKey, displayName, type);
                    break;
                }
                case GROUP: {
                    Group g = groupManager.getGroup(id);
                    if (g == null) break;
                    recipient = new Recipient(recipientKey, g.getName(), Type.GROUP);
                    break;
                }
                case ROLE: {
                    ProjectRole role = projectRoleManager.getProjectRole(Long.valueOf(Long.parseLong(id)));
                    if (role == null) break;
                    recipient = new Recipient(recipientKey, role.getName(), Type.ROLE);
                    break;
                }
                case FIELD: {
                    CustomField cf = customFieldManager.getCustomFieldObject(id);
                    if (cf == null) break;
                    recipient = new Recipient(recipientKey, cf.getName(), Type.FIELD);
                    break;
                }
            }
        }
        return recipient;
    }

    public static Recipient getRecipientObject(String recipientKey, CustomFieldManager customFieldManager, GroupManager groupManager, ProjectRoleManager projectRoleManager, I18nHelper i18n) {
        Map<String, Recipient> map = Recipient.buildRecipients(new String[]{recipientKey}, customFieldManager, groupManager, projectRoleManager, i18n);
        return map.get(recipientKey);
    }

    public static enum Type {
        USER("u:"),
        EMAIL("e:"),
        OTHER_USER("o:"),
        ROLE("r:"),
        GROUP("g:"),
        FIELD("cf:");

        private String key;

        private Type(String key) {
            this.key = key;
        }

        public static Type fromKey(String key) {
            for (Type t : Type.values()) {
                if (key == null || !key.trim().startsWith(t.key)) continue;
                return t;
            }
            return null;
        }
    }
}

