/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action;

import com.metainf.jira.plugin.emailissue.action.EmailDefinition;
import com.metainf.jira.plugin.emailissue.action.Recipient;
import com.metainf.jira.plugin.emailissue.action.UserResolver;
import com.metainf.jira.plugin.emailissue.workflow.EmailDefinitionImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class PopupGroupPickerSupport
extends EmailDefinitionImpl
implements EmailDefinition {
    private final UserResolver userResolver;

    public PopupGroupPickerSupport(UserResolver userResolver, EmailDefinition emailDefinition) {
        super(emailDefinition);
        this.setAttachmentObjects(emailDefinition.getAttachmentObjects());
        this.userResolver = userResolver;
        ArrayList<Recipient> toWithGroups = new ArrayList<Recipient>(this.getRecipientObjects());
        String toWithoutGroups = this.moveGroupsToRecipients(this.getEmailIssueTo(), toWithGroups);
        this.setEmailIssueTo(toWithoutGroups);
        this.setRecipientObjects(toWithGroups);
        ArrayList<Recipient> ccWithGroups = new ArrayList<Recipient>(this.getCopyrecipientObjects());
        String ccWithoutGroups = this.moveGroupsToRecipients(this.getEmailIssueCc(), ccWithGroups);
        this.setEmailIssueCc(ccWithoutGroups);
        this.setCopyrecipientObjects(ccWithGroups);
        ArrayList<Recipient> bccWithGroups = new ArrayList<Recipient>(this.getBlindCopyrecipientObjects());
        String bccWithoutGroups = this.moveGroupsToRecipients(this.getEmailIssueBcc(), bccWithGroups);
        this.setEmailIssueBcc(bccWithoutGroups);
        this.setBlindCopyrecipientObjects(bccWithGroups);
    }

    private String moveGroupsToRecipients(String userEnteredRecipients, List<Recipient> pickerRecipients) {
        StringBuilder withoutGroups = new StringBuilder();
        if (StringUtils.isNotBlank((String)userEnteredRecipients)) {
            String[] tokens;
            for (String token : tokens = userEnteredRecipients.split("[,;]")) {
                String string = token = token != null ? token.trim() : null;
                if (this.userResolver.isEmailAddress(token) || this.userResolver.isExtendedEmailAddress(token) || this.userResolver.isUser(token) || !this.userResolver.isGroup(token)) {
                    if (withoutGroups.length() > 0) {
                        withoutGroups.append(",");
                    }
                    withoutGroups.append(token);
                    continue;
                }
                pickerRecipients.add(new Recipient("g:" + token, token, Recipient.Type.GROUP));
            }
        }
        return withoutGroups.toString();
    }
}

