/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.metainf.jira.plugin.emailissue.action.EmailDefinition;
import com.metainf.jira.plugin.emailissue.action.RecipientFilter;
import com.metainf.jira.plugin.emailissue.entity.Configuration;
import com.metainf.jira.plugin.emailissue.util.AnonymousUser;
import org.apache.commons.lang.StringUtils;

public class OwnChangesRecipientFilter
implements RecipientFilter {
    private final EmailDefinition emailDefinition;
    private final ApplicationUser currentUser;
    private final boolean notifyOnMyChanges;
    private final Configuration globalConfig;

    public OwnChangesRecipientFilter(EmailDefinition emailDefinition, UserPreferencesManager userPreferencesManager, Configuration globalConfig) {
        this.emailDefinition = emailDefinition;
        this.currentUser = emailDefinition.getRemoteUser();
        this.globalConfig = globalConfig;
        this.notifyOnMyChanges = emailDefinition.getEmailOptions().isIgnoreMyChanges() || this.currentUser != null && !(this.currentUser instanceof AnonymousUser) && userPreferencesManager.getExtendedPreferences(this.currentUser).getBoolean("user.notify.own.changes");
    }

    @Override
    public boolean acceptsEmailAddress(String emailAddress) {
        return this.notifyOnMyChanges || this.currentUser != null && StringUtils.isNotBlank((String)emailAddress) && !emailAddress.equalsIgnoreCase(this.currentUser.getEmailAddress());
    }

    @Override
    public boolean acceptsUser(ApplicationUser user) {
        return this.notifyOnMyChanges || user != null && (user.isActive() || Boolean.TRUE.equals(this.globalConfig.isInactiveRecipients())) && !user.getEmailAddress().equalsIgnoreCase(this.currentUser.getEmailAddress());
    }
}

