/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.security.roles.ProjectRole;
import com.metainf.jira.plugin.emailissue.entity.Configuration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class GlobalConfigHelper {
    public static final String PARAM_SEND_EMAIL_EVENT_ID = "send.email.event.id";
    private static transient Logger logger = Logger.getLogger((String)("com.atlassian." + GlobalConfigHelper.class.getName()));
    private static Map<String, String> globalProperties;

    public static Map<String, String> loadGlobalParameters() {
        if (globalProperties == null || globalProperties.isEmpty()) {
            HashMap<String, String> properties = new HashMap<String, String>();
            InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream("email-this-issue.properties");
            if (resource != null) {
                try {
                    Properties p = new Properties();
                    p.load(resource);
                    for (Map.Entry<Object, Object> entry : p.entrySet()) {
                        properties.put((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("Global configuration file cannot be loaded: " + e), (Throwable)e);
                }
            }
            logger.debug((Object)("Global configuration file loaded: " + properties));
            globalProperties = properties;
        }
        return globalProperties;
    }

    public static void excludeGroups(Configuration config, Collection<Group> groups) {
        if (groups != null && !groups.isEmpty()) {
            HashSet excludedGroups = StringUtils.isEmpty((String)config.getExcludeGroups()) ? new HashSet() : new HashSet<String>(Arrays.asList(config.getExcludeGroups().split(",")));
            String[] blacklistedGroups = StringUtils.isNotBlank((String)config.getUserGroupBlacklist()) ? config.getUserGroupBlacklist().split("\r\n") : new String[]{};
            Iterator<Group> it = groups.iterator();
            while (it.hasNext()) {
                Group group = it.next();
                if (excludedGroups.contains(group.getName())) {
                    it.remove();
                    continue;
                }
                if (blacklistedGroups == null || blacklistedGroups.length <= 0) continue;
                for (String regex : blacklistedGroups) {
                    if (!group.getName().matches(regex)) continue;
                    it.remove();
                }
            }
        }
    }

    public static void excludeRoles(Configuration config, Collection<ProjectRole> roles) {
        if (roles != null && !roles.isEmpty() && StringUtils.isNotEmpty((String)config.getExcludeRoles())) {
            HashSet<String> excludedRoles = new HashSet<String>(Arrays.asList(config.getExcludeRoles().split(",")));
            Iterator<ProjectRole> it = roles.iterator();
            while (it.hasNext()) {
                ProjectRole role = it.next();
                if (!excludedRoles.contains(role.getId().toString())) continue;
                it.remove();
            }
        }
    }

    public static void excludeFields(Configuration config, Collection<CustomField> fields) {
        if (fields != null && !fields.isEmpty() && StringUtils.isNotEmpty((String)config.getExcludeFields())) {
            HashSet<String> excludedFields = new HashSet<String>(Arrays.asList(config.getExcludeFields().split(",")));
            Iterator<CustomField> it = fields.iterator();
            while (it.hasNext()) {
                CustomField field = it.next();
                if (!excludedFields.contains(field.getId())) continue;
                it.remove();
            }
        }
    }
}

