/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.core.util.FileSize;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.AttachmentsBulkOperationResult;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.TemporaryAttachmentsMonitorLocator;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.TemporaryWebAttachmentManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.mail.TemplateIssue;
import com.atlassian.jira.mail.TemplateIssueFactory;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.issue.AbstractIssueSelectAction;
import com.metainf.jira.plugin.emailissue.action.AttachmentComparator;
import com.metainf.jira.plugin.emailissue.action.AttachmentInfo;
import com.metainf.jira.plugin.emailissue.action.EditorType;
import com.metainf.jira.plugin.emailissue.action.EmailBuilder;
import com.metainf.jira.plugin.emailissue.action.EmailDefinition;
import com.metainf.jira.plugin.emailissue.action.EmailOptions;
import com.metainf.jira.plugin.emailissue.action.EmailSource;
import com.metainf.jira.plugin.emailissue.action.EmailSupport;
import com.metainf.jira.plugin.emailissue.action.EmailSupportOptionsInitializer;
import com.metainf.jira.plugin.emailissue.action.GlobalConfigHelper;
import com.metainf.jira.plugin.emailissue.action.PopupGroupPickerSupport;
import com.metainf.jira.plugin.emailissue.action.Recipient;
import com.metainf.jira.plugin.emailissue.action.UserResolver;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.AuditLogDao;
import com.metainf.jira.plugin.emailissue.entity.AuditLogEntry;
import com.metainf.jira.plugin.emailissue.entity.CannedResponse;
import com.metainf.jira.plugin.emailissue.entity.CannedResponseDao;
import com.metainf.jira.plugin.emailissue.entity.Configuration;
import com.metainf.jira.plugin.emailissue.entity.Context;
import com.metainf.jira.plugin.emailissue.entity.DefaultTemplate;
import com.metainf.jira.plugin.emailissue.entity.Template;
import com.metainf.jira.plugin.emailissue.entity.TemplateDao;
import com.metainf.jira.plugin.emailissue.mail.EmailSender;
import com.metainf.jira.plugin.emailissue.mail.SmartEmail;
import com.metainf.jira.plugin.emailissue.operation.PermissionChecker;
import com.metainf.jira.plugin.emailissue.template.MailTemplateManager;
import com.metainf.jira.plugin.emailissue.template.Renderer;
import com.metainf.jira.plugin.emailissue.template.TemplateRenderer;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import com.metainf.jira.plugin.emailissue.util.CollectionUtils;
import com.metainf.jira.plugin.emailissue.util.CommentComparator;
import com.metainf.jira.plugin.emailissue.util.CustomFieldUtil;
import com.metainf.jira.plugin.emailissue.util.Enums;
import com.metainf.jira.plugin.emailissue.util.OptionsCookieHelper;
import com.metainf.jira.plugin.emailissue.workflow.EmailDefinitionImpl;
import com.metainf.jira.plugin.emailissue.workflow.IssueTransitioner;
import com.metainf.jira.plugin.versionkit.AppVersionManager;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import webwork.action.Action;
import webwork.action.ActionContext;
import webwork.action.ServletActionContext;

public class EmailThisIssue
extends AbstractIssueSelectAction
implements EmailDefinition,
EmailSupport {
    private static final long serialVersionUID = 1L;
    private static transient Logger logger = Logger.getLogger((String)EmailThisIssue.class.getName());
    private String sendEmailAction;
    private String emailIssueTo;
    private String emailIssueCc;
    private String emailIssueBcc;
    private String emailIssueSubject;
    private String emailIssueBody;
    private String[] attachments;
    private I18nHelper i18n = this.getI18nHelper();
    private UserResolver userResolver;
    private final EmailSender emailSender;
    private final EmailBuilder emailBuilder;
    private ProjectRoleManager projectRoleManager;
    private ConfigurationManager configurationManager;
    private GroupManager groupManager;
    private CommentManager commentManager;
    private AttachmentManager attachmentManager;
    private CustomFieldManager customFieldManager;
    private String[] recipients;
    private Map<String, Recipient> recipientIndex = new HashMap<String, Recipient>();
    private EmailOptions emailOptions = new EmailOptions("");
    private boolean saveSettings;
    private String[] copyrecipients;
    private Map<String, Recipient> copyrecipientIndex = new HashMap<String, Recipient>();
    private String[] blindcopyrecipients;
    private Map<String, Recipient> blindcopyrecipientIndex = new HashMap<String, Recipient>();
    private RendererManager rendererManager;
    private GlobalPermissionManager globalPermissionManager;
    private DateTimeFormatter dateTimeFormatter;
    private Authorizer authorizer;
    private MailTemplateManager mailTemplateManager;
    private AppVersionManager appVersionManager;
    private final PermissionManager permissionManager;
    private final PermissionChecker permissionChecker;
    private final CannedResponseDao cannedResponseDao;
    private final FieldLayoutManager fieldLayoutManager;
    private final TemplateRenderer templateRenderer;
    private final TemplateDao templateDao;
    private final AuditLogDao auditLogDao;
    private final UserPreferencesManager userPreferencesManager;
    private final IssueTransitioner issueTransitioner;
    private String attachedFiles;
    private EditorType editorType = EditorType.WIKI;
    private boolean jeditorEnabled;
    private List<String> fromAddresses = new LinkedList<String>();
    private String fromAddress;
    private String transitionId;
    private boolean hasExternalRecipients;
    private final IssueUpdater issueUpdater;
    private final TemporaryAttachmentsMonitorLocator temporaryAttachmentsMonitorLocator;
    private Context context;
    private String[] responseCategories = null;
    private Long templateId;
    private SmartEmail email;
    private Collection<String> templateCategories;
    private Long auditId;

    public EmailThisIssue(EmailSender emailSender, EmailBuilder emailBuilder, RendererManager rendererManager, GlobalPermissionManager globalPermissionManager, UserResolver userResolver, ProjectRoleManager projectRoleManager, GroupManager groupManager, CommentManager commentManager, AttachmentManager attachmentManager, CustomFieldManager customFieldManager, DateTimeFormatterFactory dateTimeFormatterFactory, Authorizer authorizer, ConfigurationManager configurationManager, MailTemplateManager mailTemplateManager, AppVersionManager appVersionManager, PermissionManager permissionManager, PermissionChecker permissionChecker, CannedResponseDao cannedResponseDao, FieldLayoutManager fieldLayoutManager, TemplateRenderer templateRenderer, ActiveObjects ao, AuditLogDao auditLogDao, TemporaryAttachmentsMonitorLocator temporaryAttachmentsMonitorLocator, IssueUpdater issueUpdater, UserPreferencesManager userPreferencesManager, IssueTransitioner issueTransitioner) {
        this.templateDao = new TemplateDao(ao);
        this.configurationManager = configurationManager;
        this.templateRenderer = templateRenderer;
        this.permissionManager = permissionManager;
        this.appVersionManager = appVersionManager;
        this.emailSender = emailSender;
        this.emailBuilder = emailBuilder;
        this.globalPermissionManager = globalPermissionManager;
        this.userResolver = userResolver;
        this.mailTemplateManager = mailTemplateManager;
        this.projectRoleManager = projectRoleManager;
        this.rendererManager = rendererManager;
        this.groupManager = groupManager;
        this.commentManager = commentManager;
        this.attachmentManager = attachmentManager;
        this.customFieldManager = customFieldManager;
        this.dateTimeFormatter = dateTimeFormatterFactory.formatter().forLoggedInUser();
        this.authorizer = authorizer;
        this.fieldLayoutManager = fieldLayoutManager;
        this.temporaryAttachmentsMonitorLocator = temporaryAttachmentsMonitorLocator;
        this.cannedResponseDao = cannedResponseDao;
        this.issueUpdater = issueUpdater;
        this.permissionChecker = permissionChecker;
        this.auditLogDao = auditLogDao;
        this.userPreferencesManager = userPreferencesManager;
        this.issueTransitioner = issueTransitioner;
    }

    public final String execute() throws Exception {
        String result = super.execute();
        return "input".equalsIgnoreCase(result) && !this.appVersionManager.isBeforeJira6() ? "input6" : result;
    }

    protected void doValidation() {
        try {
            Set<String> externalRecipients;
            Configuration globalConfiguration;
            super.doValidation();
            EmailDefinition emailDefinition = this.toEmailDefinition(this.getSource());
            logger.debug((Object)"Doing validation...");
            Set<String> unresolveables = this.userResolver.getUnresolvables(emailDefinition.getEmailIssueTo());
            unresolveables.addAll(this.userResolver.getUnresolvables(emailDefinition.getEmailIssueCc()));
            unresolveables.addAll(this.userResolver.getUnresolvables(emailDefinition.getEmailIssueBcc()));
            if (!unresolveables.isEmpty()) {
                this.addErrorMessage(this.getI18n().getText("issuemail.error.unresolveable.recipients", StringEscapeUtils.escapeHtml((String)CollectionUtils.toString(unresolveables))));
            }
            if (this.userResolver.getRecipients(emailDefinition).isEmpty() && this.userResolver.getCopyRecipients(emailDefinition).isEmpty() && this.userResolver.getBlindCopyRecipients(emailDefinition).isEmpty()) {
                this.addErrorMessage(this.getI18n().getText("issuemail.error.no.recipients"));
            }
            if (!((globalConfiguration = this.configurationManager.getGlobalConfiguration()).getExternalRecipients() != 1 && globalConfiguration.getProjectUserRecipients() != 1 || (externalRecipients = this.userResolver.getExternalRecipients(emailDefinition, emailDefinition.getEmailIssueTo(), emailDefinition.getEmailIssueCc(), emailDefinition.getEmailIssueBcc(), emailDefinition.getRecipientObjects(), emailDefinition.getCopyrecipientObjects(), emailDefinition.getBlindCopyrecipientObjects())).isEmpty())) {
                this.addErrorMessage(this.getI18n().getText("issuemail.error.external.recipients", CollectionUtils.toString(externalRecipients)));
            }
            if (globalConfiguration.getProjectUserRecipients() == 1) {
                Set<ApplicationUser> users = this.userResolver.getUsers(emailDefinition);
                Iterator<ApplicationUser> it = users.iterator();
                while (it.hasNext()) {
                    if (!this.permissionChecker.isAllowedToViewIssue(it.next(), this.getIssueObject())) continue;
                    it.remove();
                }
                if (!users.isEmpty()) {
                    StringBuilder list = new StringBuilder();
                    for (ApplicationUser user : users) {
                        if (list.length() > 0) {
                            list.append(",");
                        }
                        list.append(user.getName());
                    }
                    this.addErrorMessage(this.getI18n().getText("issuemail.error.project.recipients", list.toString()));
                }
            }
        }
        catch (IssuePermissionException e) {
            this.errorMessages.clear();
        }
    }

    public String doForward() throws Exception {
        String page = this.doView();
        AuditLogEntry ale = (AuditLogEntry)this.auditLogDao.getById(this.auditId);
        if (ale != null) {
            this.emailIssueSubject = ale.getEmailSubject();
            if (ale.getType() == AuditLogEntry.EmailType.INCOMING_ISSUE) {
                String subjectTemplate;
                String string = this.context == null ? "$!issue.key $!issue.summary " : (this.context.getPrefillTemplate() == null ? (this.context.getTemplate() != null ? this.context.getTemplate().getSubject() : null) : (subjectTemplate = this.context.getPrefillTemplate().getSubject()));
                if (StringUtils.isNotBlank((String)subjectTemplate)) {
                    String[] baseUrl = this.getApplicationProperties().getString("jira.baseurl");
                    Map contextParams = this.mailTemplateManager.getIssueMailContextParams(this.getIssueObject(), this.getLoggedInUser(), this);
                    contextParams.put("mailSubject", ale.getEmailSubject());
                    this.emailIssueSubject = this.templateRenderer.renderTextContent(subjectTemplate, (String)baseUrl, contextParams);
                }
            }
            this.emailIssueSubject = "Fwd: " + this.emailIssueSubject;
            this.emailIssueBody = (this.emailIssueBody == null ? "" : this.emailIssueBody) + this.getBodyForReply(ale);
            if (StringUtils.isNotBlank((String)ale.getAttachments())) {
                HashSet<String> attachmentNames = new HashSet<String>();
                for (String an : ale.getAttachments().split(",")) {
                    attachmentNames.add(an.trim());
                }
                HashSet<String> attachmentIds = new HashSet<String>();
                for (AttachmentInfo ai : this.getIssueAttachments()) {
                    if (!attachmentNames.contains(ai.getName())) continue;
                    attachmentIds.add(ai.getId().toString());
                }
                if (!attachmentIds.isEmpty()) {
                    this.attachments = attachmentIds.toArray(new String[0]);
                }
            }
            if (ale.getTemplateId() != null) {
                this.setTemplateId(new Long(ale.getTemplateId().intValue()));
            }
        }
        return page;
    }

    private String getBodyForReply(AuditLogEntry ale) {
        String templateContent = this.mailTemplateManager.getMailAttributesTemplateContent(this.editorType.isSupportsHtml() ? "html" : "text");
        HashMap<String, AuditLogEntry> contextParams = new HashMap<String, AuditLogEntry>();
        contextParams.put("auditLogItem", ale);
        String mailAttributes = this.templateRenderer.renderContent(templateContent, null, contextParams, this.editorType.isSupportsHtml() ? TemplateRenderer.TargetFormat.HTML : TemplateRenderer.TargetFormat.TEXT);
        StringBuilder sb = new StringBuilder(mailAttributes);
        sb.append(this.editorType.isSupportsHtml() ? ale.getEmailBody() : this.convertToText(ale.getEmailBody()));
        return sb.toString();
    }

    public String doReply() throws Exception {
        String page = this.doView();
        AuditLogEntry ale = (AuditLogEntry)this.auditLogDao.getById(this.auditId);
        if (ale != null) {
            this.emailIssueSubject = ale.getEmailSubject();
            if (ale.getType() == AuditLogEntry.EmailType.INCOMING_ISSUE) {
                String subjectTemplate;
                String string = this.context == null ? "$!issue.key $!issue.summary " : (this.context.getPrefillTemplate() == null ? (this.context.getTemplate() != null ? this.context.getTemplate().getSubject() : null) : (subjectTemplate = this.context.getPrefillTemplate().getSubject()));
                if (StringUtils.isNotBlank((String)subjectTemplate)) {
                    String baseUrl = this.getApplicationProperties().getString("jira.baseurl");
                    Map contextParams = this.mailTemplateManager.getIssueMailContextParams(this.getIssueObject(), this.getLoggedInUser(), this);
                    contextParams.put("mailSubject", ale.getEmailSubject());
                    this.emailIssueSubject = this.templateRenderer.renderTextContent(subjectTemplate, baseUrl, contextParams);
                }
            }
            this.emailIssueSubject = "Re: " + this.emailIssueSubject;
            this.emailIssueBody = (this.emailIssueBody == null ? "" : this.emailIssueBody) + this.getBodyForReply(ale);
            if (ale.getType() == AuditLogEntry.EmailType.OUTGOING) {
                ApplicationUser au = ApplicationUsers.byKey((String)ale.getSenderKey());
                this.setEmailIssueTo(au != null ? au.getName() : null);
            } else {
                this.setEmailIssueTo(ale.getFrom());
            }
            if (ale.getTemplateId() != null) {
                this.setTemplateId(new Long(ale.getTemplateId().intValue()));
            }
            this.setEmailIssueCc("");
            this.setEmailIssueBcc("");
            this.setRecipients(null);
            this.setCopyrecipients(null);
            this.setBlindcopyrecipients(null);
        }
        return page;
    }

    public String doReplyAll() throws Exception {
        String page = this.doView();
        AuditLogEntry ale = (AuditLogEntry)this.auditLogDao.getById(this.auditId);
        if (ale != null) {
            ApplicationUser au;
            this.emailIssueSubject = ale.getEmailSubject();
            if (ale.getType() == AuditLogEntry.EmailType.INCOMING_ISSUE) {
                String subjectTemplate;
                String string = this.context == null ? "$!issue.key $!issue.summary " : (this.context.getPrefillTemplate() == null ? (this.context.getTemplate() != null ? this.context.getTemplate().getSubject() : null) : (subjectTemplate = this.context.getPrefillTemplate().getSubject()));
                if (StringUtils.isNotBlank((String)subjectTemplate)) {
                    String baseUrl = this.getApplicationProperties().getString("jira.baseurl");
                    Map contextParams = this.mailTemplateManager.getIssueMailContextParams(this.getIssueObject(), this.getLoggedInUser(), this);
                    contextParams.put("mailSubject", ale.getEmailSubject());
                    this.emailIssueSubject = this.templateRenderer.renderTextContent(subjectTemplate, baseUrl, contextParams);
                }
            }
            this.emailIssueSubject = "Re: " + this.emailIssueSubject;
            this.emailIssueBody = (this.emailIssueBody == null ? "" : this.emailIssueBody) + this.getBodyForReply(ale);
            String from = "";
            from = ale.getType() == AuditLogEntry.EmailType.OUTGOING ? ((au = ApplicationUsers.byKey((String)ale.getSenderKey())) != null ? au.getName() : "") : ale.getFrom();
            String to = ale.getRecipients();
            to = to != null && to.length() > 0 ? to + "," + from : from;
            this.setEmailIssueTo(to);
            this.setEmailIssueCc(ale.getCc());
            this.setEmailIssueBcc(ale.getBcc());
            this.setRecipients(null);
            this.setCopyrecipients(null);
            this.setBlindcopyrecipients(null);
            if (ale.getTemplateId() != null) {
                this.setTemplateId(new Long(ale.getTemplateId().intValue()));
            }
        }
        return page;
    }

    public String doResend() throws Exception {
        String page = this.doView();
        AuditLogEntry ale = (AuditLogEntry)this.auditLogDao.getById(this.auditId);
        if (ale != null) {
            ApplicationUser au;
            this.emailIssueSubject = ale.getEmailSubject();
            this.emailIssueBody = this.editorType.isSupportsHtml() ? ale.getEmailBody() : this.convertToText(ale.getEmailBody());
            String from = "";
            from = ale.getType() == AuditLogEntry.EmailType.OUTGOING ? ((au = ApplicationUsers.byKey((String)ale.getSenderKey())) != null ? au.getName() : "") : ale.getFrom();
            String to = ale.getRecipients();
            to = to != null && to.length() > 0 ? to + "," + from : from;
            this.setEmailIssueTo(to);
            this.setEmailIssueCc(ale.getCc());
            this.setEmailIssueBcc(ale.getBcc());
            this.setRecipients(null);
            this.setCopyrecipients(null);
            this.setBlindcopyrecipients(null);
            if (ale.getTemplateId() != null) {
                this.setTemplateId(new Long(ale.getTemplateId().intValue()));
            }
            if (ale.getAttachments() != null) {
                String[] attachmentNames = ale.getAttachments().split(",");
                ArrayList attachments = new ArrayList(this.getIssueObject().getAttachments());
                Collections.sort(attachments, new AttachmentComparator());
                HashSet<String> attachmentIds = new HashSet<String>();
                block0: for (String attachmentName : attachmentNames) {
                    for (Attachment ai : attachments) {
                        if (!attachmentName.trim().equalsIgnoreCase(ai.getFilename())) continue;
                        attachmentIds.add(ai.getId().toString());
                        continue block0;
                    }
                }
                if (!attachmentIds.isEmpty()) {
                    this.setAttachments(attachmentIds.toArray(new String[0]));
                }
            }
            EmailDefinition emailDefinition = this.toEmailDefinition(EmailSource.OPERATION);
            this.emailSender.sendEmailWithUserEditedSubjectAsync(emailDefinition, this.getEmailIssueSubject(), this.getLoggedInUser());
        }
        return this.getRedirect("/browse/" + this.getIssue().getString("key"));
    }

    private String convertToText(String emailBody) {
        String text;
        String string = text = emailBody == null ? null : StringEscapeUtils.unescapeHtml((String)emailBody);
        if (text != null) {
            Document document = Jsoup.parse(text);
            document.select("br").append("\\n");
            document.select("p").prepend("\\n\\n");
            text = document.text().replace("\\n", "\n");
        }
        return text;
    }

    public String doView() throws Exception {
        try {
            if (!this.permissionChecker.isAllowedToSendIssueInEmail(this.getLoggedInUser(), this.getIssueObject())) {
                return this.getRedirect("/browse/" + this.getIssue().getString("key"));
            }
            Configuration globalConfig = this.configurationManager.getGlobalConfiguration();
            Configuration configMatchingIssue = this.configurationManager.resolveConfiguration(this.getIssueObject());
            if (configMatchingIssue != null && StringUtils.isNotBlank((String)configMatchingIssue.getFromAddresses())) {
                this.fromAddresses.addAll(Arrays.asList(configMatchingIssue.getFromAddresses().split("\r\n")));
            }
            Map<String, String> properties = globalConfig.isUserOptionsDisabled() ? Collections.EMPTY_MAP : new OptionsCookieHelper().get(ServletActionContext.getRequest());
            EmailSupportOptionsInitializer.initalizeEmailOptions(this, properties, configMatchingIssue != null ? configMatchingIssue : globalConfig);
            String baseUrl = this.getApplicationProperties().getString("jira.baseurl");
            Map contextParams = this.mailTemplateManager.getIssueMailContextParams(this.getIssueObject(), this.getLoggedInUser(), this);
            this.initialize(globalConfig);
            if (this.context != null) {
                String bodyTemplate;
                String subjectTemplate;
                String string = this.context.getPrefillTemplate() == null ? (this.context.getTemplate() != null ? this.context.getTemplate().getSubject() : null) : (subjectTemplate = this.context.getPrefillTemplate().getSubject());
                String string2 = this.context.getPrefillTemplate() == null ? null : (bodyTemplate = this.editorType.isSupportsHtml() ? this.context.getPrefillTemplate().getHtml() : this.context.getPrefillTemplate().getText());
                if (StringUtils.isNotBlank((String)subjectTemplate)) {
                    this.emailIssueSubject = this.templateRenderer.renderTextContent(subjectTemplate, baseUrl, contextParams);
                }
                if (StringUtils.isNotBlank(bodyTemplate)) {
                    this.emailIssueBody = this.templateRenderer.renderContent(bodyTemplate, baseUrl, contextParams, this.editorType.isSupportsHtml() ? TemplateRenderer.TargetFormat.HTML : TemplateRenderer.TargetFormat.TEXT);
                }
                if (this.context.getTemplate() != null) {
                    this.templateId = new Long(this.context.getTemplate().getID());
                }
            } else {
                String subjectTemplate = this.mailTemplateManager.getSubjectTemplate();
                if (StringUtils.isNotBlank((String)subjectTemplate)) {
                    this.emailIssueSubject = this.templateRenderer.renderTextContent(subjectTemplate, baseUrl, contextParams);
                }
            }
            return "input";
        }
        catch (IssuePermissionException e) {
            return this.redirectToSessionTimeoutPage();
        }
    }

    private void initialize(Configuration globalConfig) {
        this.editorType = globalConfig.getEditorType() == null ? EditorType.WIKI : globalConfig.getEditorType();
        this.context = this.mailTemplateManager.resolveContext(this.getIssueObject());
        if ((this.context == null || this.context.getDisableCannedResponses() == null || Boolean.FALSE.equals(this.context.getDisableCannedResponses())) && this.cannedResponseDao.exists()) {
            if (this.context == null || StringUtils.isBlank((String)this.context.getResponseCategories())) {
                Collection<String> categories = this.cannedResponseDao.getAllCategories();
                categories.add("");
                this.responseCategories = categories.toArray(new String[0]);
            } else {
                this.responseCategories = this.context.getResponseCategories().split(",");
            }
        } else {
            this.responseCategories = null;
        }
        if (this.context != null && StringUtils.isNotBlank((String)this.context.getTemplateCategories())) {
            this.templateCategories = Arrays.asList(this.context.getTemplateCategories().split(","));
        }
    }

    protected void buildOptions(StringBuffer sb, String name, String value) {
        if (StringUtils.isNotEmpty((String)name)) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(name).append("=").append(value == null ? "" : value);
        }
    }

    protected Map<String, String> getSavedProperties() {
        StringBuffer s;
        HashMap<String, String> properties = new HashMap<String, String>();
        if (this.isBypassCommentAllowed()) {
            this.putBooleanProperty(properties, "bypassComment");
        } else {
            properties.put("bypassComment", Boolean.FALSE.toString());
        }
        properties.put("emailOptions", this.getOptions());
        if (this.recipientIndex != null && !this.recipientIndex.isEmpty()) {
            s = new StringBuffer();
            for (String r : this.recipientIndex.keySet()) {
                if (s.length() > 0) {
                    s.append(",");
                }
                s.append(r);
            }
            properties.put("recipients", s.toString());
        }
        if (this.copyrecipientIndex != null && !this.copyrecipientIndex.isEmpty()) {
            s = new StringBuffer();
            for (String r : this.copyrecipientIndex.keySet()) {
                if (s.length() > 0) {
                    s.append(",");
                }
                s.append(r);
            }
            properties.put("copyrecipients", s.toString());
        }
        if (this.blindcopyrecipientIndex != null && !this.blindcopyrecipientIndex.isEmpty()) {
            s = new StringBuffer();
            for (String r : this.blindcopyrecipientIndex.keySet()) {
                if (s.length() > 0) {
                    s.append(",");
                }
                s.append(r);
            }
            properties.put("blindcopyrecipients", s.toString());
        }
        if (StringUtils.isNotBlank((String)this.getEmailIssueTo())) {
            properties.put("emailIssueTo", this.getEmailIssueTo());
        }
        if (StringUtils.isNotBlank((String)this.getEmailIssueCc())) {
            properties.put("emailIssueCc", this.getEmailIssueCc());
        }
        if (StringUtils.isNotBlank((String)this.getEmailIssueBcc())) {
            properties.put("emailIssueBcc", this.getEmailIssueBcc());
        }
        return properties;
    }

    public String doDefault() throws Exception {
        return super.doDefault();
    }

    protected EmailDefinition toEmailDefinition(EmailSource emailSource) {
        EmailDefinitionImpl emailDefinition = this.configurationManager.getGlobalConfiguration().isPopupGroupPicker() ? new PopupGroupPickerSupport(this.userResolver, this) : new EmailDefinitionImpl(this);
        emailDefinition.getEmailOptions().setRichHtml(this.editorType.isSupportsHtml());
        emailDefinition.setSource(emailSource);
        if (this.getTemplateId() != null && this.getTemplateId() > 0L) {
            Template template = (Template)this.templateDao.getById(this.getTemplateId());
            emailDefinition.setEmailTemplate(template);
        }
        return emailDefinition;
    }

    public String doResetSettings() throws Exception {
        new OptionsCookieHelper().delete(ServletActionContext.getRequest(), ServletActionContext.getResponse());
        return this.getRedirect("/secure/com.metainf.jira.plugin.emailissue.action.EmailThisIssue!view.jspa?id=" + this.getIssueObject().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() throws Exception {
        block13: {
            block12: {
                Issue issue = this.getIssueObject();
                if (this.authorizer.authorize().isValid()) break block12;
                logger.warn((Object)"EmailThisIssue licence is invalid. Contact us at info@meta-inf.hu.");
                String string = this.getRedirect("/browse/" + this.getIssue().getString("key"));
                return string;
            }
            if (this.permissionChecker.isAllowedToSendIssueInEmail(this.getLoggedInUser(), this.getIssueObject())) break block13;
            String string = this.getRedirect("/browse/" + this.getIssue().getString("key"));
            return string;
        }
        try {
            this.attachFiles();
            EmailDefinition emailDefinition = this.toEmailDefinition(this.getSource());
            this.emailSender.sendEmailWithUserEditedSubjectAsync(emailDefinition, this.getEmailIssueSubject(), this.getLoggedInUser());
            if (!this.configurationManager.getGlobalConfiguration().isUserOptionsDisabled()) {
                OptionsCookieHelper cookieHelper = new OptionsCookieHelper();
                if (this.emailOptions != null && this.isSaveSettings()) {
                    cookieHelper.set(this.getSavedProperties(), ServletActionContext.getRequest(), ServletActionContext.getResponse());
                }
            }
        }
        catch (IssuePermissionException e) {
            String string = this.redirectToSessionTimeoutPage();
            return string;
        }
        catch (Exception e) {
            this.addErrorMessage(e.getMessage());
        }
        if (this.hasAnyErrors()) {
            return "input";
        }
        if (StringUtils.isNotBlank((String)this.getTransitionId())) {
            String relativeTransitionUrl = this.constructTransitionUrl(this.getTransitionId());
            return this.getRedirect(relativeTransitionUrl);
        }
        return this.getRedirect("/browse/" + this.getIssue().getString("key"));
    }

    private String constructTransitionUrl(String transitionId) {
        String url = "/WorkflowUIDispatcher.jspa?id=" + this.getIssueObject().getId() + "&action=" + transitionId;
        return url;
    }

    public String doPreview() {
        block9: {
            block8: {
                Issue issue = this.getIssueObject();
                if (this.authorizer.authorize().isValid()) break block8;
                logger.warn((Object)"EmailThisIssue licence is invalid. Contact us at info@meta-inf.hu.");
                String string = this.getRedirect("/browse/" + this.getIssue().getString("key"));
                return string;
            }
            if (this.permissionChecker.isAllowedToSendIssueInEmail(this.getLoggedInUser(), this.getIssueObject())) break block9;
            String string = this.getRedirect("/browse/" + this.getIssue().getString("key"));
            return string;
        }
        try {
            EmailDefinition emailDefinition = this.toEmailDefinition(EmailSource.PREVIEW);
            this.email = this.emailBuilder.buildEmail(emailDefinition, this.getEmailIssueSubject(), this.getLoggedInUser());
            this.initialize(this.configurationManager.getGlobalConfiguration());
        }
        catch (IssuePermissionException e) {
            String string = this.redirectToSessionTimeoutPage();
            return string;
        }
        catch (Exception e) {
            this.addErrorMessage(e.getMessage());
        }
        return "preview";
    }

    private Collection<ChangeItemBean> convertTemporaryAttachmentsInJIRA64(String[] temporaryAttachmentIds) {
        ArrayList<ChangeItemBean> changeItemBeans = new ArrayList<ChangeItemBean>();
        try {
            AttachmentsBulkOperationResult changeItemBeansResult = ((TemporaryWebAttachmentManager)ComponentAccessor.getComponentOfType(TemporaryWebAttachmentManager.class)).convertTemporaryAttachments(this.getLoggedInUser(), this.getIssueObject(), new ArrayList<String>(Arrays.asList(temporaryAttachmentIds)));
            if (changeItemBeansResult != null && changeItemBeansResult.getResults() != null && !changeItemBeansResult.getResults().isEmpty()) {
                changeItemBeans.addAll(changeItemBeansResult.getResults());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return changeItemBeans;
    }

    private void attachFiles() {
        if (this.isAttachmentsAllowed() && StringUtils.isNotBlank((String)this.getAttachedFiles())) {
            String[] temporaryAttachmentIds = this.getAttachedFiles().split(",");
            Collection<ChangeItemBean> changeItemBeans = this.convertTemporaryAttachmentsInJIRA64(temporaryAttachmentIds);
            IssueUpdateBean issueUpdateBean = new IssueUpdateBean(this.getIssue(), this.getIssue(), EventType.ISSUE_UPDATED_ID, this.getLoggedInUser());
            issueUpdateBean.setChangeItems(changeItemBeans);
            issueUpdateBean.setDispatchEvent(true);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("eventsource", "action");
            issueUpdateBean.setParams(params);
            this.issueUpdater.doUpdate(issueUpdateBean, true);
            HashSet<String> attachmentIds = new HashSet<String>();
            if (this.getAttachments() != null) {
                attachmentIds.addAll(Arrays.asList(this.getAttachments()));
            }
            for (ChangeItemBean cib : changeItemBeans) {
                attachmentIds.add(cib.getTo());
            }
            this.setAttachments(attachmentIds.toArray(new String[0]));
        }
    }

    public long getMaxSize() {
        long maxSize = -1L;
        try {
            maxSize = Long.parseLong(this.getApplicationProperties().getString("webwork.multipart.maxSize"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return maxSize;
    }

    public boolean isIssueActionsOrderAscending() {
        String value = this.getApplicationProperties().getString("jira.issue.actions.order");
        if (value == null) {
            value = this.getApplicationProperties().getDefaultString("jira.issue.actions.order");
        }
        return "asc".equalsIgnoreCase(value);
    }

    public String getMaxSizePretty() {
        long maxSize = this.getMaxSize();
        if (maxSize > 0L) {
            return FileSize.format((long)maxSize);
        }
        return "Unknown?";
    }

    public boolean isAttachmentsAllowed() {
        boolean allowed = this.attachmentManager.attachmentsEnabled();
        if (this.getLoggedInUser() != null) {
            allowed = allowed && this.getIssueManager().isEditable(this.getIssueObject(), this.getLoggedInUser());
            allowed = allowed && this.getPermissionManager().hasPermission(ProjectPermissions.CREATE_ATTACHMENTS, this.getIssueObject(), this.getLoggedInUser());
        }
        return allowed;
    }

    protected void putBooleanProperty(Map<String, String> properties, String propertyName) {
        try {
            Boolean b = (Boolean)PropertyUtils.getSimpleProperty((Object)this, (String)propertyName);
            properties.put(propertyName, b != null ? b.toString() : Boolean.FALSE.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void getBooleanProperty(StringBuffer sb, Map<String, String> properties, String propertyName) {
        if (properties.containsKey(propertyName)) {
            try {
                Boolean value = Boolean.valueOf(properties.get(propertyName));
                PropertyUtils.setSimpleProperty((Object)this, (String)propertyName, (Object)value);
                this.buildOptions(sb, propertyName, value.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public I18nHelper getI18n() {
        return this.i18n;
    }

    @Override
    public String getEmailIssueTo() {
        return this.emailIssueTo;
    }

    @Override
    public void setEmailIssueTo(String emailIssueTo) {
        this.emailIssueTo = emailIssueTo;
    }

    @Override
    public String getEmailIssueCc() {
        return this.emailIssueCc;
    }

    @Override
    public void setEmailIssueCc(String emailIssueCc) {
        this.emailIssueCc = emailIssueCc;
    }

    @Override
    public String getEmailIssueBcc() {
        return this.emailIssueBcc;
    }

    @Override
    public void setEmailIssueBcc(String emailIssueBcc) {
        this.emailIssueBcc = emailIssueBcc;
    }

    @Override
    public String getEmailIssueSubject() {
        return this.emailIssueSubject;
    }

    @Override
    public void setEmailIssueSubject(String emailIssueSubject) {
        this.emailIssueSubject = emailIssueSubject;
    }

    @Override
    public String getEmailIssueBody() {
        return this.emailIssueBody;
    }

    @Override
    public void setEmailIssueBody(String emailIssueBody) {
        this.emailIssueBody = emailIssueBody;
    }

    public String getSendEmailAction() {
        return this.sendEmailAction;
    }

    public void setSendEmailAction(String sendEmailAction) {
        this.sendEmailAction = sendEmailAction;
    }

    @Override
    public boolean isCommentVisibilityGroups() {
        return ComponentAccessor.getApplicationProperties().getOption("jira.comment.level.visibility.groups");
    }

    public String getDefaultEmailFormat() {
        String defaultFormat = this.userPreferencesManager.getExtendedPreferences(this.getLoggedInUser()).getString("user.notifications.mimetype");
        return StringUtils.isEmpty((String)defaultFormat) ? "html" : defaultFormat;
    }

    @Override
    public Attachment[] getAttachmentObjects() {
        Attachment[] attachments = this.getAttachments() == null ? null : new Attachment[this.getAttachments().length];
        for (int i = 0; this.getAttachments() != null && i < this.getAttachments().length; ++i) {
            attachments[i] = this.attachmentManager.getAttachment(Long.valueOf(Long.parseLong(this.getAttachments()[i])));
        }
        return attachments;
    }

    public List getAttachmentList() {
        return this.attachments == null ? Collections.EMPTY_LIST : Arrays.asList(this.attachments);
    }

    public String[] getAttachments() {
        return this.attachments;
    }

    public void setAttachments(String[] attachmentIds) {
        this.attachments = attachmentIds;
    }

    @Override
    public boolean isHasBrowseUserPermission() {
        return this.getLoggedInUser() != null && this.globalPermissionManager.hasPermission(GlobalPermissionKey.USER_PICKER, this.getLoggedInUser());
    }

    @Override
    public List<CustomField> getCustomFields() {
        try {
            List<CustomField> fields = CustomFieldUtil.filterFields(this.configurationManager.getGlobalConfiguration(), new ArrayList<CustomField>(this.customFieldManager.getCustomFieldObjects(this.getIssue())));
            return fields;
        }
        catch (IssuePermissionException e) {
            return Collections.EMPTY_LIST;
        }
    }

    public List<CustomField> getDisplayedCustomFields() {
        try {
            ArrayList<CustomField> fields = new ArrayList<CustomField>(this.customFieldManager.getCustomFieldObjects(this.getIssue()));
            Configuration globalConfiguration = this.configurationManager.getGlobalConfiguration();
            HashSet<String> hiddenFieldsFilter = StringUtils.isBlank((String)globalConfiguration.getHiddenFields()) ? null : new HashSet<String>(Arrays.asList(globalConfiguration.getHiddenFields().split(",")));
            Iterator it = fields.iterator();
            while (it.hasNext()) {
                CustomField customField = (CustomField)it.next();
                if (customField == null) continue;
                Object value = this.getIssueObject().getCustomFieldValue(customField);
                if (customField.isShown(this.getIssueObject()) && value != null && (!(value instanceof Collection) || !((Collection)value).isEmpty()) && (hiddenFieldsFilter == null || !hiddenFieldsFilter.contains(customField.getId()))) continue;
                it.remove();
            }
            return fields;
        }
        catch (IssuePermissionException e) {
            return Collections.EMPTY_LIST;
        }
    }

    public String renderCustomField(CustomField customField) {
        if (customField == null) {
            return null;
        }
        FieldLayoutItem fli = this.fieldLayoutManager.getFieldLayout(this.getIssueObject()).getFieldLayoutItem((OrderableField)customField);
        return customField.getViewHtml(fli, (Action)this, this.getIssueObject());
    }

    @Override
    public Collection<ProjectRole> getProjectRoles() {
        ArrayList<ProjectRole> roles = new ArrayList<ProjectRole>(this.projectRoleManager.getProjectRoles());
        GlobalConfigHelper.excludeRoles(this.configurationManager.getGlobalConfiguration(), roles);
        return roles;
    }

    @Override
    public Collection<Group> getGroups() {
        ArrayList<Group> groups = new ArrayList<Group>(this.userResolver.getAllUserGroups());
        GlobalConfigHelper.excludeGroups(this.configurationManager.getGlobalConfiguration(), groups);
        return groups;
    }

    @Override
    public Collection<String> getUserGroups() {
        ApplicationUser user = ComponentAccessor.getJiraAuthenticationContext().getUser();
        if (user == null) {
            return Collections.EMPTY_LIST;
        }
        return this.groupManager.getGroupNamesForUser(user);
    }

    @Override
    public Collection<ProjectRole> getUserRoles() {
        return this.projectRoleManager.getProjectRoles(this.getLoggedInUser(), this.getIssueObject().getProjectObject());
    }

    public Collection<Comment> getIssueComments() {
        List comments = this.commentManager.getCommentsForUser(this.getIssueObject(), this.getLoggedInUser());
        Collections.sort(comments, new CommentComparator());
        if (!this.isIssueActionsOrderAscending()) {
            Collections.reverse(comments);
        }
        return comments;
    }

    public Configuration getGlobalProperties() {
        return this.configurationManager.getGlobalConfiguration();
    }

    public boolean isBypassComment() {
        return this.emailOptions.isBypassComment();
    }

    public void setBypassComment(boolean bypassComment) {
        this.emailOptions.setBypassComment(bypassComment);
    }

    @Override
    public boolean isBypassCommentAllowed() {
        return this.configurationManager.getGlobalConfiguration().getBypassComment() == 1;
    }

    public boolean isBccEnabled() {
        return this.configurationManager.getGlobalConfiguration().isBccEnabled();
    }

    @Override
    public List<Recipient> getRecipientObjects() {
        ArrayList<Recipient> recipients = new ArrayList<Recipient>(this.recipientIndex.values());
        Collections.sort(recipients);
        return recipients;
    }

    @Override
    public List<Recipient> getCopyrecipientObjects() {
        ArrayList<Recipient> recipients = new ArrayList<Recipient>(this.copyrecipientIndex.values());
        Collections.sort(recipients);
        return recipients;
    }

    @Override
    public List<Recipient> getBlindCopyrecipientObjects() {
        ArrayList<Recipient> recipients = new ArrayList<Recipient>(this.blindcopyrecipientIndex.values());
        Collections.sort(recipients);
        return recipients;
    }

    @Override
    public String[] getRecipients() {
        return this.recipients;
    }

    @Override
    public void setRecipients(String[] recipients) {
        this.recipientIndex = this.buildRecipients(recipients);
    }

    @Override
    public String[] getCopyrecipients() {
        return this.copyrecipients;
    }

    @Override
    public void setCopyrecipients(String[] copyrecipients) {
        this.copyrecipientIndex = this.buildRecipients(copyrecipients);
    }

    @Override
    public String[] getBlindcopyrecipients() {
        return this.blindcopyrecipients;
    }

    @Override
    public void setBlindcopyrecipients(String[] blindcopyrecipients) {
        this.blindcopyrecipientIndex = this.buildRecipients(blindcopyrecipients);
    }

    @Override
    public boolean isRecipientSelected(String key) {
        return this.recipientIndex.containsKey(key);
    }

    @Override
    public boolean isCopyRecipientSelected(String key) {
        return this.copyrecipientIndex.containsKey(key);
    }

    public boolean isBlindCopyRecipientSelected(String key) {
        return this.blindcopyrecipientIndex.containsKey(key);
    }

    public Map<String, Recipient> buildRecipients(String[] recipientKeys) {
        return Recipient.buildRecipients(recipientKeys, this.customFieldManager, this.groupManager, this.projectRoleManager, this.i18n);
    }

    public TemplateIssue getTemplateIssue() {
        TemplateIssueFactory tif = (TemplateIssueFactory)ComponentAccessor.getComponentOfType(TemplateIssueFactory.class);
        return tif.getTemplateIssue(this.getIssueObject());
    }

    public String formatDate(Date date) {
        return date == null ? "" : this.dateTimeFormatter.format(date);
    }

    public RendererManager getRendererManager() {
        return this.rendererManager;
    }

    @Override
    public String getOptions() {
        return this.emailOptions == null ? null : this.emailOptions.toString();
    }

    @Override
    public void setOptions(String options) {
        this.emailOptions = new EmailOptions(options);
    }

    @Override
    public EmailOptions getEmailOptions() {
        return this.emailOptions;
    }

    public boolean isSaveSettings() {
        return this.saveSettings;
    }

    public void setSaveSettings(boolean saveSettings) {
        this.saveSettings = saveSettings;
    }

    protected String redirectToSessionTimeoutPage() {
        return "sessionTimeout";
    }

    @Override
    public String getAddAttachments() {
        throw new UnsupportedOperationException();
    }

    public boolean isUserOptionsEnabled() {
        return !this.configurationManager.getGlobalConfiguration().isUserOptionsDisabled();
    }

    public List<AttachmentInfo> getIssueAttachments() {
        ArrayList<AttachmentInfo> attachmentInfo = new ArrayList<AttachmentInfo>(AttachmentInfo.fromAttachments(this.getIssueObject().getAttachments(), this.dateTimeFormatter));
        return attachmentInfo;
    }

    public boolean isAddToWatchers() {
        return this.emailOptions.isAddToWatchers();
    }

    public void setAddToWatchers(boolean addToWatchers) {
        this.emailOptions.setAddToWatchers(addToWatchers);
    }

    public boolean isReplyToMe() {
        return this.emailOptions.isReplyToMe();
    }

    public void setReplyToMe(boolean replyToMe) {
        this.emailOptions.setReplyToMe(replyToMe);
    }

    public boolean isMailAsMe() {
        return this.emailOptions.isMailAsMe();
    }

    public void setMailAsMe(boolean mailAsMe) {
        this.emailOptions.setMailAsMe(mailAsMe);
    }

    public boolean isAddComments() {
        return this.emailOptions.isAddComments();
    }

    public void setAddComments(boolean addComments) {
        this.emailOptions.setAddComments(addComments);
    }

    public boolean isSuppressCommentEvent() {
        return this.emailOptions.isSuppressCommentEvent();
    }

    public void setSuppressCommentEvent(boolean suppressCommentEvent) {
        this.emailOptions.setSuppressCommentEvent(suppressCommentEvent);
    }

    public String getEmailFormat() {
        return this.emailOptions.getEmailFormat();
    }

    public void setEmailFormat(String emailFormat) {
        this.emailOptions.setEmailFormat(emailFormat);
    }

    public String getCommentVisibility() {
        return this.emailOptions.getCommentVisibility();
    }

    public void setCommentVisibility(String commentVisibility) {
        this.emailOptions.setCommentVisibility(commentVisibility);
    }

    @Override
    public boolean isCommentVisibilitySelected(String cv) {
        return this.getCommentVisibility() != null && this.getCommentVisibility().equals(cv);
    }

    @Override
    public Template getEmailTemplate() {
        return null;
    }

    @Override
    public Map<String, Object> getVelocityContext() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public IssueEvent getIssueEvent() {
        return null;
    }

    @Override
    public Long getEventTypeId() {
        return this.configurationManager.getGlobalConfiguration().getEventId();
    }

    @Override
    public EmailSource getSource() {
        return EmailSource.OPERATION;
    }

    public boolean isUserAllowedToCommentIssue() {
        return this.permissionManager.hasPermission(ProjectPermissions.ADD_COMMENTS, this.getIssueObject(), this.getLoggedInUser());
    }

    public Collection<CannedResponse> getResponses(String category) {
        ArrayList<CannedResponse> responses = new ArrayList<CannedResponse>();
        if (StringUtils.isBlank((String)category)) {
            responses.addAll(Arrays.asList(this.cannedResponseDao.filterAndOrder("LABELS = '' OR LABELS IS NULL", "NAME ASC", new Object[0])));
        } else {
            responses.addAll(Arrays.asList(this.cannedResponseDao.filterAndOrder("LABELS = ?", "NAME ASC", new Object[]{category})));
        }
        return responses;
    }

    public String getCommentRenderer() {
        FieldLayoutItem fyi = this.fieldLayoutManager.getFieldLayout(this.getIssueObject()).getFieldLayoutItem("comment");
        return fyi != null ? fyi.getRendererType() : Renderer.WIKI.getKey();
    }

    @Override
    public String getComment() {
        return null;
    }

    public List<AttachmentInfo> getThumbnailableAttachments() {
        List<AttachmentInfo> thumbnailables = this.getIssueAttachments();
        Iterator<AttachmentInfo> it = thumbnailables.iterator();
        while (it.hasNext()) {
            if (it.next().isThumbnailable()) continue;
            it.remove();
        }
        return thumbnailables;
    }

    private boolean isImageAttachment(Attachment attachment) {
        return attachment != null && attachment.getMimetype() != null && attachment.getMimetype().startsWith("image/");
    }

    @Override
    public boolean isHasExternalRecipients() {
        return this.hasExternalRecipients;
    }

    @Override
    public void setHasExternalRecipients(boolean hasExternalRecipients) {
        this.hasExternalRecipients = hasExternalRecipients;
    }

    public String getAttachedFiles() {
        return this.attachedFiles;
    }

    public void setAttachedFiles(String attachedFiles) {
        this.attachedFiles = attachedFiles;
    }

    @Override
    public Comment getCommentObject() {
        return null;
    }

    public boolean isSupportsAjaxAttachments() {
        String ua = ActionContext.getRequest().getHeader("User-Agent");
        boolean isMSIE9 = ua != null && ua.indexOf("MSIE 9") != -1;
        boolean isMSIE8 = ua != null && ua.indexOf("MSIE 8") != -1;
        return !isMSIE8 && !isMSIE9;
    }

    public String[] getResponseCategories() {
        return this.responseCategories;
    }

    public SmartEmail getEmail() {
        return this.email;
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public List<Template> getEmailTemplates(String category) {
        LinkedList<Template> templates = new LinkedList<Template>();
        if (StringUtils.isBlank((String)category) || "(no category)".equals(category)) {
            templates.addAll(Arrays.asList(this.templateDao.filterAndOrder("LABELS = '' OR LABELS IS NULL", "NAME ASC", new Object[0])));
        } else {
            templates.addAll(Arrays.asList(this.templateDao.filterAndOrder("LABELS = ?", "NAME ASC", new Object[]{category})));
        }
        Collections.sort(templates, new Template.EntityComparator());
        return templates;
    }

    public Template getEmailTemplateFromContext() {
        return this.context != null && this.context.getTemplate() != null ? this.context.getTemplate() : new DefaultTemplate();
    }

    public Collection<String> getTemplateCategories() {
        return this.templateCategories;
    }

    public Long getAuditId() {
        return this.auditId;
    }

    public void setAuditId(Long auditId) {
        this.auditId = auditId;
    }

    @Override
    public ApplicationUser getRemoteUser() {
        return this.getLoggedInUser();
    }

    public EditorType getEditorType() {
        return this.editorType;
    }

    public void setEditorTypeName(String editorTypeName) {
        this.editorType = Enums.valueOf(editorTypeName, EditorType.WIKI);
    }

    @Override
    public boolean isCustomerNotification() {
        return false;
    }

    public List<String> getFromAddresses() {
        return this.fromAddresses;
    }

    @Override
    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public List<ActionDescriptor> getTransitions() {
        List<ActionDescriptor> transitions = this.issueTransitioner.getTransitions(this.getIssueObject(), "jeti.on.send.email.transition", "true");
        return transitions;
    }

    public String getTransitionId() {
        return this.transitionId;
    }

    public void setTransitionId(String transitionId) {
        this.transitionId = transitionId;
    }
}

