/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action;

import com.metainf.jira.plugin.emailissue.action.EmailOptions;
import com.metainf.jira.plugin.emailissue.action.EmailSupport;
import com.metainf.jira.plugin.emailissue.action.GlobalConfigHelper;
import com.metainf.jira.plugin.emailissue.entity.Configuration;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class EmailSupportOptionsInitializer {
    public static void initalizeEmailOptions(EmailSupport emailSupport, Map<String, String> userSpecificOptions, Configuration globalProperties) {
        if (userSpecificOptions == null || userSpecificOptions.isEmpty()) {
            EmailOptions emailOptions = new EmailOptions(globalProperties);
            emailSupport.setOptions(emailOptions.toString());
            if (StringUtils.isNotEmpty((String)globalProperties.getEmailIssueTo())) {
                emailSupport.setEmailIssueTo(globalProperties.getEmailIssueTo());
            }
            if (StringUtils.isNotEmpty((String)globalProperties.getEmailIssueCc())) {
                emailSupport.setEmailIssueCc(globalProperties.getEmailIssueCc());
            }
            if (StringUtils.isNotEmpty((String)globalProperties.getEmailIssueBcc())) {
                emailSupport.setEmailIssueBcc(globalProperties.getEmailIssueBcc());
            }
            if (StringUtils.isNotEmpty((String)globalProperties.getRecipients())) {
                emailSupport.setRecipients(globalProperties.getRecipients().split(","));
            }
            if (StringUtils.isNotEmpty((String)globalProperties.getCopyrecipients())) {
                emailSupport.setCopyrecipients(globalProperties.getCopyrecipients().split(","));
            }
            if (StringUtils.isNotEmpty((String)globalProperties.getBlindcopyrecipients())) {
                emailSupport.setBlindcopyrecipients(globalProperties.getBlindcopyrecipients().split(","));
            }
        } else {
            emailSupport.setOptions(userSpecificOptions.containsKey("emailOptions") ? userSpecificOptions.get("emailOptions") : "");
            String value = userSpecificOptions.get("emailIssueTo");
            if (StringUtils.isNotEmpty((String)value)) {
                emailSupport.setEmailIssueTo(value);
            }
            if (StringUtils.isNotEmpty((String)(value = userSpecificOptions.get("emailIssueCc")))) {
                emailSupport.setEmailIssueCc(value);
            }
            if (StringUtils.isNotEmpty((String)(value = userSpecificOptions.get("emailIssueBcc")))) {
                emailSupport.setEmailIssueBcc(value);
            }
            if (StringUtils.isNotEmpty((String)(value = userSpecificOptions.get("recipients")))) {
                emailSupport.setRecipients(value.split(","));
            }
            if (StringUtils.isNotEmpty((String)(value = userSpecificOptions.get("copyrecipients")))) {
                emailSupport.setCopyrecipients(value.split(","));
            }
            if (StringUtils.isNotEmpty((String)(value = userSpecificOptions.get("blindcopyrecipients")))) {
                emailSupport.setBlindcopyrecipients(value.split(","));
            }
        }
    }

    public static void initalizeEmailOptions(Configuration options) {
        Map<String, String> globalOptions = GlobalConfigHelper.loadGlobalParameters();
        if (globalOptions != null && !globalOptions.isEmpty()) {
            options.setEmailIssueTo(globalOptions.get("emailIssueTo"));
            options.setEmailIssueCc(globalOptions.get("emailIssueCc"));
            options.setEmailIssueBcc(globalOptions.get("emailIssueBcc"));
            options.setRecipients(globalOptions.get("recipients"));
            options.setCopyrecipients(globalOptions.get("copyrecipients"));
            options.setBlindcopyrecipients(globalOptions.get("blindcopyrecipients"));
            EmailOptions emailOptions = new EmailOptions(globalOptions.containsKey("emailOptions") ? globalOptions.get("emailOptions") : "");
            options.setAddComments(emailOptions.isAddComments() ? 1 : 0);
            options.setAddToWatchers(emailOptions.isAddToWatchers() ? 1 : 0);
            options.setBypassComment(emailOptions.isBypassComment() ? 1 : 0);
            options.setCommentVisibility(emailOptions.getCommentVisibility());
            options.setEmailFormat(emailOptions.getEmailFormat());
            options.setEventId(globalOptions.containsKey("send.email.event.id") ? Long.valueOf(Long.parseLong(globalOptions.get("send.email.event.id"))) : null);
            options.setMailAsMe(emailOptions.isMailAsMe() ? 1 : 0);
            options.setReplyToMe(emailOptions.isReplyToMe() ? 1 : 0);
            options.setSuppressCommentEvent(emailOptions.isSuppressCommentEvent() ? 1 : 0);
            options.setProjectUserRecipients(globalOptions.containsKey("restrict.recipients.to.jira.user") && Boolean.valueOf(globalOptions.containsKey("restrict.recipients.to.jira.user")) != false ? 1 : 0);
        }
    }
}

