/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action;

import com.metainf.jira.plugin.emailissue.entity.Configuration;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EmailOptions {
    private static final String DEFAULT_EMAIL_FORMAT = "html";
    private boolean addToWatchers;
    private boolean replyToMe;
    private boolean mailAsMe;
    private boolean addComments;
    private boolean bypassComment;
    private boolean suppressCommentEvent;
    private boolean ignoreMyChanges;
    private String emailFormat;
    private String commentVisibility;
    private boolean richHtml;

    public EmailOptions() {
    }

    public EmailOptions(Configuration globalParameters) {
        this.addToWatchers = globalParameters.getAddToWatchers() == 1;
        this.replyToMe = globalParameters.getReplyToMe() == 1;
        this.mailAsMe = globalParameters.getMailAsMe() == 1;
        this.addComments = globalParameters.getAddComments() == 1;
        this.bypassComment = globalParameters.getBypassComment() == 1;
        this.suppressCommentEvent = globalParameters.getSuppressCommentEvent() == 1;
        this.emailFormat = globalParameters.getEmailFormat();
        this.commentVisibility = globalParameters.getCommentVisibility();
    }

    public EmailOptions(Map<String, String> properties) {
        for (Option o : Option.values()) {
            String value = properties.get(o.getAttributeName());
            try {
                if (value == null) continue;
                PropertyUtils.setSimpleProperty((Object)this, (String)o.getAttributeName(), (Object)(this.isBoolean(value) ? Boolean.valueOf(value) : value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isBoolean(String value) {
        return Boolean.TRUE.toString().equalsIgnoreCase(value) || Boolean.FALSE.toString().equalsIgnoreCase(value);
    }

    public EmailOptions(String options) {
        if (StringUtils.isNotEmpty((String)options)) {
            String[] tokens;
            for (String token : tokens = options.split(",")) {
                String value;
                if (!StringUtils.isNotEmpty((String)token)) continue;
                String[] parts = token.split("=");
                String key = parts[0] != null ? parts[0].trim() : null;
                String string = value = parts.length > 1 && parts[1] != null ? parts[1].trim() : null;
                if (!StringUtils.isNotEmpty((String)key)) continue;
                try {
                    PropertyUtils.setSimpleProperty((Object)this, (String)key, (Object)(this.isBoolean(value) ? Boolean.valueOf(value) : value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isAddToWatchers() {
        return this.addToWatchers;
    }

    public void setAddToWatchers(boolean addToWatchers) {
        this.addToWatchers = addToWatchers;
    }

    public boolean isReplyToMe() {
        return this.replyToMe;
    }

    public void setReplyToMe(boolean replyToMe) {
        this.replyToMe = replyToMe;
    }

    public boolean isAddComments() {
        return this.addComments;
    }

    public void setAddComments(boolean addComments) {
        this.addComments = addComments;
    }

    public boolean isBypassComment() {
        return this.bypassComment;
    }

    public void setBypassComment(boolean bypassComment) {
        this.bypassComment = bypassComment;
    }

    public boolean isSuppressCommentEvent() {
        return this.suppressCommentEvent;
    }

    public void setSuppressCommentEvent(boolean suppressCommentEvent) {
        this.suppressCommentEvent = suppressCommentEvent;
    }

    public String getEmailFormat() {
        return StringUtils.isEmpty((String)this.emailFormat) ? DEFAULT_EMAIL_FORMAT : this.emailFormat;
    }

    public void setEmailFormat(String emailFormat) {
        this.emailFormat = emailFormat;
    }

    public String getCommentVisibility() {
        return this.commentVisibility;
    }

    public void setCommentVisibility(String commentVisibility) {
        this.commentVisibility = commentVisibility;
    }

    public boolean isMailAsMe() {
        return this.mailAsMe;
    }

    public void setMailAsMe(boolean mailAsMe) {
        this.mailAsMe = mailAsMe;
    }

    public boolean isIgnoreMyChanges() {
        return this.ignoreMyChanges;
    }

    public void setIgnoreMyChanges(boolean ignoreMyChanges) {
        this.ignoreMyChanges = ignoreMyChanges;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Option o : Option.values()) {
            try {
                Object value = PropertyUtils.getSimpleProperty((Object)this, (String)o.getAttributeName());
                if (value == null) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(o.getAttributeName()).append("=").append(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    public boolean isRichHtml() {
        return this.richHtml;
    }

    public void setRichHtml(boolean richHtml) {
        this.richHtml = richHtml;
    }

    public static enum Option {
        ADD_2_WATCHERS("addToWatchers"),
        MAIL_AS_ME("mailAsMe"),
        REPLY_TO_ME("replyToMe"),
        FORMAT("emailFormat"),
        ADD_COMMENTS("addComments"),
        COMMENT_VISIBILITY("commentVisibility"),
        BYPASS_COMMENT("bypassComment"),
        SURPRESS_COMMENT("suppressCommentEvent"),
        IGNORE_MY_CHANGES("ignoreMyChanges");

        private String attribute;

        private Option(String name) {
            this.attribute = name;
        }

        public String getAttributeName() {
            return this.attribute;
        }
    }
}

